/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.staticontent.spi.visitor;

import io.thestencil.client.api.StencilClient;
import io.thestencil.staticontent.api.ImmutableLinkResource;
import io.thestencil.staticontent.api.ImmutableMarkdown;
import io.thestencil.staticontent.api.ImmutableMarkdowns;
import io.thestencil.staticontent.api.StaticContentClient;
import io.thestencil.staticontent.spi.visitor.MarkdownVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteStateVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SiteStateVisitor.class);
    public static String LINK_TYPE_WORKFLOW = "workflow";
    private final List<StencilClient.Entity<StencilClient.Locale>> locales = new ArrayList<StencilClient.Entity<StencilClient.Locale>>();
    private final Map<String, StencilClient.Entity<StencilClient.Locale>> enablesLocales = new HashMap<String, StencilClient.Entity<StencilClient.Locale>>();
    private StencilClient.SiteState entity;
    private final boolean dev;

    public SiteStateVisitor(boolean dev) {
        this.dev = dev;
    }

    public StaticContentClient.Markdowns visit(StencilClient.SiteState entity) {
        this.entity = entity;
        ImmutableMarkdowns.Builder result = ImmutableMarkdowns.builder().addAllLocales(this.visitLocales(entity).stream().map(e -> ((StencilClient.Locale)e.getBody()).getValue()).collect(Collectors.toList()));
        for (StencilClient.Entity article : entity.getArticles().values()) {
            result.addAllValues(this.visitArticle((StencilClient.Entity<StencilClient.Article>)article));
        }
        for (StencilClient.Entity link : entity.getLinks().values()) {
            result.addAllLinks(this.visitLinks((StencilClient.Entity<StencilClient.Link>)link));
        }
        for (StencilClient.Entity link : entity.getWorkflows().values()) {
            result.addAllLinks(this.visitWorkflows((StencilClient.Entity<StencilClient.Workflow>)link));
        }
        return result.build();
    }

    private List<StaticContentClient.LinkResource> visitWorkflows(StencilClient.Entity<StencilClient.Workflow> link) {
        ArrayList<StaticContentClient.LinkResource> result = new ArrayList<StaticContentClient.LinkResource>();
        if (!this.dev && Boolean.TRUE.equals(((StencilClient.Workflow)link.getBody()).getDevMode())) {
            return result;
        }
        List usedLocales = ((StencilClient.Workflow)link.getBody()).getLabels().stream().map(label -> label.getLocale()).collect(Collectors.toList());
        if (this.locales.stream().filter(l -> usedLocales.contains(l.getId())).findFirst().isEmpty()) {
            return result;
        }
        for (String articleId : ((StencilClient.Workflow)link.getBody()).getArticles()) {
            StencilClient.Entity article = (StencilClient.Entity)this.entity.getArticles().get(articleId);
            for (StencilClient.LocaleLabel label2 : ((StencilClient.Workflow)link.getBody()).getLabels()) {
                if (!this.enablesLocales.keySet().contains(label2.getLocale())) continue;
                StencilClient.Entity<StencilClient.Locale> locale = this.enablesLocales.get(label2.getLocale());
                ImmutableLinkResource resource = ImmutableLinkResource.builder().id(link.getId() + "-" + ((StencilClient.Locale)locale.getBody()).getValue()).addLocale(((StencilClient.Locale)locale.getBody()).getValue()).desc(label2.getLabelValue()).path(this.visitArticlePath((StencilClient.Entity<StencilClient.Article>)article)).value(((StencilClient.Workflow)link.getBody()).getValue()).workflow(true).global(false).type(LINK_TYPE_WORKFLOW).build();
                result.add(resource);
            }
        }
        if (((StencilClient.Workflow)link.getBody()).getArticles().isEmpty()) {
            for (StencilClient.Entity article : this.entity.getArticles().values()) {
                for (StencilClient.LocaleLabel label3 : ((StencilClient.Workflow)link.getBody()).getLabels()) {
                    if (!this.enablesLocales.keySet().contains(label3.getLocale())) continue;
                    StencilClient.Entity<StencilClient.Locale> locale = this.enablesLocales.get(label3.getLocale());
                    ImmutableLinkResource resource = ImmutableLinkResource.builder().id(link.getId() + "-" + ((StencilClient.Locale)locale.getBody()).getValue()).addLocale(((StencilClient.Locale)locale.getBody()).getValue()).desc(label3.getLabelValue()).path(this.visitArticlePath((StencilClient.Entity<StencilClient.Article>)article)).value(((StencilClient.Workflow)link.getBody()).getValue()).workflow(true).global(true).type(LINK_TYPE_WORKFLOW).build();
                    result.add(resource);
                }
            }
        }
        return result;
    }

    private List<StaticContentClient.LinkResource> visitLinks(StencilClient.Entity<StencilClient.Link> link) {
        ArrayList<StaticContentClient.LinkResource> result = new ArrayList<StaticContentClient.LinkResource>();
        List usedLocales = ((StencilClient.Link)link.getBody()).getLabels().stream().map(label -> label.getLocale()).collect(Collectors.toList());
        if (this.locales.stream().filter(l -> usedLocales.contains(l.getId())).findFirst().isEmpty()) {
            return result;
        }
        for (String articleId : ((StencilClient.Link)link.getBody()).getArticles()) {
            StencilClient.Entity article = (StencilClient.Entity)this.entity.getArticles().get(articleId);
            for (StencilClient.LocaleLabel label2 : ((StencilClient.Link)link.getBody()).getLabels()) {
                if (!this.enablesLocales.keySet().contains(label2.getLocale())) continue;
                StencilClient.Entity<StencilClient.Locale> locale = this.enablesLocales.get(label2.getLocale());
                ImmutableLinkResource resource = ImmutableLinkResource.builder().id(link.getId() + "-" + ((StencilClient.Locale)locale.getBody()).getValue()).addLocale(((StencilClient.Locale)locale.getBody()).getValue()).desc(label2.getLabelValue()).path(this.visitArticlePath((StencilClient.Entity<StencilClient.Article>)article)).value(((StencilClient.Link)link.getBody()).getValue()).workflow(false).global(false).type(((StencilClient.Link)link.getBody()).getContentType()).build();
                result.add(resource);
            }
        }
        if (((StencilClient.Link)link.getBody()).getArticles().isEmpty()) {
            for (StencilClient.Entity article : this.entity.getArticles().values()) {
                for (StencilClient.LocaleLabel label3 : ((StencilClient.Link)link.getBody()).getLabels()) {
                    if (!this.enablesLocales.keySet().contains(label3.getLocale())) continue;
                    StencilClient.Entity<StencilClient.Locale> locale = this.enablesLocales.get(label3.getLocale());
                    ImmutableLinkResource resource = ImmutableLinkResource.builder().id(link.getId() + "-" + ((StencilClient.Locale)locale.getBody()).getValue()).addLocale(((StencilClient.Locale)locale.getBody()).getValue()).desc(label3.getLabelValue()).path(this.visitArticlePath((StencilClient.Entity<StencilClient.Article>)article)).value(((StencilClient.Link)link.getBody()).getValue()).workflow(false).global(true).type(((StencilClient.Link)link.getBody()).getContentType()).build();
                    result.add(resource);
                }
            }
        }
        return result;
    }

    private List<StaticContentClient.Markdown> visitArticle(StencilClient.Entity<StencilClient.Article> article) {
        String path = this.visitArticlePath(article);
        ArrayList<StaticContentClient.Markdown> result = new ArrayList<StaticContentClient.Markdown>();
        for (StencilClient.Entity page : this.entity.getPages().values()) {
            Optional<StencilClient.Entity> locale;
            if (!((StencilClient.Page)page.getBody()).getArticle().equals(article.getId()) || (locale = this.locales.stream().filter(l -> ((StencilClient.Page)page.getBody()).getLocale().equals(l.getId())).findFirst()).isEmpty()) continue;
            String content = ((StencilClient.Page)page.getBody()).getContent();
            MarkdownVisitor.MarkdownAst ast = new MarkdownVisitor().visit(content);
            if (ast.getHeadings().stream().filter(entity -> entity.getLevel() == 1).findFirst().isEmpty()) {
                LOGGER.error("Failed to parse article '" + ((StencilClient.Article)article.getBody()).getName() + "', markdown must have atleast one h1(line starting with one # my super menu)");
            }
            result.add(ImmutableMarkdown.builder().path(path).locale(((StencilClient.Locale)locale.get().getBody()).getValue()).value(content).addAllHeadings(ast.getHeadings()).build());
        }
        return result;
    }

    private String visitArticlePath(StencilClient.Entity<StencilClient.Article> src) {
        String parentId;
        StringBuilder path = new StringBuilder();
        StencilClient.Entity<StencilClient.Article> article = src;
        do {
            if (path.length() > 0) {
                path.insert(0, "/");
            }
            path.insert(0, String.format("%03d", ((StencilClient.Article)article.getBody()).getOrder()) + "_" + ((StencilClient.Article)article.getBody()).getName());
        } while ((article = (parentId = ((StencilClient.Article)article.getBody()).getParentId()) == null ? null : (StencilClient.Entity)this.entity.getArticles().get(parentId)) != null);
        return path.toString();
    }

    private List<StencilClient.Entity<StencilClient.Locale>> visitLocales(StencilClient.SiteState site) {
        this.locales.addAll(site.getLocales().values().stream().filter(l -> ((StencilClient.Locale)l.getBody()).getEnabled()).collect(Collectors.toList()));
        this.enablesLocales.putAll(this.locales.stream().collect(Collectors.toMap(e -> e.getId(), e -> e)));
        return this.locales;
    }
}

