package io.thestencil.staticontent.api;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StaticContentClient.LinkResource}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLinkResource.builder()}.
 */
@Generated(from = "StaticContentClient.LinkResource", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableLinkResource
    implements StaticContentClient.LinkResource {
  private final String id;
  private final String type;
  private final String path;
  private final String value;
  private final ImmutableList<String> locale;
  private final Boolean workflow;
  private final Boolean global;
  private final @Nullable String desc;

  private ImmutableLinkResource(
      String id,
      String type,
      String path,
      String value,
      ImmutableList<String> locale,
      Boolean workflow,
      Boolean global,
      @Nullable String desc) {
    this.id = id;
    this.type = type;
    this.path = path;
    this.value = value;
    this.locale = locale;
    this.workflow = workflow;
    this.global = global;
    this.desc = desc;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code path} attribute
   */
  @Override
  public String getPath() {
    return path;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public String getValue() {
    return value;
  }

  /**
   * @return The value of the {@code locale} attribute
   */
  @Override
  public ImmutableList<String> getLocale() {
    return locale;
  }

  /**
   * @return The value of the {@code workflow} attribute
   */
  @Override
  public Boolean getWorkflow() {
    return workflow;
  }

  /**
   * @return The value of the {@code global} attribute
   */
  @Override
  public Boolean getGlobal() {
    return global;
  }

  /**
   * @return The value of the {@code desc} attribute
   */
  @Override
  public @Nullable String getDesc() {
    return desc;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StaticContentClient.LinkResource#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLinkResource withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableLinkResource(newValue, this.type, this.path, this.value, this.locale, this.workflow, this.global, this.desc);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StaticContentClient.LinkResource#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLinkResource withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableLinkResource(this.id, newValue, this.path, this.value, this.locale, this.workflow, this.global, this.desc);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StaticContentClient.LinkResource#getPath() path} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for path
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLinkResource withPath(String value) {
    String newValue = Objects.requireNonNull(value, "path");
    if (this.path.equals(newValue)) return this;
    return new ImmutableLinkResource(this.id, this.type, newValue, this.value, this.locale, this.workflow, this.global, this.desc);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StaticContentClient.LinkResource#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLinkResource withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableLinkResource(this.id, this.type, this.path, newValue, this.locale, this.workflow, this.global, this.desc);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StaticContentClient.LinkResource#getLocale() locale}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLinkResource withLocale(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableLinkResource(this.id, this.type, this.path, this.value, newValue, this.workflow, this.global, this.desc);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StaticContentClient.LinkResource#getLocale() locale}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of locale elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLinkResource withLocale(Iterable<String> elements) {
    if (this.locale == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableLinkResource(this.id, this.type, this.path, this.value, newValue, this.workflow, this.global, this.desc);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StaticContentClient.LinkResource#getWorkflow() workflow} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for workflow
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLinkResource withWorkflow(Boolean value) {
    Boolean newValue = Objects.requireNonNull(value, "workflow");
    if (this.workflow.equals(newValue)) return this;
    return new ImmutableLinkResource(this.id, this.type, this.path, this.value, this.locale, newValue, this.global, this.desc);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StaticContentClient.LinkResource#getGlobal() global} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for global
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLinkResource withGlobal(Boolean value) {
    Boolean newValue = Objects.requireNonNull(value, "global");
    if (this.global.equals(newValue)) return this;
    return new ImmutableLinkResource(this.id, this.type, this.path, this.value, this.locale, this.workflow, newValue, this.desc);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StaticContentClient.LinkResource#getDesc() desc} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for desc (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLinkResource withDesc(@Nullable String value) {
    if (Objects.equals(this.desc, value)) return this;
    return new ImmutableLinkResource(this.id, this.type, this.path, this.value, this.locale, this.workflow, this.global, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLinkResource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLinkResource
        && equalTo((ImmutableLinkResource) another);
  }

  private boolean equalTo(ImmutableLinkResource another) {
    return id.equals(another.id)
        && type.equals(another.type)
        && path.equals(another.path)
        && value.equals(another.value)
        && locale.equals(another.locale)
        && workflow.equals(another.workflow)
        && global.equals(another.global)
        && Objects.equals(desc, another.desc);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code type}, {@code path}, {@code value}, {@code locale}, {@code workflow}, {@code global}, {@code desc}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + path.hashCode();
    h += (h << 5) + value.hashCode();
    h += (h << 5) + locale.hashCode();
    h += (h << 5) + workflow.hashCode();
    h += (h << 5) + global.hashCode();
    h += (h << 5) + Objects.hashCode(desc);
    return h;
  }

  /**
   * Prints the immutable value {@code LinkResource} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("LinkResource")
        .omitNullValues()
        .add("id", id)
        .add("type", type)
        .add("path", path)
        .add("value", value)
        .add("locale", locale)
        .add("workflow", workflow)
        .add("global", global)
        .add("desc", desc)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link StaticContentClient.LinkResource} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable LinkResource instance
   */
  public static ImmutableLinkResource copyOf(StaticContentClient.LinkResource instance) {
    if (instance instanceof ImmutableLinkResource) {
      return (ImmutableLinkResource) instance;
    }
    return ImmutableLinkResource.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLinkResource ImmutableLinkResource}.
   * <pre>
   * ImmutableLinkResource.builder()
   *    .id(String) // required {@link StaticContentClient.LinkResource#getId() id}
   *    .type(String) // required {@link StaticContentClient.LinkResource#getType() type}
   *    .path(String) // required {@link StaticContentClient.LinkResource#getPath() path}
   *    .value(String) // required {@link StaticContentClient.LinkResource#getValue() value}
   *    .addLocale|addAllLocale(String) // {@link StaticContentClient.LinkResource#getLocale() locale} elements
   *    .workflow(Boolean) // required {@link StaticContentClient.LinkResource#getWorkflow() workflow}
   *    .global(Boolean) // required {@link StaticContentClient.LinkResource#getGlobal() global}
   *    .desc(String | null) // nullable {@link StaticContentClient.LinkResource#getDesc() desc}
   *    .build();
   * </pre>
   * @return A new ImmutableLinkResource builder
   */
  public static ImmutableLinkResource.Builder builder() {
    return new ImmutableLinkResource.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLinkResource ImmutableLinkResource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StaticContentClient.LinkResource", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private static final long INIT_BIT_PATH = 0x4L;
    private static final long INIT_BIT_VALUE = 0x8L;
    private static final long INIT_BIT_WORKFLOW = 0x10L;
    private static final long INIT_BIT_GLOBAL = 0x20L;
    private long initBits = 0x3fL;

    private @Nullable String id;
    private @Nullable String type;
    private @Nullable String path;
    private @Nullable String value;
    private ImmutableList.Builder<String> locale = ImmutableList.builder();
    private @Nullable Boolean workflow;
    private @Nullable Boolean global;
    private @Nullable String desc;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code LinkResource} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StaticContentClient.LinkResource instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      type(instance.getType());
      path(instance.getPath());
      value(instance.getValue());
      addAllLocale(instance.getLocale());
      workflow(instance.getWorkflow());
      global(instance.getGlobal());
      @Nullable String descValue = instance.getDesc();
      if (descValue != null) {
        desc(descValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link StaticContentClient.LinkResource#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link StaticContentClient.LinkResource#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link StaticContentClient.LinkResource#getPath() path} attribute.
     * @param path The value for path 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder path(String path) {
      this.path = Objects.requireNonNull(path, "path");
      initBits &= ~INIT_BIT_PATH;
      return this;
    }

    /**
     * Initializes the value for the {@link StaticContentClient.LinkResource#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Adds one element to {@link StaticContentClient.LinkResource#getLocale() locale} list.
     * @param element A locale element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLocale(String element) {
      this.locale.add(element);
      return this;
    }

    /**
     * Adds elements to {@link StaticContentClient.LinkResource#getLocale() locale} list.
     * @param elements An array of locale elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLocale(String... elements) {
      this.locale.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link StaticContentClient.LinkResource#getLocale() locale} list.
     * @param elements An iterable of locale elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder locale(Iterable<String> elements) {
      this.locale = ImmutableList.builder();
      return addAllLocale(elements);
    }

    /**
     * Adds elements to {@link StaticContentClient.LinkResource#getLocale() locale} list.
     * @param elements An iterable of locale elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllLocale(Iterable<String> elements) {
      this.locale.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link StaticContentClient.LinkResource#getWorkflow() workflow} attribute.
     * @param workflow The value for workflow 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder workflow(Boolean workflow) {
      this.workflow = Objects.requireNonNull(workflow, "workflow");
      initBits &= ~INIT_BIT_WORKFLOW;
      return this;
    }

    /**
     * Initializes the value for the {@link StaticContentClient.LinkResource#getGlobal() global} attribute.
     * @param global The value for global 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder global(Boolean global) {
      this.global = Objects.requireNonNull(global, "global");
      initBits &= ~INIT_BIT_GLOBAL;
      return this;
    }

    /**
     * Initializes the value for the {@link StaticContentClient.LinkResource#getDesc() desc} attribute.
     * @param desc The value for desc (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder desc(@Nullable String desc) {
      this.desc = desc;
      return this;
    }

    /**
     * Builds a new {@link ImmutableLinkResource ImmutableLinkResource}.
     * @return An immutable instance of LinkResource
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLinkResource build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableLinkResource(id, type, path, value, locale.build(), workflow, global, desc);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_PATH) != 0) attributes.add("path");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      if ((initBits & INIT_BIT_WORKFLOW) != 0) attributes.add("workflow");
      if ((initBits & INIT_BIT_GLOBAL) != 0) attributes.add("global");
      return "Cannot build LinkResource, some of required attributes are not set " + attributes;
    }
  }
}
