/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.staticontent.spi.visitor;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.Image;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import io.thestencil.staticontent.api.ImmutableHeading;
import io.thestencil.staticontent.api.ImmutableImageTag;
import io.thestencil.staticontent.api.StaticContentClient;
import io.thestencil.staticontent.spi.visitor.ImmutableMarkdownAst;
import java.util.ArrayList;
import java.util.List;
import org.immutables.value.Value;

public class MarkdownVisitor {
    private final List<StaticContentClient.ImageTag> images = new ArrayList<StaticContentClient.ImageTag>();
    private final List<StaticContentClient.Heading> headings = new ArrayList<StaticContentClient.Heading>();

    public MarkdownAst visit(String content) {
        MutableDataSet options = new MutableDataSet();
        Parser parser = Parser.builder((DataHolder)options).build();
        Document document = parser.parse(content);
        this.visitDocument((Node)document);
        return ImmutableMarkdownAst.builder().images(this.images).headings(this.headings).build();
    }

    private void visitDocument(Node node) {
        node.getChildren().forEach(next -> {
            this.visitNode((Node)next);
            this.visitDocument((Node)next);
        });
    }

    private void visitNode(Node node) {
        if (node instanceof Image) {
            Image img = (Image)node;
            this.images.add(ImmutableImageTag.builder().line(img.getStartOfLine()).title(img.getTitle().toString()).altText(img.getText().toString()).path(img.getUrl().toString()).build());
        } else if (node instanceof Heading) {
            Heading heading = (Heading)node;
            ImmutableHeading anchor = ImmutableHeading.builder().order(this.headings.size() + 1).level(heading.getLevel()).name(heading.getChars().toString()).build();
            this.headings.add(anchor);
        }
    }

    @Value.Immutable
    public static interface MarkdownAst {
        public List<StaticContentClient.ImageTag> getImages();

        public List<StaticContentClient.Heading> getHeadings();
    }
}

