package io.thestencil.staticontent.spi.visitor;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.thestencil.staticontent.api.StaticContentClient;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MarkdownVisitor.MarkdownAst}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMarkdownAst.builder()}.
 */
@Generated(from = "MarkdownVisitor.MarkdownAst", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableMarkdownAst
    implements MarkdownVisitor.MarkdownAst {
  private final ImmutableList<StaticContentClient.ImageTag> images;
  private final ImmutableList<StaticContentClient.Heading> headings;

  private ImmutableMarkdownAst(
      ImmutableList<StaticContentClient.ImageTag> images,
      ImmutableList<StaticContentClient.Heading> headings) {
    this.images = images;
    this.headings = headings;
  }

  /**
   * @return The value of the {@code images} attribute
   */
  @Override
  public ImmutableList<StaticContentClient.ImageTag> getImages() {
    return images;
  }

  /**
   * @return The value of the {@code headings} attribute
   */
  @Override
  public ImmutableList<StaticContentClient.Heading> getHeadings() {
    return headings;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MarkdownVisitor.MarkdownAst#getImages() images}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMarkdownAst withImages(StaticContentClient.ImageTag... elements) {
    ImmutableList<StaticContentClient.ImageTag> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMarkdownAst(newValue, this.headings);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MarkdownVisitor.MarkdownAst#getImages() images}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of images elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMarkdownAst withImages(Iterable<? extends StaticContentClient.ImageTag> elements) {
    if (this.images == elements) return this;
    ImmutableList<StaticContentClient.ImageTag> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMarkdownAst(newValue, this.headings);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MarkdownVisitor.MarkdownAst#getHeadings() headings}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMarkdownAst withHeadings(StaticContentClient.Heading... elements) {
    ImmutableList<StaticContentClient.Heading> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMarkdownAst(this.images, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MarkdownVisitor.MarkdownAst#getHeadings() headings}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of headings elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMarkdownAst withHeadings(Iterable<? extends StaticContentClient.Heading> elements) {
    if (this.headings == elements) return this;
    ImmutableList<StaticContentClient.Heading> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMarkdownAst(this.images, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMarkdownAst} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMarkdownAst
        && equalTo((ImmutableMarkdownAst) another);
  }

  private boolean equalTo(ImmutableMarkdownAst another) {
    return images.equals(another.images)
        && headings.equals(another.headings);
  }

  /**
   * Computes a hash code from attributes: {@code images}, {@code headings}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + images.hashCode();
    h += (h << 5) + headings.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MarkdownAst} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MarkdownAst")
        .omitNullValues()
        .add("images", images)
        .add("headings", headings)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link MarkdownVisitor.MarkdownAst} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MarkdownAst instance
   */
  public static ImmutableMarkdownAst copyOf(MarkdownVisitor.MarkdownAst instance) {
    if (instance instanceof ImmutableMarkdownAst) {
      return (ImmutableMarkdownAst) instance;
    }
    return ImmutableMarkdownAst.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMarkdownAst ImmutableMarkdownAst}.
   * <pre>
   * ImmutableMarkdownAst.builder()
   *    .addImages|addAllImages(io.thestencil.staticontent.api.StaticContentClient.ImageTag) // {@link MarkdownVisitor.MarkdownAst#getImages() images} elements
   *    .addHeadings|addAllHeadings(io.thestencil.staticontent.api.StaticContentClient.Heading) // {@link MarkdownVisitor.MarkdownAst#getHeadings() headings} elements
   *    .build();
   * </pre>
   * @return A new ImmutableMarkdownAst builder
   */
  public static ImmutableMarkdownAst.Builder builder() {
    return new ImmutableMarkdownAst.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMarkdownAst ImmutableMarkdownAst}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MarkdownVisitor.MarkdownAst", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<StaticContentClient.ImageTag> images = ImmutableList.builder();
    private ImmutableList.Builder<StaticContentClient.Heading> headings = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MarkdownAst} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(MarkdownVisitor.MarkdownAst instance) {
      Objects.requireNonNull(instance, "instance");
      addAllImages(instance.getImages());
      addAllHeadings(instance.getHeadings());
      return this;
    }

    /**
     * Adds one element to {@link MarkdownVisitor.MarkdownAst#getImages() images} list.
     * @param element A images element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addImages(StaticContentClient.ImageTag element) {
      this.images.add(element);
      return this;
    }

    /**
     * Adds elements to {@link MarkdownVisitor.MarkdownAst#getImages() images} list.
     * @param elements An array of images elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addImages(StaticContentClient.ImageTag... elements) {
      this.images.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link MarkdownVisitor.MarkdownAst#getImages() images} list.
     * @param elements An iterable of images elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder images(Iterable<? extends StaticContentClient.ImageTag> elements) {
      this.images = ImmutableList.builder();
      return addAllImages(elements);
    }

    /**
     * Adds elements to {@link MarkdownVisitor.MarkdownAst#getImages() images} list.
     * @param elements An iterable of images elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllImages(Iterable<? extends StaticContentClient.ImageTag> elements) {
      this.images.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link MarkdownVisitor.MarkdownAst#getHeadings() headings} list.
     * @param element A headings element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addHeadings(StaticContentClient.Heading element) {
      this.headings.add(element);
      return this;
    }

    /**
     * Adds elements to {@link MarkdownVisitor.MarkdownAst#getHeadings() headings} list.
     * @param elements An array of headings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addHeadings(StaticContentClient.Heading... elements) {
      this.headings.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link MarkdownVisitor.MarkdownAst#getHeadings() headings} list.
     * @param elements An iterable of headings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder headings(Iterable<? extends StaticContentClient.Heading> elements) {
      this.headings = ImmutableList.builder();
      return addAllHeadings(elements);
    }

    /**
     * Adds elements to {@link MarkdownVisitor.MarkdownAst#getHeadings() headings} list.
     * @param elements An iterable of headings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllHeadings(Iterable<? extends StaticContentClient.Heading> elements) {
      this.headings.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableMarkdownAst ImmutableMarkdownAst}.
     * @return An immutable instance of MarkdownAst
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMarkdownAst build() {
      return new ImmutableMarkdownAst(images.build(), headings.build());
    }
  }
}
