/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.staticontent.spi.visitor;

import io.thestencil.client.api.MigrationBuilder;
import io.thestencil.client.api.beans.LocalizedSiteBean;
import io.thestencil.client.api.beans.TopicBean;
import io.thestencil.client.api.beans.TopicBlobBean;
import io.thestencil.client.api.beans.TopicHeadingBean;
import io.thestencil.client.api.beans.TopicLinkBean;
import io.thestencil.staticontent.api.StaticContentClient;
import io.thestencil.staticontent.spi.support.ParserAssert;
import io.thestencil.staticontent.spi.support.Sha2;
import io.thestencil.staticontent.spi.visitor.ImmutableMessage;
import io.thestencil.staticontent.spi.visitor.ImmutableSiteVisitorOutput;
import io.thestencil.staticontent.spi.visitor.SiteVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SiteVisitorDefault
implements SiteVisitor {
    private final List<SiteVisitor.Message> messages = new ArrayList<SiteVisitor.Message>();
    private final Map<String, List<SiteVisitor.TopicData>> localeTopicData = new HashMap<String, List<SiteVisitor.TopicData>>();
    private final Map<String, List<SiteVisitor.LinkData>> pathLinkData = new HashMap<String, List<SiteVisitor.LinkData>>();
    private final Map<String, SiteVisitor.TopicNameData> pathTopicNamesData = new HashMap<String, SiteVisitor.TopicNameData>();
    private final Map<String, SiteVisitor.ImageData> images = new HashMap<String, SiteVisitor.ImageData>();
    private final Map<String, MigrationBuilder.TopicBlob> blobs = new HashMap<String, MigrationBuilder.TopicBlob>();
    private final Map<String, MigrationBuilder.TopicLink> links = new HashMap<String, MigrationBuilder.TopicLink>();
    private final Function<Object, String> serializer;
    private String imageUrl;

    public SiteVisitorDefault(Function<Object, String> serializer) {
        this.serializer = serializer;
    }

    @Override
    public void visitTopicData(SiteVisitor.TopicData topic) {
        List<SiteVisitor.TopicData> topics = this.localeTopicData.get(topic.getLocale());
        if (topics == null) {
            topics = new ArrayList<SiteVisitor.TopicData>();
            this.localeTopicData.put(topic.getLocale(), topics);
        }
        topics.add(topic);
    }

    @Override
    public void visitLinkData(SiteVisitor.LinkData link) {
        List<SiteVisitor.LinkData> links = this.pathLinkData.get(link.getPath());
        if (links == null) {
            links = new ArrayList<SiteVisitor.LinkData>();
            this.pathLinkData.put(link.getPath(), links);
        }
        links.add(link);
    }

    @Override
    public void visitImageData(SiteVisitor.ImageData image) {
        ParserAssert.isTrue(!this.images.containsKey(image.getPath()), () -> "Image with path: '" + image.getPath() + "' is already defined!");
        this.images.put(image.getPath(), image);
    }

    @Override
    public void visitTopicNameData(SiteVisitor.TopicNameData names) {
        this.pathTopicNamesData.put(names.getPath(), names);
    }

    @Override
    public SiteVisitor.SiteVisitorOutput visit(String imageUrl) {
        this.imageUrl = imageUrl;
        ImmutableSiteVisitorOutput.Builder builder = ImmutableSiteVisitorOutput.builder();
        List sites = this.localeTopicData.entrySet().stream().map(this::visitLocale).collect(Collectors.toList());
        sites.sort((s1, s2) -> s1.getId().compareTo(s2.getId()));
        return builder.sites(sites).addAllMessage(this.messages).build();
    }

    private MigrationBuilder.LocalizedSite visitLocale(Map.Entry<String, List<SiteVisitor.TopicData>> localization) {
        LinkedHashMap<String, TopicBean> siteTopics = new LinkedHashMap<String, TopicBean>();
        LinkedHashMap<String, MigrationBuilder.TopicBlob> siteBlobs = new LinkedHashMap<String, MigrationBuilder.TopicBlob>();
        LinkedHashMap siteLinks = new LinkedHashMap();
        ArrayList<String> visitedTopics = new ArrayList<String>();
        ArrayList<String> parents = new ArrayList<String>();
        String locale = localization.getKey();
        for (SiteVisitor.TopicData src : localization.getValue()) {
            String topicId = src.getPath();
            String parent = this.visitTopicParent(src);
            String name = this.visitTopicName(src);
            String blob = this.visitTopicBlob(src);
            List<String> topicLinks = this.visitTopicLinks(topicId, locale);
            List<MigrationBuilder.TopicHeading> topicHeadings = this.visitTopicHeadings(src);
            TopicBean topic = TopicBean.builder().id(topicId).name(name).links(topicLinks).parent(parent).blob(blob).headings(topicHeadings).build();
            if (parent != null) {
                parents.add(parent);
            }
            visitedTopics.add(topicId);
            siteTopics.put(topic.getId(), topic);
            topic.getLinks().forEach(link -> siteLinks.put(link, this.links.get(link)));
            siteBlobs.put(topic.getBlob(), this.blobs.get(topic.getBlob()));
        }
        for (String parent : parents) {
            if (visitedTopics.contains(parent)) continue;
            String id = parent;
            String name = this.visitTopicName(parent, locale);
            List<String> topicLinks = this.visitTopicLinks(id, locale);
            TopicBean topic = TopicBean.builder().id(id).name(name).links(topicLinks).build();
            topic.getLinks().forEach(link -> siteLinks.put(link, this.links.get(link)));
            siteTopics.put(topic.getId(), topic);
        }
        LocalizedSiteBean result = LocalizedSiteBean.builder().id("").images(this.imageUrl).locale(locale).topics(this.sort(siteTopics)).blobs(this.sort(siteBlobs)).links(this.sort(siteLinks)).build();
        String id = Sha2.blobId(this.serializer.apply(result));
        return LocalizedSiteBean.builder().from((MigrationBuilder.LocalizedSite)result).id(id).build();
    }

    private <K> Map<String, K> sort(Map<String, K> input) {
        ArrayList<Map.Entry<String, K>> values = new ArrayList<Map.Entry<String, K>>(input.entrySet());
        values.sort((e1, e2) -> ((String)e1.getKey()).compareTo((String)e2.getKey()));
        LinkedHashMap<String, K> result = new LinkedHashMap<String, K>();
        for (Map.Entry<String, K> entry : values) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private String visitTopicParent(SiteVisitor.TopicData topic) {
        String[] path = topic.getPath().split("\\/");
        if (path.length > 1) {
            return path[0];
        }
        return null;
    }

    private String visitTopicName(String path, String locale) {
        SiteVisitor.TopicNameData locales = this.pathTopicNamesData.get(path);
        if (locales == null) {
            this.messages.add(ImmutableMessage.builder().text("Missing localized: '" + locale + "' name for path: '" + path + "'!").build());
            return path;
        }
        String name = locales.getLocale().get(locale);
        if (name == null || name.isBlank()) {
            this.messages.add(ImmutableMessage.builder().text("Missing localized: '" + locale + "' name for path: '" + path + "'!").build());
            return path;
        }
        return path;
    }

    private String visitTopicName(SiteVisitor.TopicData topic) {
        for (StaticContentClient.Heading heading : topic.getHeadings()) {
            if (heading.getLevel() != 1 || heading.getName().length() <= 1) continue;
            return heading.getName().substring(1).trim();
        }
        SiteVisitor.TopicNameData locales = this.pathTopicNamesData.get(topic.getPath());
        if (locales == null) {
            this.messages.add(ImmutableMessage.builder().text("Missing localized: '" + topic.getLocale() + "' name for path: '" + topic.getPath() + "'!").object(topic).build());
            return topic.getPath();
        }
        String name = locales.getLocale().get(topic.getLocale());
        if (name == null || name.isBlank()) {
            this.messages.add(ImmutableMessage.builder().text("Missing localized: '" + topic.getLocale() + "' name for path: '" + topic.getPath() + "'!").object(topic).build());
            return topic.getPath();
        }
        return name;
    }

    private String visitTopicBlob(SiteVisitor.TopicData topic) {
        String blob = topic.getValue();
        String id = Sha2.blobId(blob);
        this.blobs.put(id, (MigrationBuilder.TopicBlob)TopicBlobBean.builder().id(id).value(blob).build());
        return id;
    }

    private List<MigrationBuilder.TopicHeading> visitTopicHeadings(SiteVisitor.TopicData topic) {
        ArrayList<MigrationBuilder.TopicHeading> result = new ArrayList<MigrationBuilder.TopicHeading>();
        int index = 1;
        for (StaticContentClient.Heading heading : topic.getHeadings()) {
            result.add((MigrationBuilder.TopicHeading)TopicHeadingBean.builder().id(String.valueOf(index++)).name(heading.getName()).order(heading.getOrder()).level(heading.getLevel()).build());
        }
        return result;
    }

    private List<String> visitTopicLinks(String path, String locale) {
        int prefix;
        List<SiteVisitor.LinkData> src = this.pathLinkData.get(path);
        if (src == null && (prefix = path.indexOf("_")) > -1) {
            src = this.pathLinkData.get(path.substring(prefix + 1));
        }
        ArrayList links = new ArrayList(src == null ? Collections.emptyList() : src);
        links.addAll(this.pathLinkData.getOrDefault("", Collections.emptyList()));
        ArrayList<String> result = new ArrayList<String>();
        for (SiteVisitor.LinkData link : links) {
            boolean topicLocale;
            boolean allLocales = link.getLocale() == null || link.getLocale().isBlank();
            boolean bl = topicLocale = link.getLocale() != null && link.getLocale().indexOf(locale) > -1;
            if (!allLocales && !topicLocale) continue;
            TopicLinkBean template = TopicLinkBean.builder().id("template").path(link.getPath()).global(link.getGlobal()).type(link.getType()).name(link.getName()).value(link.getValue()).workflow(link.getWorkflow()).build();
            String id = Sha2.blobId(template.toString());
            this.links.put(id, (MigrationBuilder.TopicLink)TopicLinkBean.builder().from((MigrationBuilder.TopicLink)template).id(id).build());
            result.add(id);
        }
        return result;
    }
}

