/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.staticontent.spi.visitor;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.staticontent.api.StaticContentClient;
import io.thestencil.staticontent.spi.visitor.SiteVisitor;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SiteVisitor.TopicData", generator="Immutables")
@Immutable
public final class ImmutableTopicData
implements SiteVisitor.TopicData {
    private final String path;
    private final String locale;
    private final String value;
    private final ImmutableList<StaticContentClient.Heading> headings;
    private final ImmutableList<StaticContentClient.ImageTag> images;

    private ImmutableTopicData(String path, String locale, String value, ImmutableList<StaticContentClient.Heading> headings, ImmutableList<StaticContentClient.ImageTag> images) {
        this.path = path;
        this.locale = locale;
        this.value = value;
        this.headings = headings;
        this.images = images;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getLocale() {
        return this.locale;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public ImmutableList<StaticContentClient.Heading> getHeadings() {
        return this.headings;
    }

    public ImmutableList<StaticContentClient.ImageTag> getImages() {
        return this.images;
    }

    public final ImmutableTopicData withPath(String value) {
        String newValue = Objects.requireNonNull(value, "path");
        if (this.path.equals(newValue)) {
            return this;
        }
        return new ImmutableTopicData(newValue, this.locale, this.value, this.headings, this.images);
    }

    public final ImmutableTopicData withLocale(String value) {
        String newValue = Objects.requireNonNull(value, "locale");
        if (this.locale.equals(newValue)) {
            return this;
        }
        return new ImmutableTopicData(this.path, newValue, this.value, this.headings, this.images);
    }

    public final ImmutableTopicData withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableTopicData(this.path, this.locale, newValue, this.headings, this.images);
    }

    public final ImmutableTopicData withHeadings(StaticContentClient.Heading ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTopicData(this.path, this.locale, this.value, (ImmutableList<StaticContentClient.Heading>)newValue, this.images);
    }

    public final ImmutableTopicData withHeadings(Iterable<? extends StaticContentClient.Heading> elements) {
        if (this.headings == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTopicData(this.path, this.locale, this.value, (ImmutableList<StaticContentClient.Heading>)newValue, this.images);
    }

    public final ImmutableTopicData withImages(StaticContentClient.ImageTag ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTopicData(this.path, this.locale, this.value, this.headings, (ImmutableList<StaticContentClient.ImageTag>)newValue);
    }

    public final ImmutableTopicData withImages(Iterable<? extends StaticContentClient.ImageTag> elements) {
        if (this.images == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTopicData(this.path, this.locale, this.value, this.headings, (ImmutableList<StaticContentClient.ImageTag>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTopicData && this.equalTo((ImmutableTopicData)another);
    }

    private boolean equalTo(ImmutableTopicData another) {
        return this.path.equals(another.path) && this.locale.equals(another.locale) && this.value.equals(another.value) && this.headings.equals(another.headings) && this.images.equals(another.images);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + this.locale.hashCode();
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.headings.hashCode();
        h += (h << 5) + this.images.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TopicData").omitNullValues().add("path", (Object)this.path).add("locale", (Object)this.locale).add("value", (Object)this.value).add("headings", this.headings).add("images", this.images).toString();
    }

    public static ImmutableTopicData copyOf(SiteVisitor.TopicData instance) {
        if (instance instanceof ImmutableTopicData) {
            return (ImmutableTopicData)instance;
        }
        return ImmutableTopicData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SiteVisitor.TopicData", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PATH = 1L;
        private static final long INIT_BIT_LOCALE = 2L;
        private static final long INIT_BIT_VALUE = 4L;
        private long initBits = 7L;
        @Nullable
        private String path;
        @Nullable
        private String locale;
        @Nullable
        private String value;
        private ImmutableList.Builder<StaticContentClient.Heading> headings = ImmutableList.builder();
        private ImmutableList.Builder<StaticContentClient.ImageTag> images = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SiteVisitor.TopicData instance) {
            Objects.requireNonNull(instance, "instance");
            this.path(instance.getPath());
            this.locale(instance.getLocale());
            this.value(instance.getValue());
            this.addAllHeadings(instance.getHeadings());
            this.addAllImages(instance.getImages());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder path(String path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder locale(String locale) {
            this.locale = Objects.requireNonNull(locale, "locale");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addHeadings(StaticContentClient.Heading element) {
            this.headings.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addHeadings(StaticContentClient.Heading ... elements) {
            this.headings.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder headings(Iterable<? extends StaticContentClient.Heading> elements) {
            this.headings = ImmutableList.builder();
            return this.addAllHeadings(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllHeadings(Iterable<? extends StaticContentClient.Heading> elements) {
            this.headings.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addImages(StaticContentClient.ImageTag element) {
            this.images.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addImages(StaticContentClient.ImageTag ... elements) {
            this.images.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder images(Iterable<? extends StaticContentClient.ImageTag> elements) {
            this.images = ImmutableList.builder();
            return this.addAllImages(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllImages(Iterable<? extends StaticContentClient.ImageTag> elements) {
            this.images.addAll(elements);
            return this;
        }

        public ImmutableTopicData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTopicData(this.path, this.locale, this.value, (ImmutableList<StaticContentClient.Heading>)this.headings.build(), (ImmutableList<StaticContentClient.ImageTag>)this.images.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("path");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("locale");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build TopicData, some of required attributes are not set " + attributes;
        }
    }
}

