/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.staticontent.api;

import io.thestencil.client.api.MigrationBuilder;
import io.thestencil.client.api.StencilClient;
import java.util.List;
import javax.annotation.Nullable;
import org.immutables.value.Value;

public interface StaticContentClient {
    public MarkdownBuilder markdown();

    public SitesBuilder sites();

    @Value.Immutable
    public static interface ImageTag {
        public Integer getLine();

        public String getTitle();

        public String getAltText();

        public String getPath();
    }

    @Value.Immutable
    public static interface Heading {
        public Integer getOrder();

        public Integer getLevel();

        public String getName();
    }

    @Value.Immutable
    public static interface Markdown {
        public String getLocale();

        public String getPath();

        public String getValue();

        public List<Heading> getHeadings();

        public List<ImageTag> getImages();
    }

    @Value.Immutable
    public static interface ImageResource {
        public String getPath();

        public byte[] getValue();
    }

    @Value.Immutable
    public static interface LinkResource {
        public String getId();

        public String getType();

        public String getPath();

        public String getValue();

        public List<String> getLocale();

        public Boolean getWorkflow();

        public Boolean getGlobal();

        @Nullable
        public String getDesc();
    }

    @Value.Immutable
    public static interface Markdowns {
        public List<Markdown> getValues();

        public List<ImageResource> getImages();

        public List<LinkResource> getLinks();

        public List<String> getLocales();
    }

    public static interface MarkdownBuilder {
        public MarkdownBuilder json(String var1);

        public MarkdownBuilder json(StencilClient.SiteState var1);

        public MarkdownBuilder md(String var1, byte[] var2);

        public Markdowns build();
    }

    public static interface SitesBuilder {
        public SitesBuilder imagePath(String var1);

        public SitesBuilder created(long var1);

        public SitesBuilder source(Markdowns var1);

        public MigrationBuilder.Sites build();
    }
}

