/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.staticontent.spi;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.thestencil.client.api.MigrationBuilder;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.api.beans.SitesBean;
import io.thestencil.staticontent.api.ImmutableImageResource;
import io.thestencil.staticontent.api.ImmutableMarkdown;
import io.thestencil.staticontent.api.ImmutableMarkdowns;
import io.thestencil.staticontent.api.StaticContentClient;
import io.thestencil.staticontent.spi.support.ParserAssert;
import io.thestencil.staticontent.spi.visitor.CSVLinksVisitor;
import io.thestencil.staticontent.spi.visitor.ImmutableLinkData;
import io.thestencil.staticontent.spi.visitor.ImmutableTopicData;
import io.thestencil.staticontent.spi.visitor.MarkdownException;
import io.thestencil.staticontent.spi.visitor.MarkdownVisitor;
import io.thestencil.staticontent.spi.visitor.SiteStateVisitor;
import io.thestencil.staticontent.spi.visitor.SiteVisitor;
import io.thestencil.staticontent.spi.visitor.SiteVisitorDefault;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class StaticContentClientDefault
implements StaticContentClient {
    private static ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public StaticContentClient.MarkdownBuilder markdown() {
        return new StaticContentClient.MarkdownBuilder(){
            private StaticContentClient.Markdowns jsonOfSiteState;
            private ImmutableMarkdowns.Builder fromFiles;

            @Override
            public StaticContentClient.MarkdownBuilder md(String path, byte[] value) {
                if (this.fromFiles == null) {
                    this.fromFiles = ImmutableMarkdowns.builder();
                }
                if (!path.toLowerCase().endsWith(".md")) {
                    String cleanName = path.toLowerCase();
                    if (cleanName.equals("links.csv")) {
                        this.fromFiles.addAllLinks(new CSVLinksVisitor(path).visit(value));
                    } else if (cleanName.startsWith("images/")) {
                        this.fromFiles.addImages((StaticContentClient.ImageResource)ImmutableImageResource.builder().path(path).value(value).build());
                    }
                    return this;
                }
                String[] fragments = path.split("\\/");
                if (fragments.length != 2 && fragments.length != 3) {
                    throw new MarkdownException("Markdown: '" + path + "' must have [2..3] (level2/level2/en.md) levels but was: '" + fragments.length + "'!");
                }
                String fileName = fragments[fragments.length - 1];
                if (fileName.length() != 5) {
                    throw new MarkdownException("Markdown: '" + path + "' must be name as <path>/<locale>.md but was: '" + path + "'!");
                }
                String locale = fileName.substring(0, 2);
                try {
                    String content = new String(value, StandardCharsets.UTF_8);
                    Object cleanPath = fragments.length == 2 ? fragments[0] : fragments[0] + "/" + fragments[1];
                    MarkdownVisitor.MarkdownAst ast = new MarkdownVisitor().visit(content);
                    if (ast.getHeadings().stream().filter(entity -> entity.getLevel() == 1).findFirst().isEmpty()) {
                        throw new MarkdownException("markdown must have atleast one h1(line starting with one # my super menu)");
                    }
                    this.fromFiles.addValues((StaticContentClient.Markdown)ImmutableMarkdown.builder().path((String)cleanPath).locale(locale).value(content).addAllHeadings(ast.getHeadings()).addAllImages(ast.getImages()).build());
                    return this;
                }
                catch (Exception e) {
                    throw new MarkdownException("Failed to parse markdown: '" + path + "', error: " + e.getMessage(), e);
                }
            }

            @Override
            public StaticContentClient.MarkdownBuilder json(String jsonOfSiteState) {
                try {
                    StencilClient.SiteState site = (StencilClient.SiteState)objectMapper.readValue(jsonOfSiteState, StencilClient.SiteState.class);
                    this.jsonOfSiteState = new SiteStateVisitor().visit(site);
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                return this;
            }

            @Override
            public StaticContentClient.Markdowns build() {
                ParserAssert.isTrue(this.jsonOfSiteState != null || this.fromFiles != null, () -> "json or md files must be provided!");
                ParserAssert.isTrue(this.jsonOfSiteState == null || this.fromFiles == null, () -> "json or md files both can't be provided!");
                if (this.fromFiles != null) {
                    return this.fromFiles.build();
                }
                return this.jsonOfSiteState;
            }
        };
    }

    @Override
    public StaticContentClient.SitesBuilder sites() {
        return new StaticContentClient.SitesBuilder(){
            private final SiteVisitor visitor = new SiteVisitorDefault(x$0 -> StaticContentClientDefault.writeAsString(x$0));
            private String imageUrl;
            private Long created;
            private StaticContentClient.Markdowns markdowns;

            @Override
            public StaticContentClient.SitesBuilder source(StaticContentClient.Markdowns markdowns) {
                this.markdowns = markdowns;
                return this;
            }

            @Override
            public StaticContentClient.SitesBuilder imagePath(String imagePath) {
                this.imageUrl = imagePath;
                return this;
            }

            @Override
            public StaticContentClient.SitesBuilder created(long created) {
                this.created = created;
                return this;
            }

            private StaticContentClient.SitesBuilder topic(Function<ImmutableTopicData.Builder, SiteVisitor.TopicData> newTopic) {
                this.visitor.visitTopicData(newTopic.apply(ImmutableTopicData.builder()));
                return this;
            }

            private StaticContentClient.SitesBuilder link(Function<ImmutableLinkData.Builder, SiteVisitor.LinkData> newLink) {
                this.visitor.visitLinkData(newLink.apply(ImmutableLinkData.builder()));
                return this;
            }

            @Override
            public MigrationBuilder.Sites build() {
                ParserAssert.notEmpty(this.imageUrl, () -> "imageUrl can't be empty!");
                ParserAssert.notNull(this.created, () -> "created can't be empty!");
                ParserAssert.notNull(this.markdowns, () -> "markdowns can't be empty!");
                this.markdowns.getValues().forEach(value -> this.topic(builder -> builder.path(value.getPath()).locale(value.getLocale()).headings(value.getHeadings()).images(value.getImages()).value(value.getValue()).build()));
                this.markdowns.getLinks().forEach(link -> link.getLocale().forEach(locale -> this.link(builder -> builder.id(link.getId()).path(link.getPath()).locale((String)locale).type(link.getType()).name(link.getDesc()).global(link.getGlobal()).value(link.getValue()).workflow(link.getType().equals(SiteStateVisitor.LINK_TYPE_WORKFLOW)).build())));
                SiteVisitor.SiteVisitorOutput visited = this.visitor.visit(this.imageUrl);
                Map<String, MigrationBuilder.LocalizedSite> content = visited.getSites().stream().collect(Collectors.toMap(e -> e.getLocale(), e -> e));
                return SitesBean.builder().created(this.created).sites(content).build();
            }
        };
    }

    private static String writeAsString(Object anyObject) {
        try {
            return objectMapper.writeValueAsString(anyObject);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        objectMapper.registerModule((Module)new GuavaModule());
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new Jdk8Module());
    }

    public static class Builder {
        public StaticContentClientDefault build() {
            return new StaticContentClientDefault();
        }
    }
}

