/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.staticontent.spi.visitor;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.staticontent.api.MarkdownContent;
import io.thestencil.staticontent.spi.visitor.MarkdownVisitor;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MarkdownVisitor.MarkdownAst", generator="Immutables")
@Immutable
public final class ImmutableMarkdownAst
implements MarkdownVisitor.MarkdownAst {
    private final ImmutableList<MarkdownContent.ImageTag> images;
    private final ImmutableList<MarkdownContent.Heading> headings;

    private ImmutableMarkdownAst(ImmutableList<MarkdownContent.ImageTag> images, ImmutableList<MarkdownContent.Heading> headings) {
        this.images = images;
        this.headings = headings;
    }

    public ImmutableList<MarkdownContent.ImageTag> getImages() {
        return this.images;
    }

    public ImmutableList<MarkdownContent.Heading> getHeadings() {
        return this.headings;
    }

    public final ImmutableMarkdownAst withImages(MarkdownContent.ImageTag ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableMarkdownAst((ImmutableList<MarkdownContent.ImageTag>)newValue, this.headings);
    }

    public final ImmutableMarkdownAst withImages(Iterable<? extends MarkdownContent.ImageTag> elements) {
        if (this.images == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMarkdownAst((ImmutableList<MarkdownContent.ImageTag>)newValue, this.headings);
    }

    public final ImmutableMarkdownAst withHeadings(MarkdownContent.Heading ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableMarkdownAst(this.images, (ImmutableList<MarkdownContent.Heading>)newValue);
    }

    public final ImmutableMarkdownAst withHeadings(Iterable<? extends MarkdownContent.Heading> elements) {
        if (this.headings == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMarkdownAst(this.images, (ImmutableList<MarkdownContent.Heading>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMarkdownAst && this.equalTo((ImmutableMarkdownAst)another);
    }

    private boolean equalTo(ImmutableMarkdownAst another) {
        return this.images.equals(another.images) && this.headings.equals(another.headings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.images.hashCode();
        h += (h << 5) + this.headings.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MarkdownAst").omitNullValues().add("images", this.images).add("headings", this.headings).toString();
    }

    public static ImmutableMarkdownAst copyOf(MarkdownVisitor.MarkdownAst instance) {
        if (instance instanceof ImmutableMarkdownAst) {
            return (ImmutableMarkdownAst)instance;
        }
        return ImmutableMarkdownAst.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MarkdownVisitor.MarkdownAst", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<MarkdownContent.ImageTag> images = ImmutableList.builder();
        private ImmutableList.Builder<MarkdownContent.Heading> headings = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MarkdownVisitor.MarkdownAst instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllImages(instance.getImages());
            this.addAllHeadings(instance.getHeadings());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addImages(MarkdownContent.ImageTag element) {
            this.images.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addImages(MarkdownContent.ImageTag ... elements) {
            this.images.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder images(Iterable<? extends MarkdownContent.ImageTag> elements) {
            this.images = ImmutableList.builder();
            return this.addAllImages(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllImages(Iterable<? extends MarkdownContent.ImageTag> elements) {
            this.images.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addHeadings(MarkdownContent.Heading element) {
            this.headings.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addHeadings(MarkdownContent.Heading ... elements) {
            this.headings.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder headings(Iterable<? extends MarkdownContent.Heading> elements) {
            this.headings = ImmutableList.builder();
            return this.addAllHeadings(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllHeadings(Iterable<? extends MarkdownContent.Heading> elements) {
            this.headings.addAll(elements);
            return this;
        }

        public ImmutableMarkdownAst build() {
            return new ImmutableMarkdownAst((ImmutableList<MarkdownContent.ImageTag>)this.images.build(), (ImmutableList<MarkdownContent.Heading>)this.headings.build());
        }
    }
}

