/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.staticontent.spi;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.thestencil.persistence.api.ZoePersistence;
import io.thestencil.staticontent.api.ImmutableImageData;
import io.thestencil.staticontent.api.ImmutableImageResource;
import io.thestencil.staticontent.api.ImmutableLinkData;
import io.thestencil.staticontent.api.ImmutableMarkdown;
import io.thestencil.staticontent.api.ImmutableMarkdownContent;
import io.thestencil.staticontent.api.ImmutableTopicData;
import io.thestencil.staticontent.api.ImmutableTopicNameData;
import io.thestencil.staticontent.api.MarkdownContent;
import io.thestencil.staticontent.api.SiteContent;
import io.thestencil.staticontent.api.StaticContentClient;
import io.thestencil.staticontent.spi.beans.MutableStaticContent;
import io.thestencil.staticontent.spi.support.ParserAssert;
import io.thestencil.staticontent.spi.visitor.CSVLinksVisitor;
import io.thestencil.staticontent.spi.visitor.MarkdownException;
import io.thestencil.staticontent.spi.visitor.MarkdownVisitor;
import io.thestencil.staticontent.spi.visitor.SiteStateVisitor;
import io.thestencil.staticontent.spi.visitor.SiteVisitor;
import io.thestencil.staticontent.spi.visitor.SiteVisitorDefault;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class StaticContentClientDefault
implements StaticContentClient {
    private static ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public StaticContentClient.StaticContentBuilder create() {
        return new StaticContentClient.StaticContentBuilder(){
            private final SiteVisitor visitor = new SiteVisitorDefault(src -> {
                try {
                    return objectMapper.writeValueAsString(src);
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            });
            private String imageUrl;
            private Long created;

            @Override
            public StaticContentClient.StaticContentBuilder topic(Function<ImmutableTopicData.Builder, StaticContentClient.TopicData> newTopic) {
                this.visitor.visitTopicData(newTopic.apply(ImmutableTopicData.builder()));
                return this;
            }

            @Override
            public StaticContentClient.StaticContentBuilder link(Function<ImmutableLinkData.Builder, StaticContentClient.LinkData> newLink) {
                this.visitor.visitLinkData(newLink.apply(ImmutableLinkData.builder()));
                return this;
            }

            @Override
            public StaticContentClient.StaticContentBuilder image(Function<ImmutableImageData.Builder, StaticContentClient.ImageData> newImage) {
                this.visitor.visitImageData(newImage.apply(ImmutableImageData.builder()));
                return this;
            }

            @Override
            public StaticContentClient.StaticContentBuilder topicName(Function<ImmutableTopicNameData.Builder, StaticContentClient.TopicNameData> newTopicNames) {
                this.visitor.visitTopicNameData(newTopicNames.apply(ImmutableTopicNameData.builder()));
                return this;
            }

            @Override
            public StaticContentClient.StaticContentBuilder imageUrl(String imageUrl) {
                this.imageUrl = imageUrl;
                return this;
            }

            @Override
            public StaticContentClient.StaticContentBuilder created(long created) {
                this.created = created;
                return this;
            }

            @Override
            public SiteContent build() {
                ParserAssert.notEmpty(this.imageUrl, () -> "imageUrl can't be empty!");
                ParserAssert.notNull(this.created, () -> "created can't be empty!");
                SiteVisitor.Sites visited = this.visitor.visit(this.imageUrl);
                Map<String, SiteContent.Site> content = visited.getSites().stream().collect(Collectors.toMap(e -> e.getLocale(), e -> e));
                return new MutableStaticContent(this.created, content);
            }
        };
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public StaticContentClient.StaticContentBuilder from(ZoePersistence.SiteState site) {
        MarkdownContent content = new SiteStateVisitor().visit(site);
        return this.from(content);
    }

    @Override
    public StaticContentClient.StaticContentBuilder from(MarkdownContent content) {
        StaticContentClient.StaticContentBuilder client = StaticContentClientDefault.builder().build().create();
        content.getValues().forEach(value -> client.topic(builder -> builder.path(value.getPath()).locale(value.getLocale()).headings(value.getHeadings()).images(value.getImages()).value(value.getValue()).build()));
        content.getLinks().forEach(link -> link.getLocale().forEach(locale -> client.link(builder -> builder.id(link.getId()).path(link.getPath()).locale((String)locale).type(link.getType()).name(link.getDesc()).value(link.getValue()).workflow(link.getType().equals(SiteStateVisitor.LINK_TYPE_WORKFLOW)).build())));
        return client;
    }

    @Override
    public ZoePersistence.SiteState parseSiteState(String json) {
        try {
            return (ZoePersistence.SiteState)objectMapper.readValue(json, ZoePersistence.SiteState.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public MarkdownContent parseMd(ZoePersistence.SiteState site) {
        MarkdownContent content = new SiteStateVisitor().visit(site);
        return content;
    }

    @Override
    public StaticContentClient.FileParser parseFiles() {
        return new StaticContentClient.FileParser(){
            private final ImmutableMarkdownContent.Builder result = ImmutableMarkdownContent.builder();

            @Override
            public StaticContentClient.FileParser add(String path, byte[] value) {
                if (!path.toLowerCase().endsWith(".md")) {
                    String cleanName = path.toLowerCase();
                    if (cleanName.equals("links.csv")) {
                        this.result.addAllLinks(new CSVLinksVisitor(path).visit(value));
                    } else if (cleanName.startsWith("images/")) {
                        this.result.addImages((MarkdownContent.ImageResource)ImmutableImageResource.builder().path(path).value(value).build());
                    }
                    return this;
                }
                String[] fragments = path.split("\\/");
                if (fragments.length != 2 && fragments.length != 3) {
                    throw new MarkdownException("Markdown: '" + path + "' must have [2..3] (level2/level2/en.md) levels but was: '" + fragments.length + "'!");
                }
                String fileName = fragments[fragments.length - 1];
                if (fileName.length() != 5) {
                    throw new MarkdownException("Markdown: '" + path + "' must be name as <path>/<locale>.md but was: '" + path + "'!");
                }
                String locale = fileName.substring(0, 2);
                try {
                    String content = new String(value, StandardCharsets.UTF_8);
                    Object cleanPath = fragments.length == 2 ? fragments[0] : fragments[0] + "/" + fragments[1];
                    MarkdownVisitor.MarkdownAst ast = new MarkdownVisitor().visit(content);
                    if (ast.getHeadings().stream().filter(entity -> entity.getLevel() == 1).findFirst().isEmpty()) {
                        throw new MarkdownException("markdown must have atleast one h1(line starting with one # my super menu)");
                    }
                    this.result.addValues((MarkdownContent.Markdown)ImmutableMarkdown.builder().path((String)cleanPath).locale(locale).value(content).addAllHeadings(ast.getHeadings()).addAllImages(ast.getImages()).build());
                    return this;
                }
                catch (Exception e) {
                    throw new MarkdownException("Failed to parse markdown: '" + path + "', error: " + e.getMessage(), e);
                }
            }

            @Override
            public MarkdownContent build() {
                return this.result.build();
            }
        };
    }

    static {
        objectMapper.registerModule((Module)new GuavaModule());
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new Jdk8Module());
    }

    public static class Builder {
        public StaticContentClientDefault build() {
            return new StaticContentClientDefault();
        }
    }
}

