/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.staticontent.api;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.staticontent.api.MarkdownContent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MarkdownContent.ImageResource", generator="Immutables")
@Immutable
public final class ImmutableImageResource
implements MarkdownContent.ImageResource {
    private final String path;
    private final byte[] value;

    private ImmutableImageResource(String path, byte[] value) {
        this.path = path;
        this.value = value;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public byte[] getValue() {
        return (byte[])this.value.clone();
    }

    public final ImmutableImageResource withPath(String value) {
        String newValue = Objects.requireNonNull(value, "path");
        if (this.path.equals(newValue)) {
            return this;
        }
        return new ImmutableImageResource(newValue, this.value);
    }

    public final ImmutableImageResource withValue(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutableImageResource(this.path, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableImageResource && this.equalTo((ImmutableImageResource)another);
    }

    private boolean equalTo(ImmutableImageResource another) {
        return this.path.equals(another.path) && Arrays.equals(this.value, another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + Arrays.hashCode(this.value);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ImageResource").omitNullValues().add("path", (Object)this.path).add("value", (Object)Arrays.toString(this.value)).toString();
    }

    public static ImmutableImageResource copyOf(MarkdownContent.ImageResource instance) {
        if (instance instanceof ImmutableImageResource) {
            return (ImmutableImageResource)instance;
        }
        return ImmutableImageResource.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MarkdownContent.ImageResource", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PATH = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private long initBits = 3L;
        @Nullable
        private String path;
        @Nullable
        private byte[] value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MarkdownContent.ImageResource instance) {
            Objects.requireNonNull(instance, "instance");
            this.path(instance.getPath());
            this.value(instance.getValue());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder path(String path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(byte ... value) {
            this.value = (byte[])value.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableImageResource build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableImageResource(this.path, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("path");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build ImageResource, some of required attributes are not set " + attributes;
        }
    }
}

