package io.thestencil.staticontent.api;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MarkdownContent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMarkdownContent.builder()}.
 */
@Generated(from = "MarkdownContent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableMarkdownContent implements MarkdownContent {
  private final ImmutableList<MarkdownContent.Markdown> values;
  private final ImmutableList<MarkdownContent.ImageResource> images;
  private final ImmutableList<MarkdownContent.LinkResource> links;
  private final ImmutableList<String> locales;

  private ImmutableMarkdownContent(
      ImmutableList<MarkdownContent.Markdown> values,
      ImmutableList<MarkdownContent.ImageResource> images,
      ImmutableList<MarkdownContent.LinkResource> links,
      ImmutableList<String> locales) {
    this.values = values;
    this.images = images;
    this.links = links;
    this.locales = locales;
  }

  /**
   * @return The value of the {@code values} attribute
   */
  @Override
  public ImmutableList<MarkdownContent.Markdown> getValues() {
    return values;
  }

  /**
   * @return The value of the {@code images} attribute
   */
  @Override
  public ImmutableList<MarkdownContent.ImageResource> getImages() {
    return images;
  }

  /**
   * @return The value of the {@code links} attribute
   */
  @Override
  public ImmutableList<MarkdownContent.LinkResource> getLinks() {
    return links;
  }

  /**
   * @return The value of the {@code locales} attribute
   */
  @Override
  public ImmutableList<String> getLocales() {
    return locales;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MarkdownContent#getValues() values}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMarkdownContent withValues(MarkdownContent.Markdown... elements) {
    ImmutableList<MarkdownContent.Markdown> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMarkdownContent(newValue, this.images, this.links, this.locales);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MarkdownContent#getValues() values}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of values elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMarkdownContent withValues(Iterable<? extends MarkdownContent.Markdown> elements) {
    if (this.values == elements) return this;
    ImmutableList<MarkdownContent.Markdown> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMarkdownContent(newValue, this.images, this.links, this.locales);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MarkdownContent#getImages() images}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMarkdownContent withImages(MarkdownContent.ImageResource... elements) {
    ImmutableList<MarkdownContent.ImageResource> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMarkdownContent(this.values, newValue, this.links, this.locales);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MarkdownContent#getImages() images}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of images elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMarkdownContent withImages(Iterable<? extends MarkdownContent.ImageResource> elements) {
    if (this.images == elements) return this;
    ImmutableList<MarkdownContent.ImageResource> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMarkdownContent(this.values, newValue, this.links, this.locales);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MarkdownContent#getLinks() links}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMarkdownContent withLinks(MarkdownContent.LinkResource... elements) {
    ImmutableList<MarkdownContent.LinkResource> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMarkdownContent(this.values, this.images, newValue, this.locales);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MarkdownContent#getLinks() links}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of links elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMarkdownContent withLinks(Iterable<? extends MarkdownContent.LinkResource> elements) {
    if (this.links == elements) return this;
    ImmutableList<MarkdownContent.LinkResource> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMarkdownContent(this.values, this.images, newValue, this.locales);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MarkdownContent#getLocales() locales}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMarkdownContent withLocales(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMarkdownContent(this.values, this.images, this.links, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MarkdownContent#getLocales() locales}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of locales elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMarkdownContent withLocales(Iterable<String> elements) {
    if (this.locales == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMarkdownContent(this.values, this.images, this.links, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMarkdownContent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMarkdownContent
        && equalTo((ImmutableMarkdownContent) another);
  }

  private boolean equalTo(ImmutableMarkdownContent another) {
    return values.equals(another.values)
        && images.equals(another.images)
        && links.equals(another.links)
        && locales.equals(another.locales);
  }

  /**
   * Computes a hash code from attributes: {@code values}, {@code images}, {@code links}, {@code locales}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + values.hashCode();
    h += (h << 5) + images.hashCode();
    h += (h << 5) + links.hashCode();
    h += (h << 5) + locales.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MarkdownContent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MarkdownContent")
        .omitNullValues()
        .add("values", values)
        .add("images", images)
        .add("links", links)
        .add("locales", locales)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link MarkdownContent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MarkdownContent instance
   */
  public static ImmutableMarkdownContent copyOf(MarkdownContent instance) {
    if (instance instanceof ImmutableMarkdownContent) {
      return (ImmutableMarkdownContent) instance;
    }
    return ImmutableMarkdownContent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMarkdownContent ImmutableMarkdownContent}.
   * <pre>
   * ImmutableMarkdownContent.builder()
   *    .addValues|addAllValues(io.thestencil.staticontent.api.MarkdownContent.Markdown) // {@link MarkdownContent#getValues() values} elements
   *    .addImages|addAllImages(io.thestencil.staticontent.api.MarkdownContent.ImageResource) // {@link MarkdownContent#getImages() images} elements
   *    .addLinks|addAllLinks(io.thestencil.staticontent.api.MarkdownContent.LinkResource) // {@link MarkdownContent#getLinks() links} elements
   *    .addLocales|addAllLocales(String) // {@link MarkdownContent#getLocales() locales} elements
   *    .build();
   * </pre>
   * @return A new ImmutableMarkdownContent builder
   */
  public static ImmutableMarkdownContent.Builder builder() {
    return new ImmutableMarkdownContent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMarkdownContent ImmutableMarkdownContent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MarkdownContent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<MarkdownContent.Markdown> values = ImmutableList.builder();
    private ImmutableList.Builder<MarkdownContent.ImageResource> images = ImmutableList.builder();
    private ImmutableList.Builder<MarkdownContent.LinkResource> links = ImmutableList.builder();
    private ImmutableList.Builder<String> locales = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MarkdownContent} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(MarkdownContent instance) {
      Objects.requireNonNull(instance, "instance");
      addAllValues(instance.getValues());
      addAllImages(instance.getImages());
      addAllLinks(instance.getLinks());
      addAllLocales(instance.getLocales());
      return this;
    }

    /**
     * Adds one element to {@link MarkdownContent#getValues() values} list.
     * @param element A values element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addValues(MarkdownContent.Markdown element) {
      this.values.add(element);
      return this;
    }

    /**
     * Adds elements to {@link MarkdownContent#getValues() values} list.
     * @param elements An array of values elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addValues(MarkdownContent.Markdown... elements) {
      this.values.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link MarkdownContent#getValues() values} list.
     * @param elements An iterable of values elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder values(Iterable<? extends MarkdownContent.Markdown> elements) {
      this.values = ImmutableList.builder();
      return addAllValues(elements);
    }

    /**
     * Adds elements to {@link MarkdownContent#getValues() values} list.
     * @param elements An iterable of values elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllValues(Iterable<? extends MarkdownContent.Markdown> elements) {
      this.values.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link MarkdownContent#getImages() images} list.
     * @param element A images element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addImages(MarkdownContent.ImageResource element) {
      this.images.add(element);
      return this;
    }

    /**
     * Adds elements to {@link MarkdownContent#getImages() images} list.
     * @param elements An array of images elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addImages(MarkdownContent.ImageResource... elements) {
      this.images.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link MarkdownContent#getImages() images} list.
     * @param elements An iterable of images elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder images(Iterable<? extends MarkdownContent.ImageResource> elements) {
      this.images = ImmutableList.builder();
      return addAllImages(elements);
    }

    /**
     * Adds elements to {@link MarkdownContent#getImages() images} list.
     * @param elements An iterable of images elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllImages(Iterable<? extends MarkdownContent.ImageResource> elements) {
      this.images.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link MarkdownContent#getLinks() links} list.
     * @param element A links element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLinks(MarkdownContent.LinkResource element) {
      this.links.add(element);
      return this;
    }

    /**
     * Adds elements to {@link MarkdownContent#getLinks() links} list.
     * @param elements An array of links elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLinks(MarkdownContent.LinkResource... elements) {
      this.links.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link MarkdownContent#getLinks() links} list.
     * @param elements An iterable of links elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder links(Iterable<? extends MarkdownContent.LinkResource> elements) {
      this.links = ImmutableList.builder();
      return addAllLinks(elements);
    }

    /**
     * Adds elements to {@link MarkdownContent#getLinks() links} list.
     * @param elements An iterable of links elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllLinks(Iterable<? extends MarkdownContent.LinkResource> elements) {
      this.links.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link MarkdownContent#getLocales() locales} list.
     * @param element A locales element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLocales(String element) {
      this.locales.add(element);
      return this;
    }

    /**
     * Adds elements to {@link MarkdownContent#getLocales() locales} list.
     * @param elements An array of locales elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLocales(String... elements) {
      this.locales.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link MarkdownContent#getLocales() locales} list.
     * @param elements An iterable of locales elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder locales(Iterable<String> elements) {
      this.locales = ImmutableList.builder();
      return addAllLocales(elements);
    }

    /**
     * Adds elements to {@link MarkdownContent#getLocales() locales} list.
     * @param elements An iterable of locales elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllLocales(Iterable<String> elements) {
      this.locales.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableMarkdownContent ImmutableMarkdownContent}.
     * @return An immutable instance of MarkdownContent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMarkdownContent build() {
      return new ImmutableMarkdownContent(values.build(), images.build(), links.build(), locales.build());
    }
  }
}
