package io.thestencil.staticontent.api;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StaticContentClient.TopicData}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTopicData.builder()}.
 */
@Generated(from = "StaticContentClient.TopicData", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTopicData implements StaticContentClient.TopicData {
  private final String path;
  private final String locale;
  private final String value;
  private final ImmutableList<MarkdownContent.Heading> headings;
  private final ImmutableList<MarkdownContent.ImageTag> images;

  private ImmutableTopicData(
      String path,
      String locale,
      String value,
      ImmutableList<MarkdownContent.Heading> headings,
      ImmutableList<MarkdownContent.ImageTag> images) {
    this.path = path;
    this.locale = locale;
    this.value = value;
    this.headings = headings;
    this.images = images;
  }

  /**
   * @return The value of the {@code path} attribute
   */
  @Override
  public String getPath() {
    return path;
  }

  /**
   * @return The value of the {@code locale} attribute
   */
  @Override
  public String getLocale() {
    return locale;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public String getValue() {
    return value;
  }

  /**
   * @return The value of the {@code headings} attribute
   */
  @Override
  public ImmutableList<MarkdownContent.Heading> getHeadings() {
    return headings;
  }

  /**
   * @return The value of the {@code images} attribute
   */
  @Override
  public ImmutableList<MarkdownContent.ImageTag> getImages() {
    return images;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StaticContentClient.TopicData#getPath() path} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for path
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTopicData withPath(String value) {
    String newValue = Objects.requireNonNull(value, "path");
    if (this.path.equals(newValue)) return this;
    return new ImmutableTopicData(newValue, this.locale, this.value, this.headings, this.images);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StaticContentClient.TopicData#getLocale() locale} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for locale
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTopicData withLocale(String value) {
    String newValue = Objects.requireNonNull(value, "locale");
    if (this.locale.equals(newValue)) return this;
    return new ImmutableTopicData(this.path, newValue, this.value, this.headings, this.images);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StaticContentClient.TopicData#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTopicData withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableTopicData(this.path, this.locale, newValue, this.headings, this.images);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StaticContentClient.TopicData#getHeadings() headings}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTopicData withHeadings(MarkdownContent.Heading... elements) {
    ImmutableList<MarkdownContent.Heading> newValue = ImmutableList.copyOf(elements);
    return new ImmutableTopicData(this.path, this.locale, this.value, newValue, this.images);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StaticContentClient.TopicData#getHeadings() headings}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of headings elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTopicData withHeadings(Iterable<? extends MarkdownContent.Heading> elements) {
    if (this.headings == elements) return this;
    ImmutableList<MarkdownContent.Heading> newValue = ImmutableList.copyOf(elements);
    return new ImmutableTopicData(this.path, this.locale, this.value, newValue, this.images);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StaticContentClient.TopicData#getImages() images}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTopicData withImages(MarkdownContent.ImageTag... elements) {
    ImmutableList<MarkdownContent.ImageTag> newValue = ImmutableList.copyOf(elements);
    return new ImmutableTopicData(this.path, this.locale, this.value, this.headings, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StaticContentClient.TopicData#getImages() images}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of images elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTopicData withImages(Iterable<? extends MarkdownContent.ImageTag> elements) {
    if (this.images == elements) return this;
    ImmutableList<MarkdownContent.ImageTag> newValue = ImmutableList.copyOf(elements);
    return new ImmutableTopicData(this.path, this.locale, this.value, this.headings, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTopicData} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTopicData
        && equalTo((ImmutableTopicData) another);
  }

  private boolean equalTo(ImmutableTopicData another) {
    return path.equals(another.path)
        && locale.equals(another.locale)
        && value.equals(another.value)
        && headings.equals(another.headings)
        && images.equals(another.images);
  }

  /**
   * Computes a hash code from attributes: {@code path}, {@code locale}, {@code value}, {@code headings}, {@code images}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + path.hashCode();
    h += (h << 5) + locale.hashCode();
    h += (h << 5) + value.hashCode();
    h += (h << 5) + headings.hashCode();
    h += (h << 5) + images.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TopicData} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TopicData")
        .omitNullValues()
        .add("path", path)
        .add("locale", locale)
        .add("value", value)
        .add("headings", headings)
        .add("images", images)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link StaticContentClient.TopicData} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TopicData instance
   */
  public static ImmutableTopicData copyOf(StaticContentClient.TopicData instance) {
    if (instance instanceof ImmutableTopicData) {
      return (ImmutableTopicData) instance;
    }
    return ImmutableTopicData.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTopicData ImmutableTopicData}.
   * <pre>
   * ImmutableTopicData.builder()
   *    .path(String) // required {@link StaticContentClient.TopicData#getPath() path}
   *    .locale(String) // required {@link StaticContentClient.TopicData#getLocale() locale}
   *    .value(String) // required {@link StaticContentClient.TopicData#getValue() value}
   *    .addHeadings|addAllHeadings(io.thestencil.staticontent.api.MarkdownContent.Heading) // {@link StaticContentClient.TopicData#getHeadings() headings} elements
   *    .addImages|addAllImages(io.thestencil.staticontent.api.MarkdownContent.ImageTag) // {@link StaticContentClient.TopicData#getImages() images} elements
   *    .build();
   * </pre>
   * @return A new ImmutableTopicData builder
   */
  public static ImmutableTopicData.Builder builder() {
    return new ImmutableTopicData.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTopicData ImmutableTopicData}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StaticContentClient.TopicData", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PATH = 0x1L;
    private static final long INIT_BIT_LOCALE = 0x2L;
    private static final long INIT_BIT_VALUE = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String path;
    private @Nullable String locale;
    private @Nullable String value;
    private ImmutableList.Builder<MarkdownContent.Heading> headings = ImmutableList.builder();
    private ImmutableList.Builder<MarkdownContent.ImageTag> images = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TopicData} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StaticContentClient.TopicData instance) {
      Objects.requireNonNull(instance, "instance");
      path(instance.getPath());
      locale(instance.getLocale());
      value(instance.getValue());
      addAllHeadings(instance.getHeadings());
      addAllImages(instance.getImages());
      return this;
    }

    /**
     * Initializes the value for the {@link StaticContentClient.TopicData#getPath() path} attribute.
     * @param path The value for path 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder path(String path) {
      this.path = Objects.requireNonNull(path, "path");
      initBits &= ~INIT_BIT_PATH;
      return this;
    }

    /**
     * Initializes the value for the {@link StaticContentClient.TopicData#getLocale() locale} attribute.
     * @param locale The value for locale 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder locale(String locale) {
      this.locale = Objects.requireNonNull(locale, "locale");
      initBits &= ~INIT_BIT_LOCALE;
      return this;
    }

    /**
     * Initializes the value for the {@link StaticContentClient.TopicData#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Adds one element to {@link StaticContentClient.TopicData#getHeadings() headings} list.
     * @param element A headings element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addHeadings(MarkdownContent.Heading element) {
      this.headings.add(element);
      return this;
    }

    /**
     * Adds elements to {@link StaticContentClient.TopicData#getHeadings() headings} list.
     * @param elements An array of headings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addHeadings(MarkdownContent.Heading... elements) {
      this.headings.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link StaticContentClient.TopicData#getHeadings() headings} list.
     * @param elements An iterable of headings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder headings(Iterable<? extends MarkdownContent.Heading> elements) {
      this.headings = ImmutableList.builder();
      return addAllHeadings(elements);
    }

    /**
     * Adds elements to {@link StaticContentClient.TopicData#getHeadings() headings} list.
     * @param elements An iterable of headings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllHeadings(Iterable<? extends MarkdownContent.Heading> elements) {
      this.headings.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link StaticContentClient.TopicData#getImages() images} list.
     * @param element A images element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addImages(MarkdownContent.ImageTag element) {
      this.images.add(element);
      return this;
    }

    /**
     * Adds elements to {@link StaticContentClient.TopicData#getImages() images} list.
     * @param elements An array of images elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addImages(MarkdownContent.ImageTag... elements) {
      this.images.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link StaticContentClient.TopicData#getImages() images} list.
     * @param elements An iterable of images elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder images(Iterable<? extends MarkdownContent.ImageTag> elements) {
      this.images = ImmutableList.builder();
      return addAllImages(elements);
    }

    /**
     * Adds elements to {@link StaticContentClient.TopicData#getImages() images} list.
     * @param elements An iterable of images elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllImages(Iterable<? extends MarkdownContent.ImageTag> elements) {
      this.images.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableTopicData ImmutableTopicData}.
     * @return An immutable instance of TopicData
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTopicData build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTopicData(path, locale, value, headings.build(), images.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PATH) != 0) attributes.add("path");
      if ((initBits & INIT_BIT_LOCALE) != 0) attributes.add("locale");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build TopicData, some of required attributes are not set " + attributes;
    }
  }
}
