package io.thestencil.staticontent.api;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StaticContentClient.LinkData}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLinkData.builder()}.
 */
@Generated(from = "StaticContentClient.LinkData", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableLinkData implements StaticContentClient.LinkData {
  private final String id;
  private final String path;
  private final String name;
  private final String type;
  private final String value;
  private final String locale;
  private final Boolean workflow;

  private ImmutableLinkData(
      String id,
      String path,
      String name,
      String type,
      String value,
      String locale,
      Boolean workflow) {
    this.id = id;
    this.path = path;
    this.name = name;
    this.type = type;
    this.value = value;
    this.locale = locale;
    this.workflow = workflow;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code path} attribute
   */
  @Override
  public String getPath() {
    return path;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public String getValue() {
    return value;
  }

  /**
   * @return The value of the {@code locale} attribute
   */
  @Override
  public String getLocale() {
    return locale;
  }

  /**
   * @return The value of the {@code workflow} attribute
   */
  @Override
  public Boolean getWorkflow() {
    return workflow;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StaticContentClient.LinkData#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLinkData withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableLinkData(newValue, this.path, this.name, this.type, this.value, this.locale, this.workflow);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StaticContentClient.LinkData#getPath() path} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for path
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLinkData withPath(String value) {
    String newValue = Objects.requireNonNull(value, "path");
    if (this.path.equals(newValue)) return this;
    return new ImmutableLinkData(this.id, newValue, this.name, this.type, this.value, this.locale, this.workflow);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StaticContentClient.LinkData#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLinkData withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableLinkData(this.id, this.path, newValue, this.type, this.value, this.locale, this.workflow);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StaticContentClient.LinkData#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLinkData withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableLinkData(this.id, this.path, this.name, newValue, this.value, this.locale, this.workflow);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StaticContentClient.LinkData#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLinkData withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableLinkData(this.id, this.path, this.name, this.type, newValue, this.locale, this.workflow);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StaticContentClient.LinkData#getLocale() locale} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for locale
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLinkData withLocale(String value) {
    String newValue = Objects.requireNonNull(value, "locale");
    if (this.locale.equals(newValue)) return this;
    return new ImmutableLinkData(this.id, this.path, this.name, this.type, this.value, newValue, this.workflow);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StaticContentClient.LinkData#getWorkflow() workflow} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for workflow
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLinkData withWorkflow(Boolean value) {
    Boolean newValue = Objects.requireNonNull(value, "workflow");
    if (this.workflow.equals(newValue)) return this;
    return new ImmutableLinkData(this.id, this.path, this.name, this.type, this.value, this.locale, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLinkData} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLinkData
        && equalTo((ImmutableLinkData) another);
  }

  private boolean equalTo(ImmutableLinkData another) {
    return id.equals(another.id)
        && path.equals(another.path)
        && name.equals(another.name)
        && type.equals(another.type)
        && value.equals(another.value)
        && locale.equals(another.locale)
        && workflow.equals(another.workflow);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code path}, {@code name}, {@code type}, {@code value}, {@code locale}, {@code workflow}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + path.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + value.hashCode();
    h += (h << 5) + locale.hashCode();
    h += (h << 5) + workflow.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code LinkData} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("LinkData")
        .omitNullValues()
        .add("id", id)
        .add("path", path)
        .add("name", name)
        .add("type", type)
        .add("value", value)
        .add("locale", locale)
        .add("workflow", workflow)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link StaticContentClient.LinkData} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable LinkData instance
   */
  public static ImmutableLinkData copyOf(StaticContentClient.LinkData instance) {
    if (instance instanceof ImmutableLinkData) {
      return (ImmutableLinkData) instance;
    }
    return ImmutableLinkData.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLinkData ImmutableLinkData}.
   * <pre>
   * ImmutableLinkData.builder()
   *    .id(String) // required {@link StaticContentClient.LinkData#getId() id}
   *    .path(String) // required {@link StaticContentClient.LinkData#getPath() path}
   *    .name(String) // required {@link StaticContentClient.LinkData#getName() name}
   *    .type(String) // required {@link StaticContentClient.LinkData#getType() type}
   *    .value(String) // required {@link StaticContentClient.LinkData#getValue() value}
   *    .locale(String) // required {@link StaticContentClient.LinkData#getLocale() locale}
   *    .workflow(Boolean) // required {@link StaticContentClient.LinkData#getWorkflow() workflow}
   *    .build();
   * </pre>
   * @return A new ImmutableLinkData builder
   */
  public static ImmutableLinkData.Builder builder() {
    return new ImmutableLinkData.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLinkData ImmutableLinkData}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StaticContentClient.LinkData", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_PATH = 0x2L;
    private static final long INIT_BIT_NAME = 0x4L;
    private static final long INIT_BIT_TYPE = 0x8L;
    private static final long INIT_BIT_VALUE = 0x10L;
    private static final long INIT_BIT_LOCALE = 0x20L;
    private static final long INIT_BIT_WORKFLOW = 0x40L;
    private long initBits = 0x7fL;

    private @Nullable String id;
    private @Nullable String path;
    private @Nullable String name;
    private @Nullable String type;
    private @Nullable String value;
    private @Nullable String locale;
    private @Nullable Boolean workflow;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code LinkData} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StaticContentClient.LinkData instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      path(instance.getPath());
      name(instance.getName());
      type(instance.getType());
      value(instance.getValue());
      locale(instance.getLocale());
      workflow(instance.getWorkflow());
      return this;
    }

    /**
     * Initializes the value for the {@link StaticContentClient.LinkData#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link StaticContentClient.LinkData#getPath() path} attribute.
     * @param path The value for path 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder path(String path) {
      this.path = Objects.requireNonNull(path, "path");
      initBits &= ~INIT_BIT_PATH;
      return this;
    }

    /**
     * Initializes the value for the {@link StaticContentClient.LinkData#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link StaticContentClient.LinkData#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link StaticContentClient.LinkData#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link StaticContentClient.LinkData#getLocale() locale} attribute.
     * @param locale The value for locale 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder locale(String locale) {
      this.locale = Objects.requireNonNull(locale, "locale");
      initBits &= ~INIT_BIT_LOCALE;
      return this;
    }

    /**
     * Initializes the value for the {@link StaticContentClient.LinkData#getWorkflow() workflow} attribute.
     * @param workflow The value for workflow 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder workflow(Boolean workflow) {
      this.workflow = Objects.requireNonNull(workflow, "workflow");
      initBits &= ~INIT_BIT_WORKFLOW;
      return this;
    }

    /**
     * Builds a new {@link ImmutableLinkData ImmutableLinkData}.
     * @return An immutable instance of LinkData
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLinkData build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableLinkData(id, path, name, type, value, locale, workflow);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_PATH) != 0) attributes.add("path");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      if ((initBits & INIT_BIT_LOCALE) != 0) attributes.add("locale");
      if ((initBits & INIT_BIT_WORKFLOW) != 0) attributes.add("workflow");
      return "Cannot build LinkData, some of required attributes are not set " + attributes;
    }
  }
}
