package io.thestencil.staticontent.api;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MarkdownContent.Heading}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableHeading.builder()}.
 */
@Generated(from = "MarkdownContent.Heading", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableHeading implements MarkdownContent.Heading {
  private final Integer order;
  private final Integer level;
  private final String name;

  private ImmutableHeading(Integer order, Integer level, String name) {
    this.order = order;
    this.level = level;
    this.name = name;
  }

  /**
   * @return The value of the {@code order} attribute
   */
  @Override
  public Integer getOrder() {
    return order;
  }

  /**
   * @return The value of the {@code level} attribute
   */
  @Override
  public Integer getLevel() {
    return level;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MarkdownContent.Heading#getOrder() order} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for order
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHeading withOrder(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "order");
    if (this.order.equals(newValue)) return this;
    return new ImmutableHeading(newValue, this.level, this.name);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MarkdownContent.Heading#getLevel() level} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for level
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHeading withLevel(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "level");
    if (this.level.equals(newValue)) return this;
    return new ImmutableHeading(this.order, newValue, this.name);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MarkdownContent.Heading#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHeading withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableHeading(this.order, this.level, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableHeading} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableHeading
        && equalTo((ImmutableHeading) another);
  }

  private boolean equalTo(ImmutableHeading another) {
    return order.equals(another.order)
        && level.equals(another.level)
        && name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code order}, {@code level}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + order.hashCode();
    h += (h << 5) + level.hashCode();
    h += (h << 5) + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Heading} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Heading")
        .omitNullValues()
        .add("order", order)
        .add("level", level)
        .add("name", name)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link MarkdownContent.Heading} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Heading instance
   */
  public static ImmutableHeading copyOf(MarkdownContent.Heading instance) {
    if (instance instanceof ImmutableHeading) {
      return (ImmutableHeading) instance;
    }
    return ImmutableHeading.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableHeading ImmutableHeading}.
   * <pre>
   * ImmutableHeading.builder()
   *    .order(Integer) // required {@link MarkdownContent.Heading#getOrder() order}
   *    .level(Integer) // required {@link MarkdownContent.Heading#getLevel() level}
   *    .name(String) // required {@link MarkdownContent.Heading#getName() name}
   *    .build();
   * </pre>
   * @return A new ImmutableHeading builder
   */
  public static ImmutableHeading.Builder builder() {
    return new ImmutableHeading.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableHeading ImmutableHeading}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MarkdownContent.Heading", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ORDER = 0x1L;
    private static final long INIT_BIT_LEVEL = 0x2L;
    private static final long INIT_BIT_NAME = 0x4L;
    private long initBits = 0x7L;

    private @Nullable Integer order;
    private @Nullable Integer level;
    private @Nullable String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Heading} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(MarkdownContent.Heading instance) {
      Objects.requireNonNull(instance, "instance");
      order(instance.getOrder());
      level(instance.getLevel());
      name(instance.getName());
      return this;
    }

    /**
     * Initializes the value for the {@link MarkdownContent.Heading#getOrder() order} attribute.
     * @param order The value for order 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder order(Integer order) {
      this.order = Objects.requireNonNull(order, "order");
      initBits &= ~INIT_BIT_ORDER;
      return this;
    }

    /**
     * Initializes the value for the {@link MarkdownContent.Heading#getLevel() level} attribute.
     * @param level The value for level 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder level(Integer level) {
      this.level = Objects.requireNonNull(level, "level");
      initBits &= ~INIT_BIT_LEVEL;
      return this;
    }

    /**
     * Initializes the value for the {@link MarkdownContent.Heading#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableHeading ImmutableHeading}.
     * @return An immutable instance of Heading
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableHeading build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableHeading(order, level, name);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ORDER) != 0) attributes.add("order");
      if ((initBits & INIT_BIT_LEVEL) != 0) attributes.add("level");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build Heading, some of required attributes are not set " + attributes;
    }
  }
}
