/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.staticontent.api;

import io.thestencil.persistence.api.ZoePersistence;
import io.thestencil.staticontent.api.ImmutableImageData;
import io.thestencil.staticontent.api.ImmutableLinkData;
import io.thestencil.staticontent.api.ImmutableTopicData;
import io.thestencil.staticontent.api.ImmutableTopicNameData;
import io.thestencil.staticontent.api.MarkdownContent;
import io.thestencil.staticontent.api.SiteContent;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.immutables.value.Value;

public interface StaticContentClient {
    public StaticContentBuilder create();

    public StaticContentBuilder from(ZoePersistence.SiteState var1);

    public StaticContentBuilder from(MarkdownContent var1);

    public ZoePersistence.SiteState parseSiteState(String var1);

    public MarkdownContent parseMd(ZoePersistence.SiteState var1);

    public FileParser parseFiles();

    @Value.Immutable
    public static interface ImageData {
        public String getPath();

        public byte[] getValue();
    }

    @Value.Immutable
    public static interface LinkData {
        public String getId();

        public String getPath();

        public String getName();

        public String getType();

        public String getValue();

        public String getLocale();

        public Boolean getWorkflow();
    }

    @Value.Immutable
    public static interface TopicNameData {
        public String getPath();

        public Map<String, String> getLocale();
    }

    @Value.Immutable
    public static interface TopicData {
        public String getPath();

        public String getLocale();

        public String getValue();

        public List<MarkdownContent.Heading> getHeadings();

        public List<MarkdownContent.ImageTag> getImages();
    }

    public static interface StaticContentBuilder {
        public StaticContentBuilder topic(Function<ImmutableTopicData.Builder, TopicData> var1);

        public StaticContentBuilder topicName(Function<ImmutableTopicNameData.Builder, TopicNameData> var1);

        public StaticContentBuilder link(Function<ImmutableLinkData.Builder, LinkData> var1);

        public StaticContentBuilder image(Function<ImmutableImageData.Builder, ImageData> var1);

        public StaticContentBuilder imageUrl(String var1);

        public StaticContentBuilder created(long var1);

        public SiteContent build();
    }

    public static interface FileParser {
        public FileParser add(String var1, byte[] var2);

        public MarkdownContent build();
    }
}

