/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.staticontent.api;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.staticontent.api.MarkdownContent;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MarkdownContent", generator="Immutables")
@Immutable
public final class ImmutableMarkdownContent
implements MarkdownContent {
    private final ImmutableList<MarkdownContent.Markdown> values;
    private final ImmutableList<MarkdownContent.ImageResource> images;
    private final ImmutableList<MarkdownContent.LinkResource> links;
    private final ImmutableList<String> locales;

    private ImmutableMarkdownContent(ImmutableList<MarkdownContent.Markdown> values, ImmutableList<MarkdownContent.ImageResource> images, ImmutableList<MarkdownContent.LinkResource> links, ImmutableList<String> locales) {
        this.values = values;
        this.images = images;
        this.links = links;
        this.locales = locales;
    }

    public ImmutableList<MarkdownContent.Markdown> getValues() {
        return this.values;
    }

    public ImmutableList<MarkdownContent.ImageResource> getImages() {
        return this.images;
    }

    public ImmutableList<MarkdownContent.LinkResource> getLinks() {
        return this.links;
    }

    public ImmutableList<String> getLocales() {
        return this.locales;
    }

    public final ImmutableMarkdownContent withValues(MarkdownContent.Markdown ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableMarkdownContent((ImmutableList<MarkdownContent.Markdown>)newValue, this.images, this.links, this.locales);
    }

    public final ImmutableMarkdownContent withValues(Iterable<? extends MarkdownContent.Markdown> elements) {
        if (this.values == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMarkdownContent((ImmutableList<MarkdownContent.Markdown>)newValue, this.images, this.links, this.locales);
    }

    public final ImmutableMarkdownContent withImages(MarkdownContent.ImageResource ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableMarkdownContent(this.values, (ImmutableList<MarkdownContent.ImageResource>)newValue, this.links, this.locales);
    }

    public final ImmutableMarkdownContent withImages(Iterable<? extends MarkdownContent.ImageResource> elements) {
        if (this.images == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMarkdownContent(this.values, (ImmutableList<MarkdownContent.ImageResource>)newValue, this.links, this.locales);
    }

    public final ImmutableMarkdownContent withLinks(MarkdownContent.LinkResource ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableMarkdownContent(this.values, this.images, (ImmutableList<MarkdownContent.LinkResource>)newValue, this.locales);
    }

    public final ImmutableMarkdownContent withLinks(Iterable<? extends MarkdownContent.LinkResource> elements) {
        if (this.links == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMarkdownContent(this.values, this.images, (ImmutableList<MarkdownContent.LinkResource>)newValue, this.locales);
    }

    public final ImmutableMarkdownContent withLocales(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableMarkdownContent(this.values, this.images, this.links, (ImmutableList<String>)newValue);
    }

    public final ImmutableMarkdownContent withLocales(Iterable<String> elements) {
        if (this.locales == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMarkdownContent(this.values, this.images, this.links, (ImmutableList<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMarkdownContent && this.equalTo((ImmutableMarkdownContent)another);
    }

    private boolean equalTo(ImmutableMarkdownContent another) {
        return this.values.equals(another.values) && this.images.equals(another.images) && this.links.equals(another.links) && this.locales.equals(another.locales);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.values.hashCode();
        h += (h << 5) + this.images.hashCode();
        h += (h << 5) + this.links.hashCode();
        h += (h << 5) + this.locales.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MarkdownContent").omitNullValues().add("values", this.values).add("images", this.images).add("links", this.links).add("locales", this.locales).toString();
    }

    public static ImmutableMarkdownContent copyOf(MarkdownContent instance) {
        if (instance instanceof ImmutableMarkdownContent) {
            return (ImmutableMarkdownContent)instance;
        }
        return ImmutableMarkdownContent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MarkdownContent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<MarkdownContent.Markdown> values = ImmutableList.builder();
        private ImmutableList.Builder<MarkdownContent.ImageResource> images = ImmutableList.builder();
        private ImmutableList.Builder<MarkdownContent.LinkResource> links = ImmutableList.builder();
        private ImmutableList.Builder<String> locales = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MarkdownContent instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllValues(instance.getValues());
            this.addAllImages(instance.getImages());
            this.addAllLinks(instance.getLinks());
            this.addAllLocales(instance.getLocales());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addValues(MarkdownContent.Markdown element) {
            this.values.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addValues(MarkdownContent.Markdown ... elements) {
            this.values.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder values(Iterable<? extends MarkdownContent.Markdown> elements) {
            this.values = ImmutableList.builder();
            return this.addAllValues(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllValues(Iterable<? extends MarkdownContent.Markdown> elements) {
            this.values.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addImages(MarkdownContent.ImageResource element) {
            this.images.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addImages(MarkdownContent.ImageResource ... elements) {
            this.images.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder images(Iterable<? extends MarkdownContent.ImageResource> elements) {
            this.images = ImmutableList.builder();
            return this.addAllImages(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllImages(Iterable<? extends MarkdownContent.ImageResource> elements) {
            this.images.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLinks(MarkdownContent.LinkResource element) {
            this.links.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLinks(MarkdownContent.LinkResource ... elements) {
            this.links.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder links(Iterable<? extends MarkdownContent.LinkResource> elements) {
            this.links = ImmutableList.builder();
            return this.addAllLinks(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLinks(Iterable<? extends MarkdownContent.LinkResource> elements) {
            this.links.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLocales(String element) {
            this.locales.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLocales(String ... elements) {
            this.locales.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder locales(Iterable<String> elements) {
            this.locales = ImmutableList.builder();
            return this.addAllLocales(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLocales(Iterable<String> elements) {
            this.locales.addAll(elements);
            return this;
        }

        public ImmutableMarkdownContent build() {
            return new ImmutableMarkdownContent((ImmutableList<MarkdownContent.Markdown>)this.values.build(), (ImmutableList<MarkdownContent.ImageResource>)this.images.build(), (ImmutableList<MarkdownContent.LinkResource>)this.links.build(), (ImmutableList<String>)this.locales.build());
        }
    }
}

