/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.staticontent.api;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.staticontent.api.MarkdownContent;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MarkdownContent.ImageTag", generator="Immutables")
@Immutable
public final class ImmutableImageTag
implements MarkdownContent.ImageTag {
    private final Integer line;
    private final String title;
    private final String altText;
    private final String path;

    private ImmutableImageTag(Integer line, String title, String altText, String path) {
        this.line = line;
        this.title = title;
        this.altText = altText;
        this.path = path;
    }

    @Override
    public Integer getLine() {
        return this.line;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getAltText() {
        return this.altText;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public final ImmutableImageTag withLine(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "line");
        if (this.line.equals(newValue)) {
            return this;
        }
        return new ImmutableImageTag(newValue, this.title, this.altText, this.path);
    }

    public final ImmutableImageTag withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableImageTag(this.line, newValue, this.altText, this.path);
    }

    public final ImmutableImageTag withAltText(String value) {
        String newValue = Objects.requireNonNull(value, "altText");
        if (this.altText.equals(newValue)) {
            return this;
        }
        return new ImmutableImageTag(this.line, this.title, newValue, this.path);
    }

    public final ImmutableImageTag withPath(String value) {
        String newValue = Objects.requireNonNull(value, "path");
        if (this.path.equals(newValue)) {
            return this;
        }
        return new ImmutableImageTag(this.line, this.title, this.altText, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableImageTag && this.equalTo((ImmutableImageTag)another);
    }

    private boolean equalTo(ImmutableImageTag another) {
        return this.line.equals(another.line) && this.title.equals(another.title) && this.altText.equals(another.altText) && this.path.equals(another.path);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.line.hashCode();
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.altText.hashCode();
        h += (h << 5) + this.path.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ImageTag").omitNullValues().add("line", (Object)this.line).add("title", (Object)this.title).add("altText", (Object)this.altText).add("path", (Object)this.path).toString();
    }

    public static ImmutableImageTag copyOf(MarkdownContent.ImageTag instance) {
        if (instance instanceof ImmutableImageTag) {
            return (ImmutableImageTag)instance;
        }
        return ImmutableImageTag.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MarkdownContent.ImageTag", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LINE = 1L;
        private static final long INIT_BIT_TITLE = 2L;
        private static final long INIT_BIT_ALT_TEXT = 4L;
        private static final long INIT_BIT_PATH = 8L;
        private long initBits = 15L;
        @Nullable
        private Integer line;
        @Nullable
        private String title;
        @Nullable
        private String altText;
        @Nullable
        private String path;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MarkdownContent.ImageTag instance) {
            Objects.requireNonNull(instance, "instance");
            this.line(instance.getLine());
            this.title(instance.getTitle());
            this.altText(instance.getAltText());
            this.path(instance.getPath());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder line(Integer line) {
            this.line = Objects.requireNonNull(line, "line");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder altText(String altText) {
            this.altText = Objects.requireNonNull(altText, "altText");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder path(String path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableImageTag build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableImageTag(this.line, this.title, this.altText, this.path);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("line");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("title");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("altText");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("path");
            }
            return "Cannot build ImageTag, some of required attributes are not set " + attributes;
        }
    }
}

