/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.staticontent.spi.visitor;

import io.thestencil.staticontent.api.MarkdownContent;
import io.thestencil.staticontent.api.SiteContent;
import io.thestencil.staticontent.api.StaticContentClient;
import io.thestencil.staticontent.spi.beans.MutableBlob;
import io.thestencil.staticontent.spi.beans.MutableSite;
import io.thestencil.staticontent.spi.beans.MutableTopic;
import io.thestencil.staticontent.spi.beans.MutableTopicHeading;
import io.thestencil.staticontent.spi.beans.MutableTopicLink;
import io.thestencil.staticontent.spi.support.ParserAssert;
import io.thestencil.staticontent.spi.support.Sha2;
import io.thestencil.staticontent.spi.visitor.ImmutableMessage;
import io.thestencil.staticontent.spi.visitor.ImmutableSites;
import io.thestencil.staticontent.spi.visitor.SiteVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SiteVisitorDefault
implements SiteVisitor {
    private final List<SiteVisitor.Message> messages = new ArrayList<SiteVisitor.Message>();
    private final Map<String, List<StaticContentClient.TopicData>> localeTopicData = new HashMap<String, List<StaticContentClient.TopicData>>();
    private final Map<String, List<StaticContentClient.LinkData>> pathLinkData = new HashMap<String, List<StaticContentClient.LinkData>>();
    private final Map<String, StaticContentClient.TopicNameData> pathTopicNamesData = new HashMap<String, StaticContentClient.TopicNameData>();
    private final Map<String, StaticContentClient.ImageData> images = new HashMap<String, StaticContentClient.ImageData>();
    private final Map<String, SiteContent.Blob> blobs = new HashMap<String, SiteContent.Blob>();
    private final Map<String, SiteContent.TopicLink> links = new HashMap<String, SiteContent.TopicLink>();
    private final Function<Object, String> serializer;
    private String imageUrl;

    public SiteVisitorDefault(Function<Object, String> serializer) {
        this.serializer = serializer;
    }

    @Override
    public void visitTopicData(StaticContentClient.TopicData topic) {
        List<StaticContentClient.TopicData> topics = this.localeTopicData.get(topic.getLocale());
        if (topics == null) {
            topics = new ArrayList<StaticContentClient.TopicData>();
            this.localeTopicData.put(topic.getLocale(), topics);
        }
        topics.add(topic);
    }

    @Override
    public void visitLinkData(StaticContentClient.LinkData link) {
        List<StaticContentClient.LinkData> links = this.pathLinkData.get(link.getPath());
        if (links == null) {
            links = new ArrayList<StaticContentClient.LinkData>();
            this.pathLinkData.put(link.getPath(), links);
        }
        links.add(link);
    }

    @Override
    public void visitImageData(StaticContentClient.ImageData image) {
        ParserAssert.isTrue(!this.images.containsKey(image.getPath()), () -> "Image with path: '" + image.getPath() + "' is already defined!");
        this.images.put(image.getPath(), image);
    }

    @Override
    public void visitTopicNameData(StaticContentClient.TopicNameData names) {
        this.pathTopicNamesData.put(names.getPath(), names);
    }

    @Override
    public SiteVisitor.Sites visit(String imageUrl) {
        this.imageUrl = imageUrl;
        ImmutableSites.Builder builder = ImmutableSites.builder();
        List sites = this.localeTopicData.entrySet().stream().map(this::visitLocale).collect(Collectors.toList());
        return builder.sites(sites).addAllMessage(this.messages).build();
    }

    private SiteContent.Site visitLocale(Map.Entry<String, List<StaticContentClient.TopicData>> localization) {
        HashMap<String, SiteContent.Topic> siteTopics = new HashMap<String, SiteContent.Topic>();
        HashMap<String, SiteContent.Blob> siteBlobs = new HashMap<String, SiteContent.Blob>();
        HashMap<String, SiteContent.TopicLink> siteLinks = new HashMap<String, SiteContent.TopicLink>();
        ArrayList<String> visitedTopics = new ArrayList<String>();
        ArrayList<String> parents = new ArrayList<String>();
        String locale = localization.getKey();
        for (StaticContentClient.TopicData src : localization.getValue()) {
            String topicId = src.getPath();
            String parent = this.visitTopicParent(src);
            String name = this.visitTopicName(src);
            String blob = this.visitTopicBlob(src);
            List<String> topicLinks = this.visitTopicLinks(topicId, locale);
            List<SiteContent.TopicHeading> topicHeadings = this.visitTopicHeadings(src);
            MutableTopic topic = new MutableTopic(topicId, name, topicLinks, parent, blob, topicHeadings);
            if (parent != null) {
                parents.add(parent);
            }
            visitedTopics.add(topicId);
            siteTopics.put(topic.getId(), topic);
            topic.getLinks().forEach(link -> siteLinks.put((String)link, this.links.get(link)));
            siteBlobs.put(topic.getBlob(), this.blobs.get(topic.getBlob()));
        }
        for (String parent : parents) {
            if (visitedTopics.contains(parent)) continue;
            String id = parent;
            String name = this.visitTopicName(parent, locale);
            List<String> topicLinks = this.visitTopicLinks(id, locale);
            MutableTopic topic = new MutableTopic(id, name, topicLinks, null, null, Collections.emptyList());
            topic.getLinks().forEach(link -> siteLinks.put((String)link, this.links.get(link)));
            siteTopics.put(topic.getId(), topic);
        }
        String id = Sha2.blobId(this.serializer.apply(new MutableSite("", this.imageUrl, locale, siteTopics, siteBlobs, siteLinks)));
        return new MutableSite(id, this.imageUrl, locale, siteTopics, siteBlobs, siteLinks);
    }

    private String visitTopicParent(StaticContentClient.TopicData topic) {
        String[] path = topic.getPath().split("\\/");
        if (path.length > 1) {
            return path[0];
        }
        return null;
    }

    private String visitTopicName(String path, String locale) {
        StaticContentClient.TopicNameData locales = this.pathTopicNamesData.get(path);
        if (locales == null) {
            this.messages.add(ImmutableMessage.builder().text("Missing localized: '" + locale + "' name for path: '" + path + "'!").build());
            return path;
        }
        String name = locales.getLocale().get(locale);
        if (name == null || name.isBlank()) {
            this.messages.add(ImmutableMessage.builder().text("Missing localized: '" + locale + "' name for path: '" + path + "'!").build());
            return path;
        }
        return path;
    }

    private String visitTopicName(StaticContentClient.TopicData topic) {
        for (MarkdownContent.Heading heading : topic.getHeadings()) {
            if (heading.getLevel() != 1 || heading.getName().length() <= 1) continue;
            return heading.getName().substring(1).trim();
        }
        StaticContentClient.TopicNameData locales = this.pathTopicNamesData.get(topic.getPath());
        if (locales == null) {
            this.messages.add(ImmutableMessage.builder().text("Missing localized: '" + topic.getLocale() + "' name for path: '" + topic.getPath() + "'!").object(topic).build());
            return topic.getPath();
        }
        String name = locales.getLocale().get(topic.getLocale());
        if (name == null || name.isBlank()) {
            this.messages.add(ImmutableMessage.builder().text("Missing localized: '" + topic.getLocale() + "' name for path: '" + topic.getPath() + "'!").object(topic).build());
            return topic.getPath();
        }
        return name;
    }

    private String visitTopicBlob(StaticContentClient.TopicData topic) {
        String blob = topic.getValue();
        String id = Sha2.blobId(blob);
        this.blobs.put(id, new MutableBlob(id, blob));
        return id;
    }

    private List<SiteContent.TopicHeading> visitTopicHeadings(StaticContentClient.TopicData topic) {
        ArrayList<SiteContent.TopicHeading> result = new ArrayList<SiteContent.TopicHeading>();
        int index = 1;
        for (MarkdownContent.Heading heading : topic.getHeadings()) {
            result.add(new MutableTopicHeading(String.valueOf(index++), heading.getName(), heading.getOrder(), heading.getLevel()));
        }
        return result;
    }

    private List<String> visitTopicLinks(String path, String locale) {
        int prefix;
        List<StaticContentClient.LinkData> src = this.pathLinkData.get(path);
        if (src == null && (prefix = path.indexOf("_")) > -1) {
            src = this.pathLinkData.get(path.substring(prefix + 1));
        }
        ArrayList links = new ArrayList(src == null ? Collections.emptyList() : src);
        links.addAll(this.pathLinkData.getOrDefault("", Collections.emptyList()));
        ArrayList<String> result = new ArrayList<String>();
        for (StaticContentClient.LinkData link : links) {
            boolean topicLocale;
            boolean allLocales = link.getLocale() == null || link.getLocale().isBlank();
            boolean bl = topicLocale = link.getLocale() != null && link.getLocale().indexOf(locale) > -1;
            if (!allLocales && !topicLocale) continue;
            MutableTopicLink template = new MutableTopicLink("template", link.getType(), link.getName(), link.getValue(), link.getWorkflow());
            String id = Sha2.blobId(template.toString());
            this.links.put(id, new MutableTopicLink(id, template.getType(), template.getName(), template.getValue(), template.getSecured()));
            result.add(id);
        }
        return result;
    }
}

