/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.staticontent.spi.visitor;

import io.thestencil.persistence.api.ZoePersistence;
import io.thestencil.staticontent.api.ImmutableLinkResource;
import io.thestencil.staticontent.api.ImmutableMarkdown;
import io.thestencil.staticontent.api.ImmutableMarkdownContent;
import io.thestencil.staticontent.api.MarkdownContent;
import io.thestencil.staticontent.spi.visitor.MarkdownException;
import io.thestencil.staticontent.spi.visitor.MarkdownVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class SiteStateVisitor {
    public static String LINK_TYPE_WORKFLOW = "workflow";
    private final List<ZoePersistence.Entity<ZoePersistence.Locale>> locales = new ArrayList<ZoePersistence.Entity<ZoePersistence.Locale>>();
    private ZoePersistence.SiteState entity;

    public MarkdownContent visit(ZoePersistence.SiteState entity) {
        this.entity = entity;
        ImmutableMarkdownContent.Builder result = ImmutableMarkdownContent.builder().addAllLocales(this.visitLocales(entity).stream().map(e -> ((ZoePersistence.Locale)e.getBody()).getValue()).collect(Collectors.toList()));
        for (ZoePersistence.Entity article : entity.getArticles().values()) {
            result.addAllValues(this.visitArticle((ZoePersistence.Entity<ZoePersistence.Article>)article));
        }
        for (ZoePersistence.Entity link : entity.getLinks().values()) {
            result.addAllLinks(this.visitLinks((ZoePersistence.Entity<ZoePersistence.Link>)link));
        }
        for (ZoePersistence.Entity link : entity.getWorkflows().values()) {
            result.addAllLinks(this.visitWorkflows((ZoePersistence.Entity<ZoePersistence.Workflow>)link));
        }
        return result.build();
    }

    private List<MarkdownContent.LinkResource> visitWorkflows(ZoePersistence.Entity<ZoePersistence.Workflow> link) {
        ArrayList<MarkdownContent.LinkResource> result = new ArrayList<MarkdownContent.LinkResource>();
        for (String articleId : ((ZoePersistence.Workflow)link.getBody()).getArticles()) {
            Optional<ZoePersistence.Entity> locale = this.locales.stream().filter(l -> ((ZoePersistence.Workflow)link.getBody()).getLocale().equals(l.getId())).findFirst();
            if (locale.isEmpty()) continue;
            ZoePersistence.Entity article = (ZoePersistence.Entity)this.entity.getArticles().get(articleId);
            ImmutableLinkResource resource = ImmutableLinkResource.builder().id(link.getId() + "-" + ((ZoePersistence.Locale)locale.get().getBody()).getValue()).addLocale(((ZoePersistence.Locale)locale.get().getBody()).getValue()).desc(((ZoePersistence.Workflow)link.getBody()).getName()).path(this.visitArticlePath((ZoePersistence.Entity<ZoePersistence.Article>)article)).value(((ZoePersistence.Workflow)link.getBody()).getContent()).workflow(true).type(LINK_TYPE_WORKFLOW).build();
            result.add(resource);
        }
        return result;
    }

    private List<MarkdownContent.LinkResource> visitLinks(ZoePersistence.Entity<ZoePersistence.Link> link) {
        ArrayList<MarkdownContent.LinkResource> result = new ArrayList<MarkdownContent.LinkResource>();
        for (String articleId : ((ZoePersistence.Link)link.getBody()).getArticles()) {
            Optional<ZoePersistence.Entity> locale = this.locales.stream().filter(l -> ((ZoePersistence.Link)link.getBody()).getLocale().equals(l.getId())).findFirst();
            if (locale.isEmpty()) continue;
            ZoePersistence.Entity article = (ZoePersistence.Entity)this.entity.getArticles().get(articleId);
            ImmutableLinkResource resource = ImmutableLinkResource.builder().id(link.getId() + "-" + ((ZoePersistence.Locale)locale.get().getBody()).getValue()).addLocale(((ZoePersistence.Locale)locale.get().getBody()).getValue()).desc(((ZoePersistence.Link)link.getBody()).getDescription()).path(this.visitArticlePath((ZoePersistence.Entity<ZoePersistence.Article>)article)).value(((ZoePersistence.Link)link.getBody()).getContent()).workflow(false).type(((ZoePersistence.Link)link.getBody()).getContentType()).build();
            result.add(resource);
        }
        return result;
    }

    private List<MarkdownContent.Markdown> visitArticle(ZoePersistence.Entity<ZoePersistence.Article> article) {
        String path = this.visitArticlePath(article);
        ArrayList<MarkdownContent.Markdown> result = new ArrayList<MarkdownContent.Markdown>();
        for (ZoePersistence.Entity page : this.entity.getPages().values()) {
            Optional<ZoePersistence.Entity> locale;
            if (!((ZoePersistence.Page)page.getBody()).getArticle().equals(article.getId()) || (locale = this.locales.stream().filter(l -> ((ZoePersistence.Page)page.getBody()).getLocale().equals(l.getId())).findFirst()).isEmpty()) continue;
            String content = ((ZoePersistence.Page)page.getBody()).getContent();
            MarkdownVisitor.MarkdownAst ast = new MarkdownVisitor().visit(content);
            if (ast.getHeadings().stream().filter(entity -> entity.getLevel() == 1).findFirst().isEmpty()) {
                throw new MarkdownException("markdown must have atleast one h1(line starting with one # my super menu)");
            }
            result.add(ImmutableMarkdown.builder().path(path).locale(((ZoePersistence.Locale)locale.get().getBody()).getValue()).value(content).addAllHeadings(ast.getHeadings()).build());
        }
        return result;
    }

    private String visitArticlePath(ZoePersistence.Entity<ZoePersistence.Article> src) {
        String parentId;
        StringBuilder path = new StringBuilder();
        ZoePersistence.Entity<ZoePersistence.Article> article = src;
        do {
            if (path.length() > 0) {
                path.append("/");
            }
            path.append(((ZoePersistence.Article)article.getBody()).getName());
        } while ((article = (parentId = ((ZoePersistence.Article)article.getBody()).getParentId()) == null ? null : (ZoePersistence.Entity)this.entity.getArticles().get(parentId)) != null);
        return path.toString();
    }

    private List<ZoePersistence.Entity<ZoePersistence.Locale>> visitLocales(ZoePersistence.SiteState site) {
        this.locales.addAll(site.getLocales().values().stream().filter(l -> ((ZoePersistence.Locale)l.getBody()).getEnabled()).collect(Collectors.toList()));
        return this.locales;
    }
}

