/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.staticontent.api;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.staticontent.api.StaticContentClient;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StaticContentClient.LinkData", generator="Immutables")
@Immutable
public final class ImmutableLinkData
implements StaticContentClient.LinkData {
    private final String id;
    private final String path;
    private final String name;
    private final String type;
    private final String value;
    private final String locale;
    private final Boolean workflow;

    private ImmutableLinkData(String id, String path, String name, String type, String value, String locale, Boolean workflow) {
        this.id = id;
        this.path = path;
        this.name = name;
        this.type = type;
        this.value = value;
        this.locale = locale;
        this.workflow = workflow;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getLocale() {
        return this.locale;
    }

    @Override
    public Boolean getWorkflow() {
        return this.workflow;
    }

    public final ImmutableLinkData withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableLinkData(newValue, this.path, this.name, this.type, this.value, this.locale, this.workflow);
    }

    public final ImmutableLinkData withPath(String value) {
        String newValue = Objects.requireNonNull(value, "path");
        if (this.path.equals(newValue)) {
            return this;
        }
        return new ImmutableLinkData(this.id, newValue, this.name, this.type, this.value, this.locale, this.workflow);
    }

    public final ImmutableLinkData withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableLinkData(this.id, this.path, newValue, this.type, this.value, this.locale, this.workflow);
    }

    public final ImmutableLinkData withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableLinkData(this.id, this.path, this.name, newValue, this.value, this.locale, this.workflow);
    }

    public final ImmutableLinkData withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableLinkData(this.id, this.path, this.name, this.type, newValue, this.locale, this.workflow);
    }

    public final ImmutableLinkData withLocale(String value) {
        String newValue = Objects.requireNonNull(value, "locale");
        if (this.locale.equals(newValue)) {
            return this;
        }
        return new ImmutableLinkData(this.id, this.path, this.name, this.type, this.value, newValue, this.workflow);
    }

    public final ImmutableLinkData withWorkflow(Boolean value) {
        Boolean newValue = Objects.requireNonNull(value, "workflow");
        if (this.workflow.equals(newValue)) {
            return this;
        }
        return new ImmutableLinkData(this.id, this.path, this.name, this.type, this.value, this.locale, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLinkData && this.equalTo((ImmutableLinkData)another);
    }

    private boolean equalTo(ImmutableLinkData another) {
        return this.id.equals(another.id) && this.path.equals(another.path) && this.name.equals(another.name) && this.type.equals(another.type) && this.value.equals(another.value) && this.locale.equals(another.locale) && this.workflow.equals(another.workflow);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.locale.hashCode();
        h += (h << 5) + this.workflow.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LinkData").omitNullValues().add("id", (Object)this.id).add("path", (Object)this.path).add("name", (Object)this.name).add("type", (Object)this.type).add("value", (Object)this.value).add("locale", (Object)this.locale).add("workflow", (Object)this.workflow).toString();
    }

    public static ImmutableLinkData copyOf(StaticContentClient.LinkData instance) {
        if (instance instanceof ImmutableLinkData) {
            return (ImmutableLinkData)instance;
        }
        return ImmutableLinkData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StaticContentClient.LinkData", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_PATH = 2L;
        private static final long INIT_BIT_NAME = 4L;
        private static final long INIT_BIT_TYPE = 8L;
        private static final long INIT_BIT_VALUE = 16L;
        private static final long INIT_BIT_LOCALE = 32L;
        private static final long INIT_BIT_WORKFLOW = 64L;
        private long initBits = 127L;
        @Nullable
        private String id;
        @Nullable
        private String path;
        @Nullable
        private String name;
        @Nullable
        private String type;
        @Nullable
        private String value;
        @Nullable
        private String locale;
        @Nullable
        private Boolean workflow;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StaticContentClient.LinkData instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.path(instance.getPath());
            this.name(instance.getName());
            this.type(instance.getType());
            this.value(instance.getValue());
            this.locale(instance.getLocale());
            this.workflow(instance.getWorkflow());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder path(String path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder locale(String locale) {
            this.locale = Objects.requireNonNull(locale, "locale");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder workflow(Boolean workflow) {
            this.workflow = Objects.requireNonNull(workflow, "workflow");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public ImmutableLinkData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLinkData(this.id, this.path, this.name, this.type, this.value, this.locale, this.workflow);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("path");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("locale");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("workflow");
            }
            return "Cannot build LinkData, some of required attributes are not set " + attributes;
        }
    }
}

