/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.staticontent.api;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.staticontent.api.StaticContentClient;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StaticContentClient.TopicNameData", generator="Immutables")
@Immutable
public final class ImmutableTopicNameData
implements StaticContentClient.TopicNameData {
    private final String path;
    private final ImmutableMap<String, String> locale;

    private ImmutableTopicNameData(String path, ImmutableMap<String, String> locale) {
        this.path = path;
        this.locale = locale;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public ImmutableMap<String, String> getLocale() {
        return this.locale;
    }

    public final ImmutableTopicNameData withPath(String value) {
        String newValue = Objects.requireNonNull(value, "path");
        if (this.path.equals(newValue)) {
            return this;
        }
        return new ImmutableTopicNameData(newValue, this.locale);
    }

    public final ImmutableTopicNameData withLocale(Map<String, ? extends String> entries) {
        if (this.locale == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableTopicNameData(this.path, (ImmutableMap<String, String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTopicNameData && this.equalTo((ImmutableTopicNameData)another);
    }

    private boolean equalTo(ImmutableTopicNameData another) {
        return this.path.equals(another.path) && this.locale.equals(another.locale);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + this.locale.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TopicNameData").omitNullValues().add("path", (Object)this.path).add("locale", this.locale).toString();
    }

    public static ImmutableTopicNameData copyOf(StaticContentClient.TopicNameData instance) {
        if (instance instanceof ImmutableTopicNameData) {
            return (ImmutableTopicNameData)instance;
        }
        return ImmutableTopicNameData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StaticContentClient.TopicNameData", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PATH = 1L;
        private long initBits = 1L;
        @Nullable
        private String path;
        private ImmutableMap.Builder<String, String> locale = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StaticContentClient.TopicNameData instance) {
            Objects.requireNonNull(instance, "instance");
            this.path(instance.getPath());
            this.putAllLocale(instance.getLocale());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder path(String path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putLocale(String key, String value) {
            this.locale.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putLocale(Map.Entry<String, ? extends String> entry) {
            this.locale.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder locale(Map<String, ? extends String> entries) {
            this.locale = ImmutableMap.builder();
            return this.putAllLocale(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllLocale(Map<String, ? extends String> entries) {
            this.locale.putAll(entries);
            return this;
        }

        public ImmutableTopicNameData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTopicNameData(this.path, (ImmutableMap<String, String>)this.locale.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("path");
            }
            return "Cannot build TopicNameData, some of required attributes are not set " + attributes;
        }
    }
}

