package io.thestencil.staticontent.spi.visitor;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.thestencil.staticontent.api.SiteContent;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SiteVisitor.Sites}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSites.builder()}.
 */
@Generated(from = "SiteVisitor.Sites", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSites implements SiteVisitor.Sites {
  private final ImmutableList<SiteVisitor.Message> message;
  private final ImmutableList<SiteContent.Site> sites;

  private ImmutableSites(
      ImmutableList<SiteVisitor.Message> message,
      ImmutableList<SiteContent.Site> sites) {
    this.message = message;
    this.sites = sites;
  }

  /**
   * @return The value of the {@code message} attribute
   */
  @Override
  public ImmutableList<SiteVisitor.Message> getMessage() {
    return message;
  }

  /**
   * @return The value of the {@code sites} attribute
   */
  @Override
  public ImmutableList<SiteContent.Site> getSites() {
    return sites;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SiteVisitor.Sites#getMessage() message}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSites withMessage(SiteVisitor.Message... elements) {
    ImmutableList<SiteVisitor.Message> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSites(newValue, this.sites);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SiteVisitor.Sites#getMessage() message}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of message elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSites withMessage(Iterable<? extends SiteVisitor.Message> elements) {
    if (this.message == elements) return this;
    ImmutableList<SiteVisitor.Message> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSites(newValue, this.sites);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SiteVisitor.Sites#getSites() sites}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSites withSites(SiteContent.Site... elements) {
    ImmutableList<SiteContent.Site> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSites(this.message, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SiteVisitor.Sites#getSites() sites}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of sites elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSites withSites(Iterable<? extends SiteContent.Site> elements) {
    if (this.sites == elements) return this;
    ImmutableList<SiteContent.Site> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSites(this.message, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSites} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSites
        && equalTo((ImmutableSites) another);
  }

  private boolean equalTo(ImmutableSites another) {
    return message.equals(another.message)
        && sites.equals(another.sites);
  }

  /**
   * Computes a hash code from attributes: {@code message}, {@code sites}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + message.hashCode();
    h += (h << 5) + sites.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Sites} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Sites")
        .omitNullValues()
        .add("message", message)
        .add("sites", sites)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link SiteVisitor.Sites} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Sites instance
   */
  public static ImmutableSites copyOf(SiteVisitor.Sites instance) {
    if (instance instanceof ImmutableSites) {
      return (ImmutableSites) instance;
    }
    return ImmutableSites.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSites ImmutableSites}.
   * <pre>
   * ImmutableSites.builder()
   *    .addMessage|addAllMessage(io.thestencil.staticontent.spi.visitor.SiteVisitor.Message) // {@link SiteVisitor.Sites#getMessage() message} elements
   *    .addSites|addAllSites(io.thestencil.staticontent.api.SiteContent.Site) // {@link SiteVisitor.Sites#getSites() sites} elements
   *    .build();
   * </pre>
   * @return A new ImmutableSites builder
   */
  public static ImmutableSites.Builder builder() {
    return new ImmutableSites.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSites ImmutableSites}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SiteVisitor.Sites", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<SiteVisitor.Message> message = ImmutableList.builder();
    private ImmutableList.Builder<SiteContent.Site> sites = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Sites} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SiteVisitor.Sites instance) {
      Objects.requireNonNull(instance, "instance");
      addAllMessage(instance.getMessage());
      addAllSites(instance.getSites());
      return this;
    }

    /**
     * Adds one element to {@link SiteVisitor.Sites#getMessage() message} list.
     * @param element A message element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMessage(SiteVisitor.Message element) {
      this.message.add(element);
      return this;
    }

    /**
     * Adds elements to {@link SiteVisitor.Sites#getMessage() message} list.
     * @param elements An array of message elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMessage(SiteVisitor.Message... elements) {
      this.message.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SiteVisitor.Sites#getMessage() message} list.
     * @param elements An iterable of message elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder message(Iterable<? extends SiteVisitor.Message> elements) {
      this.message = ImmutableList.builder();
      return addAllMessage(elements);
    }

    /**
     * Adds elements to {@link SiteVisitor.Sites#getMessage() message} list.
     * @param elements An iterable of message elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllMessage(Iterable<? extends SiteVisitor.Message> elements) {
      this.message.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link SiteVisitor.Sites#getSites() sites} list.
     * @param element A sites element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSites(SiteContent.Site element) {
      this.sites.add(element);
      return this;
    }

    /**
     * Adds elements to {@link SiteVisitor.Sites#getSites() sites} list.
     * @param elements An array of sites elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSites(SiteContent.Site... elements) {
      this.sites.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SiteVisitor.Sites#getSites() sites} list.
     * @param elements An iterable of sites elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sites(Iterable<? extends SiteContent.Site> elements) {
      this.sites = ImmutableList.builder();
      return addAllSites(elements);
    }

    /**
     * Adds elements to {@link SiteVisitor.Sites#getSites() sites} list.
     * @param elements An iterable of sites elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllSites(Iterable<? extends SiteContent.Site> elements) {
      this.sites.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableSites ImmutableSites}.
     * @return An immutable instance of Sites
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSites build() {
      return new ImmutableSites(message.build(), sites.build());
    }
  }
}
