/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.persistence.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.persistence.api.UpdateBuilder;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="UpdateBuilder.LocaleMutator", generator="Immutables")
@Immutable
public final class ImmutableLocaleMutator
implements UpdateBuilder.LocaleMutator {
    private final String localeId;
    private final String value;
    private final Boolean enabled;

    private ImmutableLocaleMutator(String localeId, String value, Boolean enabled) {
        this.localeId = localeId;
        this.value = value;
        this.enabled = enabled;
    }

    @Override
    @JsonProperty(value="localeId")
    public String getLocaleId() {
        return this.localeId;
    }

    @Override
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    @Override
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public final ImmutableLocaleMutator withLocaleId(String value) {
        String newValue = Objects.requireNonNull(value, "localeId");
        if (this.localeId.equals(newValue)) {
            return this;
        }
        return new ImmutableLocaleMutator(newValue, this.value, this.enabled);
    }

    public final ImmutableLocaleMutator withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableLocaleMutator(this.localeId, newValue, this.enabled);
    }

    public final ImmutableLocaleMutator withEnabled(Boolean value) {
        Boolean newValue = Objects.requireNonNull(value, "enabled");
        if (this.enabled.equals(newValue)) {
            return this;
        }
        return new ImmutableLocaleMutator(this.localeId, this.value, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLocaleMutator && this.equalTo((ImmutableLocaleMutator)another);
    }

    private boolean equalTo(ImmutableLocaleMutator another) {
        return this.localeId.equals(another.localeId) && this.value.equals(another.value) && this.enabled.equals(another.enabled);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.localeId.hashCode();
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.enabled.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LocaleMutator").omitNullValues().add("localeId", (Object)this.localeId).add("value", (Object)this.value).add("enabled", (Object)this.enabled).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLocaleMutator fromJson(Json json) {
        Builder builder = ImmutableLocaleMutator.builder();
        if (json.localeId != null) {
            builder.localeId(json.localeId);
        }
        if (json.value != null) {
            builder.value(json.value);
        }
        if (json.enabled != null) {
            builder.enabled(json.enabled);
        }
        return builder.build();
    }

    public static ImmutableLocaleMutator copyOf(UpdateBuilder.LocaleMutator instance) {
        if (instance instanceof ImmutableLocaleMutator) {
            return (ImmutableLocaleMutator)instance;
        }
        return ImmutableLocaleMutator.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="UpdateBuilder.LocaleMutator", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LOCALE_ID = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private static final long INIT_BIT_ENABLED = 4L;
        private long initBits = 7L;
        @Nullable
        private String localeId;
        @Nullable
        private String value;
        @Nullable
        private Boolean enabled;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(UpdateBuilder.LocaleMutator instance) {
            Objects.requireNonNull(instance, "instance");
            this.localeId(instance.getLocaleId());
            this.value(instance.getValue());
            this.enabled(instance.getEnabled());
            return this;
        }

        @JsonProperty(value="localeId")
        @CanIgnoreReturnValue
        public final Builder localeId(String localeId) {
            this.localeId = Objects.requireNonNull(localeId, "localeId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="value")
        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="enabled")
        @CanIgnoreReturnValue
        public final Builder enabled(Boolean enabled) {
            this.enabled = Objects.requireNonNull(enabled, "enabled");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableLocaleMutator build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLocaleMutator(this.localeId, this.value, this.enabled);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("localeId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("enabled");
            }
            return "Cannot build LocaleMutator, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="UpdateBuilder.LocaleMutator", generator="Immutables")
    static final class Json
    implements UpdateBuilder.LocaleMutator {
        @Nullable
        String localeId;
        @Nullable
        String value;
        @Nullable
        Boolean enabled;

        Json() {
        }

        @JsonProperty(value="localeId")
        public void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @JsonProperty(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @JsonProperty(value="enabled")
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public String getLocaleId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getEnabled() {
            throw new UnsupportedOperationException();
        }
    }
}

