/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.persistence.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.persistence.api.DeleteBuilder;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DeleteBuilder.WorkflowArticlePage", generator="Immutables")
@Immutable
public final class ImmutableWorkflowArticlePage
implements DeleteBuilder.WorkflowArticlePage {
    private final String workflowId;
    private final String articleId;

    private ImmutableWorkflowArticlePage(String workflowId, String articleId) {
        this.workflowId = workflowId;
        this.articleId = articleId;
    }

    @Override
    @JsonProperty(value="workflowId")
    public String getWorkflowId() {
        return this.workflowId;
    }

    @Override
    @JsonProperty(value="articleId")
    public String getArticleId() {
        return this.articleId;
    }

    public final ImmutableWorkflowArticlePage withWorkflowId(String value) {
        String newValue = Objects.requireNonNull(value, "workflowId");
        if (this.workflowId.equals(newValue)) {
            return this;
        }
        return new ImmutableWorkflowArticlePage(newValue, this.articleId);
    }

    public final ImmutableWorkflowArticlePage withArticleId(String value) {
        String newValue = Objects.requireNonNull(value, "articleId");
        if (this.articleId.equals(newValue)) {
            return this;
        }
        return new ImmutableWorkflowArticlePage(this.workflowId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWorkflowArticlePage && this.equalTo((ImmutableWorkflowArticlePage)another);
    }

    private boolean equalTo(ImmutableWorkflowArticlePage another) {
        return this.workflowId.equals(another.workflowId) && this.articleId.equals(another.articleId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.workflowId.hashCode();
        h += (h << 5) + this.articleId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WorkflowArticlePage").omitNullValues().add("workflowId", (Object)this.workflowId).add("articleId", (Object)this.articleId).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableWorkflowArticlePage fromJson(Json json) {
        Builder builder = ImmutableWorkflowArticlePage.builder();
        if (json.workflowId != null) {
            builder.workflowId(json.workflowId);
        }
        if (json.articleId != null) {
            builder.articleId(json.articleId);
        }
        return builder.build();
    }

    public static ImmutableWorkflowArticlePage copyOf(DeleteBuilder.WorkflowArticlePage instance) {
        if (instance instanceof ImmutableWorkflowArticlePage) {
            return (ImmutableWorkflowArticlePage)instance;
        }
        return ImmutableWorkflowArticlePage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DeleteBuilder.WorkflowArticlePage", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_WORKFLOW_ID = 1L;
        private static final long INIT_BIT_ARTICLE_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private String workflowId;
        @Nullable
        private String articleId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DeleteBuilder.WorkflowArticlePage instance) {
            Objects.requireNonNull(instance, "instance");
            this.workflowId(instance.getWorkflowId());
            this.articleId(instance.getArticleId());
            return this;
        }

        @JsonProperty(value="workflowId")
        @CanIgnoreReturnValue
        public final Builder workflowId(String workflowId) {
            this.workflowId = Objects.requireNonNull(workflowId, "workflowId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="articleId")
        @CanIgnoreReturnValue
        public final Builder articleId(String articleId) {
            this.articleId = Objects.requireNonNull(articleId, "articleId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableWorkflowArticlePage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWorkflowArticlePage(this.workflowId, this.articleId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("workflowId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("articleId");
            }
            return "Cannot build WorkflowArticlePage, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DeleteBuilder.WorkflowArticlePage", generator="Immutables")
    static final class Json
    implements DeleteBuilder.WorkflowArticlePage {
        @Nullable
        String workflowId;
        @Nullable
        String articleId;

        Json() {
        }

        @JsonProperty(value="workflowId")
        public void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @JsonProperty(value="articleId")
        public void setArticleId(String articleId) {
            this.articleId = articleId;
        }

        @Override
        public String getWorkflowId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getArticleId() {
            throw new UnsupportedOperationException();
        }
    }
}

