/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.persistence.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.persistence.api.CreateBuilder;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CreateBuilder.CreateArticle", generator="Immutables")
@Immutable
public final class ImmutableCreateArticle
implements CreateBuilder.CreateArticle {
    @Nullable
    private final String parentId;
    private final String name;
    @Nullable
    private final Integer order;

    private ImmutableCreateArticle(@Nullable String parentId, String name, @Nullable Integer order) {
        this.parentId = parentId;
        this.name = name;
        this.order = order;
    }

    @Override
    @JsonProperty(value="parentId")
    @Nullable
    public String getParentId() {
        return this.parentId;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="order")
    @Nullable
    public Integer getOrder() {
        return this.order;
    }

    public final ImmutableCreateArticle withParentId(@Nullable String value) {
        if (Objects.equals(this.parentId, value)) {
            return this;
        }
        return new ImmutableCreateArticle(value, this.name, this.order);
    }

    public final ImmutableCreateArticle withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableCreateArticle(this.parentId, newValue, this.order);
    }

    public final ImmutableCreateArticle withOrder(@Nullable Integer value) {
        if (Objects.equals(this.order, value)) {
            return this;
        }
        return new ImmutableCreateArticle(this.parentId, this.name, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCreateArticle && this.equalTo((ImmutableCreateArticle)another);
    }

    private boolean equalTo(ImmutableCreateArticle another) {
        return Objects.equals(this.parentId, another.parentId) && this.name.equals(another.name) && Objects.equals(this.order, another.order);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.parentId);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.order);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CreateArticle").omitNullValues().add("parentId", (Object)this.parentId).add("name", (Object)this.name).add("order", (Object)this.order).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCreateArticle fromJson(Json json) {
        Builder builder = ImmutableCreateArticle.builder();
        if (json.parentId != null) {
            builder.parentId(json.parentId);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.order != null) {
            builder.order(json.order);
        }
        return builder.build();
    }

    public static ImmutableCreateArticle copyOf(CreateBuilder.CreateArticle instance) {
        if (instance instanceof ImmutableCreateArticle) {
            return (ImmutableCreateArticle)instance;
        }
        return ImmutableCreateArticle.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CreateBuilder.CreateArticle", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String parentId;
        @Nullable
        private String name;
        @Nullable
        private Integer order;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CreateBuilder.CreateArticle instance) {
            Objects.requireNonNull(instance, "instance");
            String parentIdValue = instance.getParentId();
            if (parentIdValue != null) {
                this.parentId(parentIdValue);
            }
            this.name(instance.getName());
            Integer orderValue = instance.getOrder();
            if (orderValue != null) {
                this.order(orderValue);
            }
            return this;
        }

        @JsonProperty(value="parentId")
        @CanIgnoreReturnValue
        public final Builder parentId(@Nullable String parentId) {
            this.parentId = parentId;
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="order")
        @CanIgnoreReturnValue
        public final Builder order(@Nullable Integer order) {
            this.order = order;
            return this;
        }

        public ImmutableCreateArticle build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCreateArticle(this.parentId, this.name, this.order);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build CreateArticle, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CreateBuilder.CreateArticle", generator="Immutables")
    static final class Json
    implements CreateBuilder.CreateArticle {
        @Nullable
        String parentId;
        @Nullable
        String name;
        @Nullable
        Integer order;

        Json() {
        }

        @JsonProperty(value="parentId")
        public void setParentId(@Nullable String parentId) {
            this.parentId = parentId;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="order")
        public void setOrder(@Nullable Integer order) {
            this.order = order;
        }

        @Override
        public String getParentId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getOrder() {
            throw new UnsupportedOperationException();
        }
    }
}

