package io.thestencil.persistence.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DeleteBuilder.LinkArticlePage}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLinkArticlePage.builder()}.
 */
@Generated(from = "DeleteBuilder.LinkArticlePage", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableLinkArticlePage
    implements DeleteBuilder.LinkArticlePage {
  private final String linkId;
  private final String articleId;

  private ImmutableLinkArticlePage(String linkId, String articleId) {
    this.linkId = linkId;
    this.articleId = articleId;
  }

  /**
   * @return The value of the {@code linkId} attribute
   */
  @JsonProperty("linkId")
  @Override
  public String getLinkId() {
    return linkId;
  }

  /**
   * @return The value of the {@code articleId} attribute
   */
  @JsonProperty("articleId")
  @Override
  public String getArticleId() {
    return articleId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DeleteBuilder.LinkArticlePage#getLinkId() linkId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for linkId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLinkArticlePage withLinkId(String value) {
    String newValue = Objects.requireNonNull(value, "linkId");
    if (this.linkId.equals(newValue)) return this;
    return new ImmutableLinkArticlePage(newValue, this.articleId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DeleteBuilder.LinkArticlePage#getArticleId() articleId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for articleId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLinkArticlePage withArticleId(String value) {
    String newValue = Objects.requireNonNull(value, "articleId");
    if (this.articleId.equals(newValue)) return this;
    return new ImmutableLinkArticlePage(this.linkId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLinkArticlePage} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLinkArticlePage
        && equalTo((ImmutableLinkArticlePage) another);
  }

  private boolean equalTo(ImmutableLinkArticlePage another) {
    return linkId.equals(another.linkId)
        && articleId.equals(another.articleId);
  }

  /**
   * Computes a hash code from attributes: {@code linkId}, {@code articleId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + linkId.hashCode();
    h += (h << 5) + articleId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code LinkArticlePage} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("LinkArticlePage")
        .omitNullValues()
        .add("linkId", linkId)
        .add("articleId", articleId)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DeleteBuilder.LinkArticlePage", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DeleteBuilder.LinkArticlePage {
    @Nullable String linkId;
    @Nullable String articleId;
    @JsonProperty("linkId")
    public void setLinkId(String linkId) {
      this.linkId = linkId;
    }
    @JsonProperty("articleId")
    public void setArticleId(String articleId) {
      this.articleId = articleId;
    }
    @Override
    public String getLinkId() { throw new UnsupportedOperationException(); }
    @Override
    public String getArticleId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableLinkArticlePage fromJson(Json json) {
    ImmutableLinkArticlePage.Builder builder = ImmutableLinkArticlePage.builder();
    if (json.linkId != null) {
      builder.linkId(json.linkId);
    }
    if (json.articleId != null) {
      builder.articleId(json.articleId);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DeleteBuilder.LinkArticlePage} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable LinkArticlePage instance
   */
  public static ImmutableLinkArticlePage copyOf(DeleteBuilder.LinkArticlePage instance) {
    if (instance instanceof ImmutableLinkArticlePage) {
      return (ImmutableLinkArticlePage) instance;
    }
    return ImmutableLinkArticlePage.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLinkArticlePage ImmutableLinkArticlePage}.
   * <pre>
   * ImmutableLinkArticlePage.builder()
   *    .linkId(String) // required {@link DeleteBuilder.LinkArticlePage#getLinkId() linkId}
   *    .articleId(String) // required {@link DeleteBuilder.LinkArticlePage#getArticleId() articleId}
   *    .build();
   * </pre>
   * @return A new ImmutableLinkArticlePage builder
   */
  public static ImmutableLinkArticlePage.Builder builder() {
    return new ImmutableLinkArticlePage.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLinkArticlePage ImmutableLinkArticlePage}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DeleteBuilder.LinkArticlePage", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_LINK_ID = 0x1L;
    private static final long INIT_BIT_ARTICLE_ID = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String linkId;
    private @Nullable String articleId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code LinkArticlePage} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DeleteBuilder.LinkArticlePage instance) {
      Objects.requireNonNull(instance, "instance");
      linkId(instance.getLinkId());
      articleId(instance.getArticleId());
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteBuilder.LinkArticlePage#getLinkId() linkId} attribute.
     * @param linkId The value for linkId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("linkId")
    public final Builder linkId(String linkId) {
      this.linkId = Objects.requireNonNull(linkId, "linkId");
      initBits &= ~INIT_BIT_LINK_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteBuilder.LinkArticlePage#getArticleId() articleId} attribute.
     * @param articleId The value for articleId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("articleId")
    public final Builder articleId(String articleId) {
      this.articleId = Objects.requireNonNull(articleId, "articleId");
      initBits &= ~INIT_BIT_ARTICLE_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableLinkArticlePage ImmutableLinkArticlePage}.
     * @return An immutable instance of LinkArticlePage
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLinkArticlePage build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableLinkArticlePage(linkId, articleId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_LINK_ID) != 0) attributes.add("linkId");
      if ((initBits & INIT_BIT_ARTICLE_ID) != 0) attributes.add("articleId");
      return "Cannot build LinkArticlePage, some of required attributes are not set " + attributes;
    }
  }
}
