/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.persistence.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.persistence.api.ZoePersistence;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ZoePersistence.Entity", generator="Immutables")
@Immutable
public final class ImmutableEntity<T extends ZoePersistence.EntityBody>
implements ZoePersistence.Entity<T> {
    private final String id;
    private final ZoePersistence.EntityType type;
    private final T body;

    private ImmutableEntity(String id, ZoePersistence.EntityType type, T body) {
        this.id = id;
        this.type = type;
        this.body = body;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="type")
    public ZoePersistence.EntityType getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="body")
    public T getBody() {
        return this.body;
    }

    public final ImmutableEntity<T> withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableEntity<T>(newValue, this.type, this.body);
    }

    public final ImmutableEntity<T> withType(ZoePersistence.EntityType value) {
        if (this.type == value) {
            return this;
        }
        ZoePersistence.EntityType newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableEntity<T>(this.id, newValue, this.body);
    }

    public final ImmutableEntity<T> withBody(T value) {
        if (this.body == value) {
            return this;
        }
        ZoePersistence.EntityBody newValue = (ZoePersistence.EntityBody)Objects.requireNonNull(value, "body");
        return new ImmutableEntity<ZoePersistence.EntityBody>(this.id, this.type, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEntity && this.equalTo((ImmutableEntity)another);
    }

    private boolean equalTo(ImmutableEntity<?> another) {
        return this.id.equals(another.id) && this.type.equals((Object)another.type) && this.body.equals(another.body);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.body.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Entity").omitNullValues().add("id", (Object)this.id).add("type", (Object)this.type).add("body", this.body).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static <T extends ZoePersistence.EntityBody> ImmutableEntity<T> fromJson(Json<T> json) {
        Builder builder = ImmutableEntity.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.body != null) {
            builder.body(json.body);
        }
        return builder.build();
    }

    public static <T extends ZoePersistence.EntityBody> ImmutableEntity<T> copyOf(ZoePersistence.Entity<T> instance) {
        if (instance instanceof ImmutableEntity) {
            return (ImmutableEntity)instance;
        }
        return ImmutableEntity.builder().from(instance).build();
    }

    public static <T extends ZoePersistence.EntityBody> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="ZoePersistence.Entity", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T extends ZoePersistence.EntityBody> {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private static final long INIT_BIT_BODY = 4L;
        private long initBits = 7L;
        @Nullable
        private String id;
        @Nullable
        private ZoePersistence.EntityType type;
        @Nullable
        private T body;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(ZoePersistence.Entity<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.type(instance.getType());
            this.body(instance.getBody());
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder<T> id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder<T> type(ZoePersistence.EntityType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="body")
        @CanIgnoreReturnValue
        public final Builder<T> body(T body) {
            this.body = (ZoePersistence.EntityBody)Objects.requireNonNull(body, "body");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableEntity<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEntity<T>(this.id, this.type, this.body);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("body");
            }
            return "Cannot build Entity, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ZoePersistence.Entity", generator="Immutables")
    static final class Json<T extends ZoePersistence.EntityBody>
    implements ZoePersistence.Entity<T> {
        @Nullable
        String id;
        @Nullable
        ZoePersistence.EntityType type;
        @Nullable
        T body;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="type")
        public void setType(ZoePersistence.EntityType type) {
            this.type = type;
        }

        @JsonProperty(value="body")
        public void setBody(T body) {
            this.body = body;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ZoePersistence.EntityType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T getBody() {
            throw new UnsupportedOperationException();
        }
    }
}

