/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.persistence.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.persistence.api.ZoePersistence;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ZoePersistence.Release", generator="Immutables")
@Immutable
public final class ImmutableRelease
implements ZoePersistence.Release {
    private final String parentCommit;
    private final String name;
    private final String note;

    private ImmutableRelease(String parentCommit, String name, String note) {
        this.parentCommit = parentCommit;
        this.name = name;
        this.note = note;
    }

    @Override
    @JsonProperty(value="parentCommit")
    public String getParentCommit() {
        return this.parentCommit;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="note")
    public String getNote() {
        return this.note;
    }

    public final ImmutableRelease withParentCommit(String value) {
        String newValue = Objects.requireNonNull(value, "parentCommit");
        if (this.parentCommit.equals(newValue)) {
            return this;
        }
        return new ImmutableRelease(newValue, this.name, this.note);
    }

    public final ImmutableRelease withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableRelease(this.parentCommit, newValue, this.note);
    }

    public final ImmutableRelease withNote(String value) {
        String newValue = Objects.requireNonNull(value, "note");
        if (this.note.equals(newValue)) {
            return this;
        }
        return new ImmutableRelease(this.parentCommit, this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRelease && this.equalTo((ImmutableRelease)another);
    }

    private boolean equalTo(ImmutableRelease another) {
        return this.parentCommit.equals(another.parentCommit) && this.name.equals(another.name) && this.note.equals(another.note);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.parentCommit.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.note.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Release").omitNullValues().add("parentCommit", (Object)this.parentCommit).add("name", (Object)this.name).add("note", (Object)this.note).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRelease fromJson(Json json) {
        Builder builder = ImmutableRelease.builder();
        if (json.parentCommit != null) {
            builder.parentCommit(json.parentCommit);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.note != null) {
            builder.note(json.note);
        }
        return builder.build();
    }

    public static ImmutableRelease copyOf(ZoePersistence.Release instance) {
        if (instance instanceof ImmutableRelease) {
            return (ImmutableRelease)instance;
        }
        return ImmutableRelease.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ZoePersistence.Release", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PARENT_COMMIT = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_NOTE = 4L;
        private long initBits = 7L;
        @Nullable
        private String parentCommit;
        @Nullable
        private String name;
        @Nullable
        private String note;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ZoePersistence.Release instance) {
            Objects.requireNonNull(instance, "instance");
            this.parentCommit(instance.getParentCommit());
            this.name(instance.getName());
            this.note(instance.getNote());
            return this;
        }

        @JsonProperty(value="parentCommit")
        @CanIgnoreReturnValue
        public final Builder parentCommit(String parentCommit) {
            this.parentCommit = Objects.requireNonNull(parentCommit, "parentCommit");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="note")
        @CanIgnoreReturnValue
        public final Builder note(String note) {
            this.note = Objects.requireNonNull(note, "note");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableRelease build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRelease(this.parentCommit, this.name, this.note);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("parentCommit");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("note");
            }
            return "Cannot build Release, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ZoePersistence.Release", generator="Immutables")
    static final class Json
    implements ZoePersistence.Release {
        @Nullable
        String parentCommit;
        @Nullable
        String name;
        @Nullable
        String note;

        Json() {
        }

        @JsonProperty(value="parentCommit")
        public void setParentCommit(String parentCommit) {
            this.parentCommit = parentCommit;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="note")
        public void setNote(String note) {
            this.note = note;
        }

        @Override
        public String getParentCommit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getNote() {
            throw new UnsupportedOperationException();
        }
    }
}

