/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.persistence.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.persistence.api.ZoePersistence;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ZoePersistence.Locale", generator="Immutables")
@Immutable
public final class ImmutableLocale
implements ZoePersistence.Locale {
    private final String value;
    private final Boolean enabled;

    private ImmutableLocale(String value, Boolean enabled) {
        this.value = value;
        this.enabled = enabled;
    }

    @Override
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    @Override
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public final ImmutableLocale withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableLocale(newValue, this.enabled);
    }

    public final ImmutableLocale withEnabled(Boolean value) {
        Boolean newValue = Objects.requireNonNull(value, "enabled");
        if (this.enabled.equals(newValue)) {
            return this;
        }
        return new ImmutableLocale(this.value, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLocale && this.equalTo((ImmutableLocale)another);
    }

    private boolean equalTo(ImmutableLocale another) {
        return this.value.equals(another.value) && this.enabled.equals(another.enabled);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.enabled.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Locale").omitNullValues().add("value", (Object)this.value).add("enabled", (Object)this.enabled).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLocale fromJson(Json json) {
        Builder builder = ImmutableLocale.builder();
        if (json.value != null) {
            builder.value(json.value);
        }
        if (json.enabled != null) {
            builder.enabled(json.enabled);
        }
        return builder.build();
    }

    public static ImmutableLocale copyOf(ZoePersistence.Locale instance) {
        if (instance instanceof ImmutableLocale) {
            return (ImmutableLocale)instance;
        }
        return ImmutableLocale.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ZoePersistence.Locale", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private static final long INIT_BIT_ENABLED = 2L;
        private long initBits = 3L;
        @Nullable
        private String value;
        @Nullable
        private Boolean enabled;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ZoePersistence.Locale instance) {
            Objects.requireNonNull(instance, "instance");
            this.value(instance.getValue());
            this.enabled(instance.getEnabled());
            return this;
        }

        @JsonProperty(value="value")
        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="enabled")
        @CanIgnoreReturnValue
        public final Builder enabled(Boolean enabled) {
            this.enabled = Objects.requireNonNull(enabled, "enabled");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableLocale build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLocale(this.value, this.enabled);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("enabled");
            }
            return "Cannot build Locale, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ZoePersistence.Locale", generator="Immutables")
    static final class Json
    implements ZoePersistence.Locale {
        @Nullable
        String value;
        @Nullable
        Boolean enabled;

        Json() {
        }

        @JsonProperty(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @JsonProperty(value="enabled")
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public String getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getEnabled() {
            throw new UnsupportedOperationException();
        }
    }
}

