/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.persistence.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.persistence.api.CreateBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CreateBuilder.CreateLink", generator="Immutables")
@Immutable
public final class ImmutableCreateLink
implements CreateBuilder.CreateLink {
    private final String value;
    private final String locale;
    private final String description;
    private final String type;
    private final ImmutableList<String> articles;

    private ImmutableCreateLink(String value, String locale, String description, String type, ImmutableList<String> articles) {
        this.value = value;
        this.locale = locale;
        this.description = description;
        this.type = type;
        this.articles = articles;
    }

    @Override
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    @Override
    @JsonProperty(value="locale")
    public String getLocale() {
        return this.locale;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="articles")
    public ImmutableList<String> getArticles() {
        return this.articles;
    }

    public final ImmutableCreateLink withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableCreateLink(newValue, this.locale, this.description, this.type, this.articles);
    }

    public final ImmutableCreateLink withLocale(String value) {
        String newValue = Objects.requireNonNull(value, "locale");
        if (this.locale.equals(newValue)) {
            return this;
        }
        return new ImmutableCreateLink(this.value, newValue, this.description, this.type, this.articles);
    }

    public final ImmutableCreateLink withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableCreateLink(this.value, this.locale, newValue, this.type, this.articles);
    }

    public final ImmutableCreateLink withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableCreateLink(this.value, this.locale, this.description, newValue, this.articles);
    }

    public final ImmutableCreateLink withArticles(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCreateLink(this.value, this.locale, this.description, this.type, (ImmutableList<String>)newValue);
    }

    public final ImmutableCreateLink withArticles(Iterable<String> elements) {
        if (this.articles == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCreateLink(this.value, this.locale, this.description, this.type, (ImmutableList<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCreateLink && this.equalTo((ImmutableCreateLink)another);
    }

    private boolean equalTo(ImmutableCreateLink another) {
        return this.value.equals(another.value) && this.locale.equals(another.locale) && this.description.equals(another.description) && this.type.equals(another.type) && this.articles.equals(another.articles);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.locale.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.articles.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CreateLink").omitNullValues().add("value", (Object)this.value).add("locale", (Object)this.locale).add("description", (Object)this.description).add("type", (Object)this.type).add("articles", this.articles).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCreateLink fromJson(Json json) {
        Builder builder = ImmutableCreateLink.builder();
        if (json.value != null) {
            builder.value(json.value);
        }
        if (json.locale != null) {
            builder.locale(json.locale);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.articles != null) {
            builder.addAllArticles(json.articles);
        }
        return builder.build();
    }

    public static ImmutableCreateLink copyOf(CreateBuilder.CreateLink instance) {
        if (instance instanceof ImmutableCreateLink) {
            return (ImmutableCreateLink)instance;
        }
        return ImmutableCreateLink.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CreateBuilder.CreateLink", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private static final long INIT_BIT_LOCALE = 2L;
        private static final long INIT_BIT_DESCRIPTION = 4L;
        private static final long INIT_BIT_TYPE = 8L;
        private long initBits = 15L;
        @Nullable
        private String value;
        @Nullable
        private String locale;
        @Nullable
        private String description;
        @Nullable
        private String type;
        private ImmutableList.Builder<String> articles = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CreateBuilder.CreateLink instance) {
            Objects.requireNonNull(instance, "instance");
            this.value(instance.getValue());
            this.locale(instance.getLocale());
            this.description(instance.getDescription());
            this.type(instance.getType());
            this.addAllArticles(instance.getArticles());
            return this;
        }

        @JsonProperty(value="value")
        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="locale")
        @CanIgnoreReturnValue
        public final Builder locale(String locale) {
            this.locale = Objects.requireNonNull(locale, "locale");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArticles(String element) {
            this.articles.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArticles(String ... elements) {
            this.articles.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="articles")
        @CanIgnoreReturnValue
        public final Builder articles(Iterable<String> elements) {
            this.articles = ImmutableList.builder();
            return this.addAllArticles(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllArticles(Iterable<String> elements) {
            this.articles.addAll(elements);
            return this;
        }

        public ImmutableCreateLink build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCreateLink(this.value, this.locale, this.description, this.type, (ImmutableList<String>)this.articles.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("locale");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build CreateLink, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CreateBuilder.CreateLink", generator="Immutables")
    static final class Json
    implements CreateBuilder.CreateLink {
        @Nullable
        String value;
        @Nullable
        String locale;
        @Nullable
        String description;
        @Nullable
        String type;
        @Nullable
        List<String> articles = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @JsonProperty(value="locale")
        public void setLocale(String locale) {
            this.locale = locale;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="type")
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty(value="articles")
        public void setArticles(List<String> articles) {
            this.articles = articles;
        }

        @Override
        public String getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLocale() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getArticles() {
            throw new UnsupportedOperationException();
        }
    }
}

