package io.thestencil.persistence.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UpdateBuilder.LocaleMutator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLocaleMutator.builder()}.
 */
@Generated(from = "UpdateBuilder.LocaleMutator", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableLocaleMutator implements UpdateBuilder.LocaleMutator {
  private final String localeId;
  private final String value;
  private final Boolean enabled;

  private ImmutableLocaleMutator(String localeId, String value, Boolean enabled) {
    this.localeId = localeId;
    this.value = value;
    this.enabled = enabled;
  }

  /**
   * @return The value of the {@code localeId} attribute
   */
  @JsonProperty("localeId")
  @Override
  public String getLocaleId() {
    return localeId;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty("value")
  @Override
  public String getValue() {
    return value;
  }

  /**
   * @return The value of the {@code enabled} attribute
   */
  @JsonProperty("enabled")
  @Override
  public Boolean getEnabled() {
    return enabled;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UpdateBuilder.LocaleMutator#getLocaleId() localeId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for localeId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLocaleMutator withLocaleId(String value) {
    String newValue = Objects.requireNonNull(value, "localeId");
    if (this.localeId.equals(newValue)) return this;
    return new ImmutableLocaleMutator(newValue, this.value, this.enabled);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UpdateBuilder.LocaleMutator#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLocaleMutator withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableLocaleMutator(this.localeId, newValue, this.enabled);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UpdateBuilder.LocaleMutator#getEnabled() enabled} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for enabled
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLocaleMutator withEnabled(Boolean value) {
    Boolean newValue = Objects.requireNonNull(value, "enabled");
    if (this.enabled.equals(newValue)) return this;
    return new ImmutableLocaleMutator(this.localeId, this.value, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLocaleMutator} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLocaleMutator
        && equalTo((ImmutableLocaleMutator) another);
  }

  private boolean equalTo(ImmutableLocaleMutator another) {
    return localeId.equals(another.localeId)
        && value.equals(another.value)
        && enabled.equals(another.enabled);
  }

  /**
   * Computes a hash code from attributes: {@code localeId}, {@code value}, {@code enabled}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + localeId.hashCode();
    h += (h << 5) + value.hashCode();
    h += (h << 5) + enabled.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code LocaleMutator} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("LocaleMutator")
        .omitNullValues()
        .add("localeId", localeId)
        .add("value", value)
        .add("enabled", enabled)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "UpdateBuilder.LocaleMutator", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements UpdateBuilder.LocaleMutator {
    @Nullable String localeId;
    @Nullable String value;
    @Nullable Boolean enabled;
    @JsonProperty("localeId")
    public void setLocaleId(String localeId) {
      this.localeId = localeId;
    }
    @JsonProperty("value")
    public void setValue(String value) {
      this.value = value;
    }
    @JsonProperty("enabled")
    public void setEnabled(Boolean enabled) {
      this.enabled = enabled;
    }
    @Override
    public String getLocaleId() { throw new UnsupportedOperationException(); }
    @Override
    public String getValue() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getEnabled() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableLocaleMutator fromJson(Json json) {
    ImmutableLocaleMutator.Builder builder = ImmutableLocaleMutator.builder();
    if (json.localeId != null) {
      builder.localeId(json.localeId);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    if (json.enabled != null) {
      builder.enabled(json.enabled);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link UpdateBuilder.LocaleMutator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable LocaleMutator instance
   */
  public static ImmutableLocaleMutator copyOf(UpdateBuilder.LocaleMutator instance) {
    if (instance instanceof ImmutableLocaleMutator) {
      return (ImmutableLocaleMutator) instance;
    }
    return ImmutableLocaleMutator.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLocaleMutator ImmutableLocaleMutator}.
   * <pre>
   * ImmutableLocaleMutator.builder()
   *    .localeId(String) // required {@link UpdateBuilder.LocaleMutator#getLocaleId() localeId}
   *    .value(String) // required {@link UpdateBuilder.LocaleMutator#getValue() value}
   *    .enabled(Boolean) // required {@link UpdateBuilder.LocaleMutator#getEnabled() enabled}
   *    .build();
   * </pre>
   * @return A new ImmutableLocaleMutator builder
   */
  public static ImmutableLocaleMutator.Builder builder() {
    return new ImmutableLocaleMutator.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLocaleMutator ImmutableLocaleMutator}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UpdateBuilder.LocaleMutator", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_LOCALE_ID = 0x1L;
    private static final long INIT_BIT_VALUE = 0x2L;
    private static final long INIT_BIT_ENABLED = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String localeId;
    private @Nullable String value;
    private @Nullable Boolean enabled;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code LocaleMutator} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UpdateBuilder.LocaleMutator instance) {
      Objects.requireNonNull(instance, "instance");
      localeId(instance.getLocaleId());
      value(instance.getValue());
      enabled(instance.getEnabled());
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuilder.LocaleMutator#getLocaleId() localeId} attribute.
     * @param localeId The value for localeId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("localeId")
    public final Builder localeId(String localeId) {
      this.localeId = Objects.requireNonNull(localeId, "localeId");
      initBits &= ~INIT_BIT_LOCALE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuilder.LocaleMutator#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("value")
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuilder.LocaleMutator#getEnabled() enabled} attribute.
     * @param enabled The value for enabled 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("enabled")
    public final Builder enabled(Boolean enabled) {
      this.enabled = Objects.requireNonNull(enabled, "enabled");
      initBits &= ~INIT_BIT_ENABLED;
      return this;
    }

    /**
     * Builds a new {@link ImmutableLocaleMutator ImmutableLocaleMutator}.
     * @return An immutable instance of LocaleMutator
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLocaleMutator build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableLocaleMutator(localeId, value, enabled);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_LOCALE_ID) != 0) attributes.add("localeId");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      if ((initBits & INIT_BIT_ENABLED) != 0) attributes.add("enabled");
      return "Cannot build LocaleMutator, some of required attributes are not set " + attributes;
    }
  }
}
