/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.persistence.api;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.smallrye.mutiny.Uni;
import io.thestencil.persistence.api.CreateBuilder;
import io.thestencil.persistence.api.DeleteBuilder;
import io.thestencil.persistence.api.ImmutableArticle;
import io.thestencil.persistence.api.ImmutableEntity;
import io.thestencil.persistence.api.ImmutableLink;
import io.thestencil.persistence.api.ImmutableLocale;
import io.thestencil.persistence.api.ImmutablePage;
import io.thestencil.persistence.api.ImmutableRelease;
import io.thestencil.persistence.api.ImmutableSiteState;
import io.thestencil.persistence.api.ImmutableWorkflow;
import io.thestencil.persistence.api.UpdateBuilder;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.immutables.value.Value;

public interface ZoePersistence {
    public CreateBuilder create();

    public UpdateBuilder update();

    public DeleteBuilder delete();

    public QueryBuilder query();

    @JsonSerialize(as=ImmutableRelease.class)
    @JsonDeserialize(as=ImmutableRelease.class)
    @Value.Immutable
    public static interface Release
    extends EntityBody {
        public String getParentCommit();

        public String getName();

        public String getNote();
    }

    @JsonSerialize(as=ImmutableWorkflow.class)
    @JsonDeserialize(as=ImmutableWorkflow.class)
    @Value.Immutable
    public static interface Workflow
    extends EntityBody {
        public String getName();

        public String getLocale();

        public String getContent();

        public List<String> getArticles();
    }

    @JsonSerialize(as=ImmutablePage.class)
    @JsonDeserialize(as=ImmutablePage.class)
    @Value.Immutable
    public static interface Page
    extends EntityBody {
        public String getArticle();

        public String getLocale();

        public String getContent();
    }

    @JsonSerialize(as=ImmutableLocale.class)
    @JsonDeserialize(as=ImmutableLocale.class)
    @Value.Immutable
    public static interface Locale
    extends EntityBody {
        public String getValue();

        public Boolean getEnabled();
    }

    @JsonSerialize(as=ImmutableArticle.class)
    @JsonDeserialize(as=ImmutableArticle.class)
    @Value.Immutable
    public static interface Article
    extends EntityBody {
        @Nullable
        public String getParentId();

        public String getName();

        public Integer getOrder();
    }

    @JsonSerialize(as=ImmutableLink.class)
    @JsonDeserialize(as=ImmutableLink.class)
    @Value.Immutable
    public static interface Link
    extends EntityBody {
        public List<String> getArticles();

        public String getLocale();

        public String getContent();

        public String getContentType();

        public String getDescription();
    }

    public static interface EntityBody
    extends Serializable {
    }

    public static enum EntityType {
        LOCALE,
        LINK,
        ARTICLE,
        WORKFLOW,
        RELEASE,
        PAGE;

    }

    @JsonSerialize(as=ImmutableEntity.class)
    @JsonDeserialize(as=ImmutableEntity.class)
    @Value.Immutable
    public static interface Entity<T extends EntityBody>
    extends Serializable {
        public String getId();

        public EntityType getType();

        public T getBody();
    }

    public static enum SiteContentType {
        OK,
        ERRORS,
        NOT_CREATED,
        EMPTY,
        RELEASE;

    }

    @JsonSerialize(as=ImmutableSiteState.class)
    @JsonDeserialize(as=ImmutableSiteState.class)
    @Value.Immutable
    public static interface SiteState {
        public String getName();

        public SiteContentType getContentType();

        public Map<String, Entity<Release>> getReleases();

        public Map<String, Entity<Locale>> getLocales();

        public Map<String, Entity<Page>> getPages();

        public Map<String, Entity<Link>> getLinks();

        public Map<String, Entity<Article>> getArticles();

        public Map<String, Entity<Workflow>> getWorkflows();
    }

    public static interface QueryBuilder {
        public Uni<SiteState> head();

        public Uni<SiteState> release(String var1);
    }
}

