package io.thestencil.persistence.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UpdateBuilder.WorkflowMutator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableWorkflowMutator.builder()}.
 */
@Generated(from = "UpdateBuilder.WorkflowMutator", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableWorkflowMutator
    implements UpdateBuilder.WorkflowMutator {
  private final String workflowId;
  private final String name;
  private final String locale;
  private final String content;
  private final ImmutableList<String> articles;

  private ImmutableWorkflowMutator(
      String workflowId,
      String name,
      String locale,
      String content,
      ImmutableList<String> articles) {
    this.workflowId = workflowId;
    this.name = name;
    this.locale = locale;
    this.content = content;
    this.articles = articles;
  }

  /**
   * @return The value of the {@code workflowId} attribute
   */
  @JsonProperty("workflowId")
  @Override
  public String getWorkflowId() {
    return workflowId;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code locale} attribute
   */
  @JsonProperty("locale")
  @Override
  public String getLocale() {
    return locale;
  }

  /**
   * @return The value of the {@code content} attribute
   */
  @JsonProperty("content")
  @Override
  public String getContent() {
    return content;
  }

  /**
   * @return The value of the {@code articles} attribute
   */
  @JsonProperty("articles")
  @Override
  public ImmutableList<String> getArticles() {
    return articles;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UpdateBuilder.WorkflowMutator#getWorkflowId() workflowId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for workflowId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWorkflowMutator withWorkflowId(String value) {
    String newValue = Objects.requireNonNull(value, "workflowId");
    if (this.workflowId.equals(newValue)) return this;
    return new ImmutableWorkflowMutator(newValue, this.name, this.locale, this.content, this.articles);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UpdateBuilder.WorkflowMutator#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWorkflowMutator withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableWorkflowMutator(this.workflowId, newValue, this.locale, this.content, this.articles);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UpdateBuilder.WorkflowMutator#getLocale() locale} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for locale
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWorkflowMutator withLocale(String value) {
    String newValue = Objects.requireNonNull(value, "locale");
    if (this.locale.equals(newValue)) return this;
    return new ImmutableWorkflowMutator(this.workflowId, this.name, newValue, this.content, this.articles);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UpdateBuilder.WorkflowMutator#getContent() content} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for content
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWorkflowMutator withContent(String value) {
    String newValue = Objects.requireNonNull(value, "content");
    if (this.content.equals(newValue)) return this;
    return new ImmutableWorkflowMutator(this.workflowId, this.name, this.locale, newValue, this.articles);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UpdateBuilder.WorkflowMutator#getArticles() articles}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWorkflowMutator withArticles(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableWorkflowMutator(this.workflowId, this.name, this.locale, this.content, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UpdateBuilder.WorkflowMutator#getArticles() articles}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of articles elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWorkflowMutator withArticles(Iterable<String> elements) {
    if (this.articles == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableWorkflowMutator(this.workflowId, this.name, this.locale, this.content, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableWorkflowMutator} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableWorkflowMutator
        && equalTo((ImmutableWorkflowMutator) another);
  }

  private boolean equalTo(ImmutableWorkflowMutator another) {
    return workflowId.equals(another.workflowId)
        && name.equals(another.name)
        && locale.equals(another.locale)
        && content.equals(another.content)
        && articles.equals(another.articles);
  }

  /**
   * Computes a hash code from attributes: {@code workflowId}, {@code name}, {@code locale}, {@code content}, {@code articles}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + workflowId.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + locale.hashCode();
    h += (h << 5) + content.hashCode();
    h += (h << 5) + articles.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code WorkflowMutator} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("WorkflowMutator")
        .omitNullValues()
        .add("workflowId", workflowId)
        .add("name", name)
        .add("locale", locale)
        .add("content", content)
        .add("articles", articles)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "UpdateBuilder.WorkflowMutator", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements UpdateBuilder.WorkflowMutator {
    @Nullable String workflowId;
    @Nullable String name;
    @Nullable String locale;
    @Nullable String content;
    @Nullable List<String> articles = ImmutableList.of();
    @JsonProperty("workflowId")
    public void setWorkflowId(String workflowId) {
      this.workflowId = workflowId;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("locale")
    public void setLocale(String locale) {
      this.locale = locale;
    }
    @JsonProperty("content")
    public void setContent(String content) {
      this.content = content;
    }
    @JsonProperty("articles")
    public void setArticles(List<String> articles) {
      this.articles = articles;
    }
    @Override
    public String getWorkflowId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getLocale() { throw new UnsupportedOperationException(); }
    @Override
    public String getContent() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getArticles() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableWorkflowMutator fromJson(Json json) {
    ImmutableWorkflowMutator.Builder builder = ImmutableWorkflowMutator.builder();
    if (json.workflowId != null) {
      builder.workflowId(json.workflowId);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.locale != null) {
      builder.locale(json.locale);
    }
    if (json.content != null) {
      builder.content(json.content);
    }
    if (json.articles != null) {
      builder.addAllArticles(json.articles);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link UpdateBuilder.WorkflowMutator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WorkflowMutator instance
   */
  public static ImmutableWorkflowMutator copyOf(UpdateBuilder.WorkflowMutator instance) {
    if (instance instanceof ImmutableWorkflowMutator) {
      return (ImmutableWorkflowMutator) instance;
    }
    return ImmutableWorkflowMutator.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableWorkflowMutator ImmutableWorkflowMutator}.
   * <pre>
   * ImmutableWorkflowMutator.builder()
   *    .workflowId(String) // required {@link UpdateBuilder.WorkflowMutator#getWorkflowId() workflowId}
   *    .name(String) // required {@link UpdateBuilder.WorkflowMutator#getName() name}
   *    .locale(String) // required {@link UpdateBuilder.WorkflowMutator#getLocale() locale}
   *    .content(String) // required {@link UpdateBuilder.WorkflowMutator#getContent() content}
   *    .addArticles|addAllArticles(String) // {@link UpdateBuilder.WorkflowMutator#getArticles() articles} elements
   *    .build();
   * </pre>
   * @return A new ImmutableWorkflowMutator builder
   */
  public static ImmutableWorkflowMutator.Builder builder() {
    return new ImmutableWorkflowMutator.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableWorkflowMutator ImmutableWorkflowMutator}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UpdateBuilder.WorkflowMutator", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_WORKFLOW_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_LOCALE = 0x4L;
    private static final long INIT_BIT_CONTENT = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String workflowId;
    private @Nullable String name;
    private @Nullable String locale;
    private @Nullable String content;
    private ImmutableList.Builder<String> articles = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code WorkflowMutator} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UpdateBuilder.WorkflowMutator instance) {
      Objects.requireNonNull(instance, "instance");
      workflowId(instance.getWorkflowId());
      name(instance.getName());
      locale(instance.getLocale());
      content(instance.getContent());
      addAllArticles(instance.getArticles());
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuilder.WorkflowMutator#getWorkflowId() workflowId} attribute.
     * @param workflowId The value for workflowId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("workflowId")
    public final Builder workflowId(String workflowId) {
      this.workflowId = Objects.requireNonNull(workflowId, "workflowId");
      initBits &= ~INIT_BIT_WORKFLOW_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuilder.WorkflowMutator#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuilder.WorkflowMutator#getLocale() locale} attribute.
     * @param locale The value for locale 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("locale")
    public final Builder locale(String locale) {
      this.locale = Objects.requireNonNull(locale, "locale");
      initBits &= ~INIT_BIT_LOCALE;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuilder.WorkflowMutator#getContent() content} attribute.
     * @param content The value for content 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("content")
    public final Builder content(String content) {
      this.content = Objects.requireNonNull(content, "content");
      initBits &= ~INIT_BIT_CONTENT;
      return this;
    }

    /**
     * Adds one element to {@link UpdateBuilder.WorkflowMutator#getArticles() articles} list.
     * @param element A articles element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addArticles(String element) {
      this.articles.add(element);
      return this;
    }

    /**
     * Adds elements to {@link UpdateBuilder.WorkflowMutator#getArticles() articles} list.
     * @param elements An array of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addArticles(String... elements) {
      this.articles.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UpdateBuilder.WorkflowMutator#getArticles() articles} list.
     * @param elements An iterable of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("articles")
    public final Builder articles(Iterable<String> elements) {
      this.articles = ImmutableList.builder();
      return addAllArticles(elements);
    }

    /**
     * Adds elements to {@link UpdateBuilder.WorkflowMutator#getArticles() articles} list.
     * @param elements An iterable of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllArticles(Iterable<String> elements) {
      this.articles.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableWorkflowMutator ImmutableWorkflowMutator}.
     * @return An immutable instance of WorkflowMutator
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableWorkflowMutator build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableWorkflowMutator(workflowId, name, locale, content, articles.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_WORKFLOW_ID) != 0) attributes.add("workflowId");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_LOCALE) != 0) attributes.add("locale");
      if ((initBits & INIT_BIT_CONTENT) != 0) attributes.add("content");
      return "Cannot build WorkflowMutator, some of required attributes are not set " + attributes;
    }
  }
}
