/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.persistence.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.persistence.api.CreateBuilder;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CreateBuilder.CreateWorkflow", generator="Immutables")
@Immutable
public final class ImmutableCreateWorkflow
implements CreateBuilder.CreateWorkflow {
    private final String name;
    private final String locale;
    private final String content;

    private ImmutableCreateWorkflow(String name, String locale, String content) {
        this.name = name;
        this.locale = locale;
        this.content = content;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="locale")
    public String getLocale() {
        return this.locale;
    }

    @Override
    @JsonProperty(value="content")
    public String getContent() {
        return this.content;
    }

    public final ImmutableCreateWorkflow withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableCreateWorkflow(newValue, this.locale, this.content);
    }

    public final ImmutableCreateWorkflow withLocale(String value) {
        String newValue = Objects.requireNonNull(value, "locale");
        if (this.locale.equals(newValue)) {
            return this;
        }
        return new ImmutableCreateWorkflow(this.name, newValue, this.content);
    }

    public final ImmutableCreateWorkflow withContent(String value) {
        String newValue = Objects.requireNonNull(value, "content");
        if (this.content.equals(newValue)) {
            return this;
        }
        return new ImmutableCreateWorkflow(this.name, this.locale, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCreateWorkflow && this.equalTo((ImmutableCreateWorkflow)another);
    }

    private boolean equalTo(ImmutableCreateWorkflow another) {
        return this.name.equals(another.name) && this.locale.equals(another.locale) && this.content.equals(another.content);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.locale.hashCode();
        h += (h << 5) + this.content.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CreateWorkflow").omitNullValues().add("name", (Object)this.name).add("locale", (Object)this.locale).add("content", (Object)this.content).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCreateWorkflow fromJson(Json json) {
        Builder builder = ImmutableCreateWorkflow.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.locale != null) {
            builder.locale(json.locale);
        }
        if (json.content != null) {
            builder.content(json.content);
        }
        return builder.build();
    }

    public static ImmutableCreateWorkflow copyOf(CreateBuilder.CreateWorkflow instance) {
        if (instance instanceof ImmutableCreateWorkflow) {
            return (ImmutableCreateWorkflow)instance;
        }
        return ImmutableCreateWorkflow.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CreateBuilder.CreateWorkflow", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_LOCALE = 2L;
        private static final long INIT_BIT_CONTENT = 4L;
        private long initBits = 7L;
        @Nullable
        private String name;
        @Nullable
        private String locale;
        @Nullable
        private String content;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CreateBuilder.CreateWorkflow instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            this.locale(instance.getLocale());
            this.content(instance.getContent());
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="locale")
        @CanIgnoreReturnValue
        public final Builder locale(String locale) {
            this.locale = Objects.requireNonNull(locale, "locale");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="content")
        @CanIgnoreReturnValue
        public final Builder content(String content) {
            this.content = Objects.requireNonNull(content, "content");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableCreateWorkflow build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCreateWorkflow(this.name, this.locale, this.content);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("locale");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("content");
            }
            return "Cannot build CreateWorkflow, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CreateBuilder.CreateWorkflow", generator="Immutables")
    static final class Json
    implements CreateBuilder.CreateWorkflow {
        @Nullable
        String name;
        @Nullable
        String locale;
        @Nullable
        String content;

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="locale")
        public void setLocale(String locale) {
            this.locale = locale;
        }

        @JsonProperty(value="content")
        public void setContent(String content) {
            this.content = content;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLocale() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getContent() {
            throw new UnsupportedOperationException();
        }
    }
}

