package io.thestencil.persistence.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DeleteBuilder.WorkflowArticlePage}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableWorkflowArticlePage.builder()}.
 */
@Generated(from = "DeleteBuilder.WorkflowArticlePage", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableWorkflowArticlePage
    implements DeleteBuilder.WorkflowArticlePage {
  private final String workflowId;
  private final String articleId;

  private ImmutableWorkflowArticlePage(String workflowId, String articleId) {
    this.workflowId = workflowId;
    this.articleId = articleId;
  }

  /**
   * @return The value of the {@code workflowId} attribute
   */
  @JsonProperty("workflowId")
  @Override
  public String getWorkflowId() {
    return workflowId;
  }

  /**
   * @return The value of the {@code articleId} attribute
   */
  @JsonProperty("articleId")
  @Override
  public String getArticleId() {
    return articleId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DeleteBuilder.WorkflowArticlePage#getWorkflowId() workflowId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for workflowId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWorkflowArticlePage withWorkflowId(String value) {
    String newValue = Objects.requireNonNull(value, "workflowId");
    if (this.workflowId.equals(newValue)) return this;
    return new ImmutableWorkflowArticlePage(newValue, this.articleId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DeleteBuilder.WorkflowArticlePage#getArticleId() articleId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for articleId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWorkflowArticlePage withArticleId(String value) {
    String newValue = Objects.requireNonNull(value, "articleId");
    if (this.articleId.equals(newValue)) return this;
    return new ImmutableWorkflowArticlePage(this.workflowId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableWorkflowArticlePage} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableWorkflowArticlePage
        && equalTo((ImmutableWorkflowArticlePage) another);
  }

  private boolean equalTo(ImmutableWorkflowArticlePage another) {
    return workflowId.equals(another.workflowId)
        && articleId.equals(another.articleId);
  }

  /**
   * Computes a hash code from attributes: {@code workflowId}, {@code articleId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + workflowId.hashCode();
    h += (h << 5) + articleId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code WorkflowArticlePage} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("WorkflowArticlePage")
        .omitNullValues()
        .add("workflowId", workflowId)
        .add("articleId", articleId)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DeleteBuilder.WorkflowArticlePage", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DeleteBuilder.WorkflowArticlePage {
    @Nullable String workflowId;
    @Nullable String articleId;
    @JsonProperty("workflowId")
    public void setWorkflowId(String workflowId) {
      this.workflowId = workflowId;
    }
    @JsonProperty("articleId")
    public void setArticleId(String articleId) {
      this.articleId = articleId;
    }
    @Override
    public String getWorkflowId() { throw new UnsupportedOperationException(); }
    @Override
    public String getArticleId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableWorkflowArticlePage fromJson(Json json) {
    ImmutableWorkflowArticlePage.Builder builder = ImmutableWorkflowArticlePage.builder();
    if (json.workflowId != null) {
      builder.workflowId(json.workflowId);
    }
    if (json.articleId != null) {
      builder.articleId(json.articleId);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DeleteBuilder.WorkflowArticlePage} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WorkflowArticlePage instance
   */
  public static ImmutableWorkflowArticlePage copyOf(DeleteBuilder.WorkflowArticlePage instance) {
    if (instance instanceof ImmutableWorkflowArticlePage) {
      return (ImmutableWorkflowArticlePage) instance;
    }
    return ImmutableWorkflowArticlePage.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableWorkflowArticlePage ImmutableWorkflowArticlePage}.
   * <pre>
   * ImmutableWorkflowArticlePage.builder()
   *    .workflowId(String) // required {@link DeleteBuilder.WorkflowArticlePage#getWorkflowId() workflowId}
   *    .articleId(String) // required {@link DeleteBuilder.WorkflowArticlePage#getArticleId() articleId}
   *    .build();
   * </pre>
   * @return A new ImmutableWorkflowArticlePage builder
   */
  public static ImmutableWorkflowArticlePage.Builder builder() {
    return new ImmutableWorkflowArticlePage.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableWorkflowArticlePage ImmutableWorkflowArticlePage}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DeleteBuilder.WorkflowArticlePage", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_WORKFLOW_ID = 0x1L;
    private static final long INIT_BIT_ARTICLE_ID = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String workflowId;
    private @Nullable String articleId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code WorkflowArticlePage} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DeleteBuilder.WorkflowArticlePage instance) {
      Objects.requireNonNull(instance, "instance");
      workflowId(instance.getWorkflowId());
      articleId(instance.getArticleId());
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteBuilder.WorkflowArticlePage#getWorkflowId() workflowId} attribute.
     * @param workflowId The value for workflowId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("workflowId")
    public final Builder workflowId(String workflowId) {
      this.workflowId = Objects.requireNonNull(workflowId, "workflowId");
      initBits &= ~INIT_BIT_WORKFLOW_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DeleteBuilder.WorkflowArticlePage#getArticleId() articleId} attribute.
     * @param articleId The value for articleId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("articleId")
    public final Builder articleId(String articleId) {
      this.articleId = Objects.requireNonNull(articleId, "articleId");
      initBits &= ~INIT_BIT_ARTICLE_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableWorkflowArticlePage ImmutableWorkflowArticlePage}.
     * @return An immutable instance of WorkflowArticlePage
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableWorkflowArticlePage build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableWorkflowArticlePage(workflowId, articleId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_WORKFLOW_ID) != 0) attributes.add("workflowId");
      if ((initBits & INIT_BIT_ARTICLE_ID) != 0) attributes.add("articleId");
      return "Cannot build WorkflowArticlePage, some of required attributes are not set " + attributes;
    }
  }
}
