package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StencilClient.Locale}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLocale.builder()}.
 */
@Generated(from = "StencilClient.Locale", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableLocale implements StencilClient.Locale {
  private final String value;
  private final Boolean enabled;

  private ImmutableLocale(String value, Boolean enabled) {
    this.value = value;
    this.enabled = enabled;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty("value")
  @Override
  public String getValue() {
    return value;
  }

  /**
   * @return The value of the {@code enabled} attribute
   */
  @JsonProperty("enabled")
  @Override
  public Boolean getEnabled() {
    return enabled;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.Locale#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLocale withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableLocale(newValue, this.enabled);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.Locale#getEnabled() enabled} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for enabled
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLocale withEnabled(Boolean value) {
    Boolean newValue = Objects.requireNonNull(value, "enabled");
    if (this.enabled.equals(newValue)) return this;
    return new ImmutableLocale(this.value, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLocale} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLocale
        && equalTo((ImmutableLocale) another);
  }

  private boolean equalTo(ImmutableLocale another) {
    return value.equals(another.value)
        && enabled.equals(another.enabled);
  }

  /**
   * Computes a hash code from attributes: {@code value}, {@code enabled}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + value.hashCode();
    h += (h << 5) + enabled.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Locale} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Locale")
        .omitNullValues()
        .add("value", value)
        .add("enabled", enabled)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "StencilClient.Locale", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements StencilClient.Locale {
    @Nullable String value;
    @Nullable Boolean enabled;
    @JsonProperty("value")
    public void setValue(String value) {
      this.value = value;
    }
    @JsonProperty("enabled")
    public void setEnabled(Boolean enabled) {
      this.enabled = enabled;
    }
    @Override
    public String getValue() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getEnabled() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableLocale fromJson(Json json) {
    ImmutableLocale.Builder builder = ImmutableLocale.builder();
    if (json.value != null) {
      builder.value(json.value);
    }
    if (json.enabled != null) {
      builder.enabled(json.enabled);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link StencilClient.Locale} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Locale instance
   */
  public static ImmutableLocale copyOf(StencilClient.Locale instance) {
    if (instance instanceof ImmutableLocale) {
      return (ImmutableLocale) instance;
    }
    return ImmutableLocale.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLocale ImmutableLocale}.
   * <pre>
   * ImmutableLocale.builder()
   *    .value(String) // required {@link StencilClient.Locale#getValue() value}
   *    .enabled(Boolean) // required {@link StencilClient.Locale#getEnabled() enabled}
   *    .build();
   * </pre>
   * @return A new ImmutableLocale builder
   */
  public static ImmutableLocale.Builder builder() {
    return new ImmutableLocale.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLocale ImmutableLocale}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StencilClient.Locale", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VALUE = 0x1L;
    private static final long INIT_BIT_ENABLED = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String value;
    private @Nullable Boolean enabled;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Locale} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StencilClient.Locale instance) {
      Objects.requireNonNull(instance, "instance");
      value(instance.getValue());
      enabled(instance.getEnabled());
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.Locale#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("value")
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.Locale#getEnabled() enabled} attribute.
     * @param enabled The value for enabled 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("enabled")
    public final Builder enabled(Boolean enabled) {
      this.enabled = Objects.requireNonNull(enabled, "enabled");
      initBits &= ~INIT_BIT_ENABLED;
      return this;
    }

    /**
     * Builds a new {@link ImmutableLocale ImmutableLocale}.
     * @return An immutable instance of Locale
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLocale build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableLocale(value, enabled);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      if ((initBits & INIT_BIT_ENABLED) != 0) attributes.add("enabled");
      return "Cannot build Locale, some of required attributes are not set " + attributes;
    }
  }
}
