/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.client.api.StencilClient;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StencilClient.Release", generator="Immutables")
@Immutable
public final class ImmutableRelease
implements StencilClient.Release {
    private final String parentCommit;
    private final String name;
    private final String note;
    private final LocalDateTime created;
    private final ImmutableList<StencilClient.LocaleReleaseItem> locales;
    private final ImmutableList<StencilClient.ArticleReleaseItem> articles;
    private final ImmutableList<StencilClient.LinkReleaseItem> links;
    private final ImmutableList<StencilClient.WorkflowReleaseItem> workflows;
    private final ImmutableList<StencilClient.PageReleaseItem> pages;
    private final ImmutableList<StencilClient.TemplateReleaseItem> templates;

    private ImmutableRelease(String parentCommit, String name, String note, LocalDateTime created, ImmutableList<StencilClient.LocaleReleaseItem> locales, ImmutableList<StencilClient.ArticleReleaseItem> articles, ImmutableList<StencilClient.LinkReleaseItem> links, ImmutableList<StencilClient.WorkflowReleaseItem> workflows, ImmutableList<StencilClient.PageReleaseItem> pages, ImmutableList<StencilClient.TemplateReleaseItem> templates) {
        this.parentCommit = parentCommit;
        this.name = name;
        this.note = note;
        this.created = created;
        this.locales = locales;
        this.articles = articles;
        this.links = links;
        this.workflows = workflows;
        this.pages = pages;
        this.templates = templates;
    }

    @Override
    @JsonProperty(value="parentCommit")
    public String getParentCommit() {
        return this.parentCommit;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="note")
    public String getNote() {
        return this.note;
    }

    @Override
    @JsonProperty(value="created")
    public LocalDateTime getCreated() {
        return this.created;
    }

    @JsonProperty(value="locales")
    public ImmutableList<StencilClient.LocaleReleaseItem> getLocales() {
        return this.locales;
    }

    @JsonProperty(value="articles")
    public ImmutableList<StencilClient.ArticleReleaseItem> getArticles() {
        return this.articles;
    }

    @JsonProperty(value="links")
    public ImmutableList<StencilClient.LinkReleaseItem> getLinks() {
        return this.links;
    }

    @JsonProperty(value="workflows")
    public ImmutableList<StencilClient.WorkflowReleaseItem> getWorkflows() {
        return this.workflows;
    }

    @JsonProperty(value="pages")
    public ImmutableList<StencilClient.PageReleaseItem> getPages() {
        return this.pages;
    }

    @JsonProperty(value="templates")
    public ImmutableList<StencilClient.TemplateReleaseItem> getTemplates() {
        return this.templates;
    }

    public final ImmutableRelease withParentCommit(String value) {
        String newValue = Objects.requireNonNull(value, "parentCommit");
        if (this.parentCommit.equals(newValue)) {
            return this;
        }
        return new ImmutableRelease(newValue, this.name, this.note, this.created, this.locales, this.articles, this.links, this.workflows, this.pages, this.templates);
    }

    public final ImmutableRelease withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableRelease(this.parentCommit, newValue, this.note, this.created, this.locales, this.articles, this.links, this.workflows, this.pages, this.templates);
    }

    public final ImmutableRelease withNote(String value) {
        String newValue = Objects.requireNonNull(value, "note");
        if (this.note.equals(newValue)) {
            return this;
        }
        return new ImmutableRelease(this.parentCommit, this.name, newValue, this.created, this.locales, this.articles, this.links, this.workflows, this.pages, this.templates);
    }

    public final ImmutableRelease withCreated(LocalDateTime value) {
        if (this.created == value) {
            return this;
        }
        LocalDateTime newValue = Objects.requireNonNull(value, "created");
        return new ImmutableRelease(this.parentCommit, this.name, this.note, newValue, this.locales, this.articles, this.links, this.workflows, this.pages, this.templates);
    }

    public final ImmutableRelease withLocales(StencilClient.LocaleReleaseItem ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRelease(this.parentCommit, this.name, this.note, this.created, (ImmutableList<StencilClient.LocaleReleaseItem>)newValue, this.articles, this.links, this.workflows, this.pages, this.templates);
    }

    public final ImmutableRelease withLocales(Iterable<? extends StencilClient.LocaleReleaseItem> elements) {
        if (this.locales == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRelease(this.parentCommit, this.name, this.note, this.created, (ImmutableList<StencilClient.LocaleReleaseItem>)newValue, this.articles, this.links, this.workflows, this.pages, this.templates);
    }

    public final ImmutableRelease withArticles(StencilClient.ArticleReleaseItem ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRelease(this.parentCommit, this.name, this.note, this.created, this.locales, (ImmutableList<StencilClient.ArticleReleaseItem>)newValue, this.links, this.workflows, this.pages, this.templates);
    }

    public final ImmutableRelease withArticles(Iterable<? extends StencilClient.ArticleReleaseItem> elements) {
        if (this.articles == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRelease(this.parentCommit, this.name, this.note, this.created, this.locales, (ImmutableList<StencilClient.ArticleReleaseItem>)newValue, this.links, this.workflows, this.pages, this.templates);
    }

    public final ImmutableRelease withLinks(StencilClient.LinkReleaseItem ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRelease(this.parentCommit, this.name, this.note, this.created, this.locales, this.articles, (ImmutableList<StencilClient.LinkReleaseItem>)newValue, this.workflows, this.pages, this.templates);
    }

    public final ImmutableRelease withLinks(Iterable<? extends StencilClient.LinkReleaseItem> elements) {
        if (this.links == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRelease(this.parentCommit, this.name, this.note, this.created, this.locales, this.articles, (ImmutableList<StencilClient.LinkReleaseItem>)newValue, this.workflows, this.pages, this.templates);
    }

    public final ImmutableRelease withWorkflows(StencilClient.WorkflowReleaseItem ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRelease(this.parentCommit, this.name, this.note, this.created, this.locales, this.articles, this.links, (ImmutableList<StencilClient.WorkflowReleaseItem>)newValue, this.pages, this.templates);
    }

    public final ImmutableRelease withWorkflows(Iterable<? extends StencilClient.WorkflowReleaseItem> elements) {
        if (this.workflows == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRelease(this.parentCommit, this.name, this.note, this.created, this.locales, this.articles, this.links, (ImmutableList<StencilClient.WorkflowReleaseItem>)newValue, this.pages, this.templates);
    }

    public final ImmutableRelease withPages(StencilClient.PageReleaseItem ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRelease(this.parentCommit, this.name, this.note, this.created, this.locales, this.articles, this.links, this.workflows, (ImmutableList<StencilClient.PageReleaseItem>)newValue, this.templates);
    }

    public final ImmutableRelease withPages(Iterable<? extends StencilClient.PageReleaseItem> elements) {
        if (this.pages == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRelease(this.parentCommit, this.name, this.note, this.created, this.locales, this.articles, this.links, this.workflows, (ImmutableList<StencilClient.PageReleaseItem>)newValue, this.templates);
    }

    public final ImmutableRelease withTemplates(StencilClient.TemplateReleaseItem ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRelease(this.parentCommit, this.name, this.note, this.created, this.locales, this.articles, this.links, this.workflows, this.pages, (ImmutableList<StencilClient.TemplateReleaseItem>)newValue);
    }

    public final ImmutableRelease withTemplates(Iterable<? extends StencilClient.TemplateReleaseItem> elements) {
        if (this.templates == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRelease(this.parentCommit, this.name, this.note, this.created, this.locales, this.articles, this.links, this.workflows, this.pages, (ImmutableList<StencilClient.TemplateReleaseItem>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRelease && this.equalTo((ImmutableRelease)another);
    }

    private boolean equalTo(ImmutableRelease another) {
        return this.parentCommit.equals(another.parentCommit) && this.name.equals(another.name) && this.note.equals(another.note) && this.created.equals(another.created) && this.locales.equals(another.locales) && this.articles.equals(another.articles) && this.links.equals(another.links) && this.workflows.equals(another.workflows) && this.pages.equals(another.pages) && this.templates.equals(another.templates);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.parentCommit.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.note.hashCode();
        h += (h << 5) + this.created.hashCode();
        h += (h << 5) + this.locales.hashCode();
        h += (h << 5) + this.articles.hashCode();
        h += (h << 5) + this.links.hashCode();
        h += (h << 5) + this.workflows.hashCode();
        h += (h << 5) + this.pages.hashCode();
        h += (h << 5) + this.templates.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Release").omitNullValues().add("parentCommit", (Object)this.parentCommit).add("name", (Object)this.name).add("note", (Object)this.note).add("created", (Object)this.created).add("locales", this.locales).add("articles", this.articles).add("links", this.links).add("workflows", this.workflows).add("pages", this.pages).add("templates", this.templates).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRelease fromJson(Json json) {
        Builder builder = ImmutableRelease.builder();
        if (json.parentCommit != null) {
            builder.parentCommit(json.parentCommit);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.note != null) {
            builder.note(json.note);
        }
        if (json.created != null) {
            builder.created(json.created);
        }
        if (json.locales != null) {
            builder.addAllLocales(json.locales);
        }
        if (json.articles != null) {
            builder.addAllArticles(json.articles);
        }
        if (json.links != null) {
            builder.addAllLinks(json.links);
        }
        if (json.workflows != null) {
            builder.addAllWorkflows(json.workflows);
        }
        if (json.pages != null) {
            builder.addAllPages(json.pages);
        }
        if (json.templates != null) {
            builder.addAllTemplates(json.templates);
        }
        return builder.build();
    }

    public static ImmutableRelease copyOf(StencilClient.Release instance) {
        if (instance instanceof ImmutableRelease) {
            return (ImmutableRelease)instance;
        }
        return ImmutableRelease.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StencilClient.Release", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PARENT_COMMIT = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_NOTE = 4L;
        private static final long INIT_BIT_CREATED = 8L;
        private long initBits = 15L;
        @Nullable
        private String parentCommit;
        @Nullable
        private String name;
        @Nullable
        private String note;
        @Nullable
        private LocalDateTime created;
        private ImmutableList.Builder<StencilClient.LocaleReleaseItem> locales = ImmutableList.builder();
        private ImmutableList.Builder<StencilClient.ArticleReleaseItem> articles = ImmutableList.builder();
        private ImmutableList.Builder<StencilClient.LinkReleaseItem> links = ImmutableList.builder();
        private ImmutableList.Builder<StencilClient.WorkflowReleaseItem> workflows = ImmutableList.builder();
        private ImmutableList.Builder<StencilClient.PageReleaseItem> pages = ImmutableList.builder();
        private ImmutableList.Builder<StencilClient.TemplateReleaseItem> templates = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StencilClient.Release instance) {
            Objects.requireNonNull(instance, "instance");
            this.parentCommit(instance.getParentCommit());
            this.name(instance.getName());
            this.note(instance.getNote());
            this.created(instance.getCreated());
            this.addAllLocales(instance.getLocales());
            this.addAllArticles(instance.getArticles());
            this.addAllLinks(instance.getLinks());
            this.addAllWorkflows(instance.getWorkflows());
            this.addAllPages(instance.getPages());
            this.addAllTemplates(instance.getTemplates());
            return this;
        }

        @JsonProperty(value="parentCommit")
        @CanIgnoreReturnValue
        public final Builder parentCommit(String parentCommit) {
            this.parentCommit = Objects.requireNonNull(parentCommit, "parentCommit");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="note")
        @CanIgnoreReturnValue
        public final Builder note(String note) {
            this.note = Objects.requireNonNull(note, "note");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="created")
        @CanIgnoreReturnValue
        public final Builder created(LocalDateTime created) {
            this.created = Objects.requireNonNull(created, "created");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLocales(StencilClient.LocaleReleaseItem element) {
            this.locales.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLocales(StencilClient.LocaleReleaseItem ... elements) {
            this.locales.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="locales")
        @CanIgnoreReturnValue
        public final Builder locales(Iterable<? extends StencilClient.LocaleReleaseItem> elements) {
            this.locales = ImmutableList.builder();
            return this.addAllLocales(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLocales(Iterable<? extends StencilClient.LocaleReleaseItem> elements) {
            this.locales.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArticles(StencilClient.ArticleReleaseItem element) {
            this.articles.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArticles(StencilClient.ArticleReleaseItem ... elements) {
            this.articles.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="articles")
        @CanIgnoreReturnValue
        public final Builder articles(Iterable<? extends StencilClient.ArticleReleaseItem> elements) {
            this.articles = ImmutableList.builder();
            return this.addAllArticles(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllArticles(Iterable<? extends StencilClient.ArticleReleaseItem> elements) {
            this.articles.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLinks(StencilClient.LinkReleaseItem element) {
            this.links.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLinks(StencilClient.LinkReleaseItem ... elements) {
            this.links.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="links")
        @CanIgnoreReturnValue
        public final Builder links(Iterable<? extends StencilClient.LinkReleaseItem> elements) {
            this.links = ImmutableList.builder();
            return this.addAllLinks(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLinks(Iterable<? extends StencilClient.LinkReleaseItem> elements) {
            this.links.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addWorkflows(StencilClient.WorkflowReleaseItem element) {
            this.workflows.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addWorkflows(StencilClient.WorkflowReleaseItem ... elements) {
            this.workflows.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="workflows")
        @CanIgnoreReturnValue
        public final Builder workflows(Iterable<? extends StencilClient.WorkflowReleaseItem> elements) {
            this.workflows = ImmutableList.builder();
            return this.addAllWorkflows(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllWorkflows(Iterable<? extends StencilClient.WorkflowReleaseItem> elements) {
            this.workflows.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPages(StencilClient.PageReleaseItem element) {
            this.pages.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPages(StencilClient.PageReleaseItem ... elements) {
            this.pages.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="pages")
        @CanIgnoreReturnValue
        public final Builder pages(Iterable<? extends StencilClient.PageReleaseItem> elements) {
            this.pages = ImmutableList.builder();
            return this.addAllPages(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPages(Iterable<? extends StencilClient.PageReleaseItem> elements) {
            this.pages.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTemplates(StencilClient.TemplateReleaseItem element) {
            this.templates.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTemplates(StencilClient.TemplateReleaseItem ... elements) {
            this.templates.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="templates")
        @CanIgnoreReturnValue
        public final Builder templates(Iterable<? extends StencilClient.TemplateReleaseItem> elements) {
            this.templates = ImmutableList.builder();
            return this.addAllTemplates(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTemplates(Iterable<? extends StencilClient.TemplateReleaseItem> elements) {
            this.templates.addAll(elements);
            return this;
        }

        public ImmutableRelease build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRelease(this.parentCommit, this.name, this.note, this.created, (ImmutableList<StencilClient.LocaleReleaseItem>)this.locales.build(), (ImmutableList<StencilClient.ArticleReleaseItem>)this.articles.build(), (ImmutableList<StencilClient.LinkReleaseItem>)this.links.build(), (ImmutableList<StencilClient.WorkflowReleaseItem>)this.workflows.build(), (ImmutableList<StencilClient.PageReleaseItem>)this.pages.build(), (ImmutableList<StencilClient.TemplateReleaseItem>)this.templates.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("parentCommit");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("note");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("created");
            }
            return "Cannot build Release, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="StencilClient.Release", generator="Immutables")
    static final class Json
    implements StencilClient.Release {
        @Nullable
        String parentCommit;
        @Nullable
        String name;
        @Nullable
        String note;
        @Nullable
        LocalDateTime created;
        @Nullable
        List<StencilClient.LocaleReleaseItem> locales = ImmutableList.of();
        @Nullable
        List<StencilClient.ArticleReleaseItem> articles = ImmutableList.of();
        @Nullable
        List<StencilClient.LinkReleaseItem> links = ImmutableList.of();
        @Nullable
        List<StencilClient.WorkflowReleaseItem> workflows = ImmutableList.of();
        @Nullable
        List<StencilClient.PageReleaseItem> pages = ImmutableList.of();
        @Nullable
        List<StencilClient.TemplateReleaseItem> templates = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="parentCommit")
        public void setParentCommit(String parentCommit) {
            this.parentCommit = parentCommit;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="note")
        public void setNote(String note) {
            this.note = note;
        }

        @JsonProperty(value="created")
        public void setCreated(LocalDateTime created) {
            this.created = created;
        }

        @JsonProperty(value="locales")
        public void setLocales(List<StencilClient.LocaleReleaseItem> locales) {
            this.locales = locales;
        }

        @JsonProperty(value="articles")
        public void setArticles(List<StencilClient.ArticleReleaseItem> articles) {
            this.articles = articles;
        }

        @JsonProperty(value="links")
        public void setLinks(List<StencilClient.LinkReleaseItem> links) {
            this.links = links;
        }

        @JsonProperty(value="workflows")
        public void setWorkflows(List<StencilClient.WorkflowReleaseItem> workflows) {
            this.workflows = workflows;
        }

        @JsonProperty(value="pages")
        public void setPages(List<StencilClient.PageReleaseItem> pages) {
            this.pages = pages;
        }

        @JsonProperty(value="templates")
        public void setTemplates(List<StencilClient.TemplateReleaseItem> templates) {
            this.templates = templates;
        }

        @Override
        public String getParentCommit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getNote() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LocalDateTime getCreated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<StencilClient.LocaleReleaseItem> getLocales() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<StencilClient.ArticleReleaseItem> getArticles() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<StencilClient.LinkReleaseItem> getLinks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<StencilClient.WorkflowReleaseItem> getWorkflows() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<StencilClient.PageReleaseItem> getPages() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<StencilClient.TemplateReleaseItem> getTemplates() {
            throw new UnsupportedOperationException();
        }
    }
}

