/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.client.api.DeleteBuilder;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DeleteBuilder.LinkArticlePage", generator="Immutables")
@Immutable
public final class ImmutableLinkArticlePage
implements DeleteBuilder.LinkArticlePage {
    private final String linkId;
    private final String articleId;

    private ImmutableLinkArticlePage(String linkId, String articleId) {
        this.linkId = linkId;
        this.articleId = articleId;
    }

    @Override
    @JsonProperty(value="linkId")
    public String getLinkId() {
        return this.linkId;
    }

    @Override
    @JsonProperty(value="articleId")
    public String getArticleId() {
        return this.articleId;
    }

    public final ImmutableLinkArticlePage withLinkId(String value) {
        String newValue = Objects.requireNonNull(value, "linkId");
        if (this.linkId.equals(newValue)) {
            return this;
        }
        return new ImmutableLinkArticlePage(newValue, this.articleId);
    }

    public final ImmutableLinkArticlePage withArticleId(String value) {
        String newValue = Objects.requireNonNull(value, "articleId");
        if (this.articleId.equals(newValue)) {
            return this;
        }
        return new ImmutableLinkArticlePage(this.linkId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLinkArticlePage && this.equalTo((ImmutableLinkArticlePage)another);
    }

    private boolean equalTo(ImmutableLinkArticlePage another) {
        return this.linkId.equals(another.linkId) && this.articleId.equals(another.articleId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.linkId.hashCode();
        h += (h << 5) + this.articleId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LinkArticlePage").omitNullValues().add("linkId", (Object)this.linkId).add("articleId", (Object)this.articleId).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLinkArticlePage fromJson(Json json) {
        Builder builder = ImmutableLinkArticlePage.builder();
        if (json.linkId != null) {
            builder.linkId(json.linkId);
        }
        if (json.articleId != null) {
            builder.articleId(json.articleId);
        }
        return builder.build();
    }

    public static ImmutableLinkArticlePage copyOf(DeleteBuilder.LinkArticlePage instance) {
        if (instance instanceof ImmutableLinkArticlePage) {
            return (ImmutableLinkArticlePage)instance;
        }
        return ImmutableLinkArticlePage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DeleteBuilder.LinkArticlePage", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LINK_ID = 1L;
        private static final long INIT_BIT_ARTICLE_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private String linkId;
        @Nullable
        private String articleId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DeleteBuilder.LinkArticlePage instance) {
            Objects.requireNonNull(instance, "instance");
            this.linkId(instance.getLinkId());
            this.articleId(instance.getArticleId());
            return this;
        }

        @JsonProperty(value="linkId")
        @CanIgnoreReturnValue
        public final Builder linkId(String linkId) {
            this.linkId = Objects.requireNonNull(linkId, "linkId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="articleId")
        @CanIgnoreReturnValue
        public final Builder articleId(String articleId) {
            this.articleId = Objects.requireNonNull(articleId, "articleId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableLinkArticlePage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLinkArticlePage(this.linkId, this.articleId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("linkId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("articleId");
            }
            return "Cannot build LinkArticlePage, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DeleteBuilder.LinkArticlePage", generator="Immutables")
    static final class Json
    implements DeleteBuilder.LinkArticlePage {
        @Nullable
        String linkId;
        @Nullable
        String articleId;

        Json() {
        }

        @JsonProperty(value="linkId")
        public void setLinkId(String linkId) {
            this.linkId = linkId;
        }

        @JsonProperty(value="articleId")
        public void setArticleId(String articleId) {
            this.articleId = articleId;
        }

        @Override
        public String getLinkId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getArticleId() {
            throw new UnsupportedOperationException();
        }
    }
}

