/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.api.UpdateBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="UpdateBuilder.WorkflowMutator", generator="Immutables")
@Immutable
public final class ImmutableWorkflowMutator
implements UpdateBuilder.WorkflowMutator {
    private final String workflowId;
    private final String value;
    @Nullable
    private final ImmutableList<StencilClient.LocaleLabel> labels;
    @Nullable
    private final ImmutableList<String> articles;
    @Nullable
    private final Boolean devMode;

    private ImmutableWorkflowMutator(String workflowId, String value, @Nullable ImmutableList<StencilClient.LocaleLabel> labels, @Nullable ImmutableList<String> articles, @Nullable Boolean devMode) {
        this.workflowId = workflowId;
        this.value = value;
        this.labels = labels;
        this.articles = articles;
        this.devMode = devMode;
    }

    @Override
    @JsonProperty(value="workflowId")
    public String getWorkflowId() {
        return this.workflowId;
    }

    @Override
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="labels")
    @Nullable
    public ImmutableList<StencilClient.LocaleLabel> getLabels() {
        return this.labels;
    }

    @JsonProperty(value="articles")
    @Nullable
    public ImmutableList<String> getArticles() {
        return this.articles;
    }

    @Override
    @JsonProperty(value="devMode")
    @Nullable
    public Boolean getDevMode() {
        return this.devMode;
    }

    public final ImmutableWorkflowMutator withWorkflowId(String value) {
        String newValue = Objects.requireNonNull(value, "workflowId");
        if (this.workflowId.equals(newValue)) {
            return this;
        }
        return new ImmutableWorkflowMutator(newValue, this.value, this.labels, this.articles, this.devMode);
    }

    public final ImmutableWorkflowMutator withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableWorkflowMutator(this.workflowId, newValue, this.labels, this.articles, this.devMode);
    }

    public final ImmutableWorkflowMutator withLabels(StencilClient.LocaleLabel ... elements) {
        if (elements == null) {
            return new ImmutableWorkflowMutator(this.workflowId, this.value, null, this.articles, this.devMode);
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf((Object[])elements);
        return new ImmutableWorkflowMutator(this.workflowId, this.value, (ImmutableList<StencilClient.LocaleLabel>)newValue, this.articles, this.devMode);
    }

    public final ImmutableWorkflowMutator withLabels(@Nullable Iterable<? extends StencilClient.LocaleLabel> elements) {
        if (this.labels == elements) {
            return this;
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableWorkflowMutator(this.workflowId, this.value, (ImmutableList<StencilClient.LocaleLabel>)newValue, this.articles, this.devMode);
    }

    public final ImmutableWorkflowMutator withArticles(String ... elements) {
        if (elements == null) {
            return new ImmutableWorkflowMutator(this.workflowId, this.value, this.labels, null, this.devMode);
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf((Object[])elements);
        return new ImmutableWorkflowMutator(this.workflowId, this.value, this.labels, (ImmutableList<String>)newValue, this.devMode);
    }

    public final ImmutableWorkflowMutator withArticles(@Nullable Iterable<String> elements) {
        if (this.articles == elements) {
            return this;
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableWorkflowMutator(this.workflowId, this.value, this.labels, (ImmutableList<String>)newValue, this.devMode);
    }

    public final ImmutableWorkflowMutator withDevMode(@Nullable Boolean value) {
        if (Objects.equals(this.devMode, value)) {
            return this;
        }
        return new ImmutableWorkflowMutator(this.workflowId, this.value, this.labels, this.articles, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWorkflowMutator && this.equalTo((ImmutableWorkflowMutator)another);
    }

    private boolean equalTo(ImmutableWorkflowMutator another) {
        return this.workflowId.equals(another.workflowId) && this.value.equals(another.value) && Objects.equals(this.labels, another.labels) && Objects.equals(this.articles, another.articles) && Objects.equals(this.devMode, another.devMode);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.workflowId.hashCode();
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + Objects.hashCode(this.labels);
        h += (h << 5) + Objects.hashCode(this.articles);
        h += (h << 5) + Objects.hashCode(this.devMode);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WorkflowMutator").omitNullValues().add("workflowId", (Object)this.workflowId).add("value", (Object)this.value).add("labels", this.labels).add("articles", this.articles).add("devMode", (Object)this.devMode).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableWorkflowMutator fromJson(Json json) {
        Builder builder = ImmutableWorkflowMutator.builder();
        if (json.workflowId != null) {
            builder.workflowId(json.workflowId);
        }
        if (json.value != null) {
            builder.value(json.value);
        }
        if (json.labels != null) {
            builder.addAllLabels(json.labels);
        }
        if (json.articles != null) {
            builder.addAllArticles(json.articles);
        }
        if (json.devMode != null) {
            builder.devMode(json.devMode);
        }
        return builder.build();
    }

    public static ImmutableWorkflowMutator copyOf(UpdateBuilder.WorkflowMutator instance) {
        if (instance instanceof ImmutableWorkflowMutator) {
            return (ImmutableWorkflowMutator)instance;
        }
        return ImmutableWorkflowMutator.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="UpdateBuilder.WorkflowMutator", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_WORKFLOW_ID = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private long initBits = 3L;
        @Nullable
        private String workflowId;
        @Nullable
        private String value;
        private ImmutableList.Builder<StencilClient.LocaleLabel> labels = null;
        private ImmutableList.Builder<String> articles = null;
        @Nullable
        private Boolean devMode;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(UpdateBuilder.WorkflowMutator instance) {
            Boolean devModeValue;
            List<String> articlesValue;
            Objects.requireNonNull(instance, "instance");
            this.workflowId(instance.getWorkflowId());
            this.value(instance.getValue());
            List<StencilClient.LocaleLabel> labelsValue = instance.getLabels();
            if (labelsValue != null) {
                this.addAllLabels(labelsValue);
            }
            if ((articlesValue = instance.getArticles()) != null) {
                this.addAllArticles(articlesValue);
            }
            if ((devModeValue = instance.getDevMode()) != null) {
                this.devMode(devModeValue);
            }
            return this;
        }

        @JsonProperty(value="workflowId")
        @CanIgnoreReturnValue
        public final Builder workflowId(String workflowId) {
            this.workflowId = Objects.requireNonNull(workflowId, "workflowId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="value")
        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLabels(StencilClient.LocaleLabel element) {
            if (this.labels == null) {
                this.labels = ImmutableList.builder();
            }
            this.labels.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLabels(StencilClient.LocaleLabel ... elements) {
            if (this.labels == null) {
                this.labels = ImmutableList.builder();
            }
            this.labels.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="labels")
        @CanIgnoreReturnValue
        public final Builder labels(@Nullable Iterable<? extends StencilClient.LocaleLabel> elements) {
            if (elements == null) {
                this.labels = null;
                return this;
            }
            this.labels = ImmutableList.builder();
            return this.addAllLabels(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLabels(Iterable<? extends StencilClient.LocaleLabel> elements) {
            Objects.requireNonNull(elements, "labels element");
            if (this.labels == null) {
                this.labels = ImmutableList.builder();
            }
            this.labels.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArticles(String element) {
            if (this.articles == null) {
                this.articles = ImmutableList.builder();
            }
            this.articles.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArticles(String ... elements) {
            if (this.articles == null) {
                this.articles = ImmutableList.builder();
            }
            this.articles.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="articles")
        @CanIgnoreReturnValue
        public final Builder articles(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.articles = null;
                return this;
            }
            this.articles = ImmutableList.builder();
            return this.addAllArticles(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllArticles(Iterable<String> elements) {
            Objects.requireNonNull(elements, "articles element");
            if (this.articles == null) {
                this.articles = ImmutableList.builder();
            }
            this.articles.addAll(elements);
            return this;
        }

        @JsonProperty(value="devMode")
        @CanIgnoreReturnValue
        public final Builder devMode(@Nullable Boolean devMode) {
            this.devMode = devMode;
            return this;
        }

        public ImmutableWorkflowMutator build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWorkflowMutator(this.workflowId, this.value, (ImmutableList<StencilClient.LocaleLabel>)(this.labels == null ? null : this.labels.build()), (ImmutableList<String>)(this.articles == null ? null : this.articles.build()), this.devMode);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("workflowId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build WorkflowMutator, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="UpdateBuilder.WorkflowMutator", generator="Immutables")
    static final class Json
    implements UpdateBuilder.WorkflowMutator {
        @Nullable
        String workflowId;
        @Nullable
        String value;
        @Nullable
        List<StencilClient.LocaleLabel> labels = null;
        @Nullable
        List<String> articles = null;
        @Nullable
        Boolean devMode;

        Json() {
        }

        @JsonProperty(value="workflowId")
        public void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @JsonProperty(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @JsonProperty(value="labels")
        public void setLabels(@Nullable List<StencilClient.LocaleLabel> labels) {
            this.labels = labels;
        }

        @JsonProperty(value="articles")
        public void setArticles(@Nullable List<String> articles) {
            this.articles = articles;
        }

        @JsonProperty(value="devMode")
        public void setDevMode(@Nullable Boolean devMode) {
            this.devMode = devMode;
        }

        @Override
        public String getWorkflowId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<StencilClient.LocaleLabel> getLabels() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getArticles() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getDevMode() {
            throw new UnsupportedOperationException();
        }
    }
}

