/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.api.UpdateBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="UpdateBuilder.LinkMutator", generator="Immutables")
@Immutable
public final class ImmutableLinkMutator
implements UpdateBuilder.LinkMutator {
    private final String linkId;
    private final String value;
    private final String type;
    @Nullable
    private final ImmutableList<StencilClient.LocaleLabel> labels;
    @Nullable
    private final ImmutableList<String> articles;

    private ImmutableLinkMutator(String linkId, String value, String type, @Nullable ImmutableList<StencilClient.LocaleLabel> labels, @Nullable ImmutableList<String> articles) {
        this.linkId = linkId;
        this.value = value;
        this.type = type;
        this.labels = labels;
        this.articles = articles;
    }

    @Override
    @JsonProperty(value="linkId")
    public String getLinkId() {
        return this.linkId;
    }

    @Override
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    @Override
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="labels")
    @Nullable
    public ImmutableList<StencilClient.LocaleLabel> getLabels() {
        return this.labels;
    }

    @JsonProperty(value="articles")
    @Nullable
    public ImmutableList<String> getArticles() {
        return this.articles;
    }

    public final ImmutableLinkMutator withLinkId(String value) {
        String newValue = Objects.requireNonNull(value, "linkId");
        if (this.linkId.equals(newValue)) {
            return this;
        }
        return new ImmutableLinkMutator(newValue, this.value, this.type, this.labels, this.articles);
    }

    public final ImmutableLinkMutator withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableLinkMutator(this.linkId, newValue, this.type, this.labels, this.articles);
    }

    public final ImmutableLinkMutator withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableLinkMutator(this.linkId, this.value, newValue, this.labels, this.articles);
    }

    public final ImmutableLinkMutator withLabels(StencilClient.LocaleLabel ... elements) {
        if (elements == null) {
            return new ImmutableLinkMutator(this.linkId, this.value, this.type, null, this.articles);
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf((Object[])elements);
        return new ImmutableLinkMutator(this.linkId, this.value, this.type, (ImmutableList<StencilClient.LocaleLabel>)newValue, this.articles);
    }

    public final ImmutableLinkMutator withLabels(@Nullable Iterable<? extends StencilClient.LocaleLabel> elements) {
        if (this.labels == elements) {
            return this;
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableLinkMutator(this.linkId, this.value, this.type, (ImmutableList<StencilClient.LocaleLabel>)newValue, this.articles);
    }

    public final ImmutableLinkMutator withArticles(String ... elements) {
        if (elements == null) {
            return new ImmutableLinkMutator(this.linkId, this.value, this.type, this.labels, null);
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf((Object[])elements);
        return new ImmutableLinkMutator(this.linkId, this.value, this.type, this.labels, (ImmutableList<String>)newValue);
    }

    public final ImmutableLinkMutator withArticles(@Nullable Iterable<String> elements) {
        if (this.articles == elements) {
            return this;
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableLinkMutator(this.linkId, this.value, this.type, this.labels, (ImmutableList<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLinkMutator && this.equalTo((ImmutableLinkMutator)another);
    }

    private boolean equalTo(ImmutableLinkMutator another) {
        return this.linkId.equals(another.linkId) && this.value.equals(another.value) && this.type.equals(another.type) && Objects.equals(this.labels, another.labels) && Objects.equals(this.articles, another.articles);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.linkId.hashCode();
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.labels);
        h += (h << 5) + Objects.hashCode(this.articles);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LinkMutator").omitNullValues().add("linkId", (Object)this.linkId).add("value", (Object)this.value).add("type", (Object)this.type).add("labels", this.labels).add("articles", this.articles).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLinkMutator fromJson(Json json) {
        Builder builder = ImmutableLinkMutator.builder();
        if (json.linkId != null) {
            builder.linkId(json.linkId);
        }
        if (json.value != null) {
            builder.value(json.value);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.labels != null) {
            builder.addAllLabels(json.labels);
        }
        if (json.articles != null) {
            builder.addAllArticles(json.articles);
        }
        return builder.build();
    }

    public static ImmutableLinkMutator copyOf(UpdateBuilder.LinkMutator instance) {
        if (instance instanceof ImmutableLinkMutator) {
            return (ImmutableLinkMutator)instance;
        }
        return ImmutableLinkMutator.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="UpdateBuilder.LinkMutator", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LINK_ID = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private static final long INIT_BIT_TYPE = 4L;
        private long initBits = 7L;
        @Nullable
        private String linkId;
        @Nullable
        private String value;
        @Nullable
        private String type;
        private ImmutableList.Builder<StencilClient.LocaleLabel> labels = null;
        private ImmutableList.Builder<String> articles = null;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(UpdateBuilder.LinkMutator instance) {
            List<String> articlesValue;
            Objects.requireNonNull(instance, "instance");
            this.linkId(instance.getLinkId());
            this.value(instance.getValue());
            this.type(instance.getType());
            List<StencilClient.LocaleLabel> labelsValue = instance.getLabels();
            if (labelsValue != null) {
                this.addAllLabels(labelsValue);
            }
            if ((articlesValue = instance.getArticles()) != null) {
                this.addAllArticles(articlesValue);
            }
            return this;
        }

        @JsonProperty(value="linkId")
        @CanIgnoreReturnValue
        public final Builder linkId(String linkId) {
            this.linkId = Objects.requireNonNull(linkId, "linkId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="value")
        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLabels(StencilClient.LocaleLabel element) {
            if (this.labels == null) {
                this.labels = ImmutableList.builder();
            }
            this.labels.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLabels(StencilClient.LocaleLabel ... elements) {
            if (this.labels == null) {
                this.labels = ImmutableList.builder();
            }
            this.labels.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="labels")
        @CanIgnoreReturnValue
        public final Builder labels(@Nullable Iterable<? extends StencilClient.LocaleLabel> elements) {
            if (elements == null) {
                this.labels = null;
                return this;
            }
            this.labels = ImmutableList.builder();
            return this.addAllLabels(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLabels(Iterable<? extends StencilClient.LocaleLabel> elements) {
            Objects.requireNonNull(elements, "labels element");
            if (this.labels == null) {
                this.labels = ImmutableList.builder();
            }
            this.labels.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArticles(String element) {
            if (this.articles == null) {
                this.articles = ImmutableList.builder();
            }
            this.articles.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArticles(String ... elements) {
            if (this.articles == null) {
                this.articles = ImmutableList.builder();
            }
            this.articles.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="articles")
        @CanIgnoreReturnValue
        public final Builder articles(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.articles = null;
                return this;
            }
            this.articles = ImmutableList.builder();
            return this.addAllArticles(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllArticles(Iterable<String> elements) {
            Objects.requireNonNull(elements, "articles element");
            if (this.articles == null) {
                this.articles = ImmutableList.builder();
            }
            this.articles.addAll(elements);
            return this;
        }

        public ImmutableLinkMutator build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLinkMutator(this.linkId, this.value, this.type, (ImmutableList<StencilClient.LocaleLabel>)(this.labels == null ? null : this.labels.build()), this.articles == null ? null : this.articles.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("linkId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build LinkMutator, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="UpdateBuilder.LinkMutator", generator="Immutables")
    static final class Json
    implements UpdateBuilder.LinkMutator {
        @Nullable
        String linkId;
        @Nullable
        String value;
        @Nullable
        String type;
        @Nullable
        List<StencilClient.LocaleLabel> labels = null;
        @Nullable
        List<String> articles = null;

        Json() {
        }

        @JsonProperty(value="linkId")
        public void setLinkId(String linkId) {
            this.linkId = linkId;
        }

        @JsonProperty(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @JsonProperty(value="type")
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty(value="labels")
        public void setLabels(@Nullable List<StencilClient.LocaleLabel> labels) {
            this.labels = labels;
        }

        @JsonProperty(value="articles")
        public void setArticles(@Nullable List<String> articles) {
            this.articles = articles;
        }

        @Override
        public String getLinkId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<StencilClient.LocaleLabel> getLabels() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getArticles() {
            throw new UnsupportedOperationException();
        }
    }
}

