package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CreateBuilder.CreateArticle}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCreateArticle.builder()}.
 */
@Generated(from = "CreateBuilder.CreateArticle", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCreateArticle implements CreateBuilder.CreateArticle {
  private final @Nullable String parentId;
  private final String name;
  private final @Nullable Integer order;

  private ImmutableCreateArticle(
      @Nullable String parentId,
      String name,
      @Nullable Integer order) {
    this.parentId = parentId;
    this.name = name;
    this.order = order;
  }

  /**
   * @return The value of the {@code parentId} attribute
   */
  @JsonProperty("parentId")
  @Override
  public @Nullable String getParentId() {
    return parentId;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code order} attribute
   */
  @JsonProperty("order")
  @Override
  public @Nullable Integer getOrder() {
    return order;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateBuilder.CreateArticle#getParentId() parentId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for parentId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateArticle withParentId(@Nullable String value) {
    if (Objects.equals(this.parentId, value)) return this;
    return new ImmutableCreateArticle(value, this.name, this.order);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateBuilder.CreateArticle#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateArticle withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableCreateArticle(this.parentId, newValue, this.order);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateBuilder.CreateArticle#getOrder() order} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for order (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateArticle withOrder(@Nullable Integer value) {
    if (Objects.equals(this.order, value)) return this;
    return new ImmutableCreateArticle(this.parentId, this.name, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCreateArticle} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCreateArticle
        && equalTo((ImmutableCreateArticle) another);
  }

  private boolean equalTo(ImmutableCreateArticle another) {
    return Objects.equals(parentId, another.parentId)
        && name.equals(another.name)
        && Objects.equals(order, another.order);
  }

  /**
   * Computes a hash code from attributes: {@code parentId}, {@code name}, {@code order}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(parentId);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(order);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateArticle} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CreateArticle")
        .omitNullValues()
        .add("parentId", parentId)
        .add("name", name)
        .add("order", order)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CreateBuilder.CreateArticle", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements CreateBuilder.CreateArticle {
    @Nullable String parentId;
    @Nullable String name;
    @Nullable Integer order;
    @JsonProperty("parentId")
    public void setParentId(@Nullable String parentId) {
      this.parentId = parentId;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("order")
    public void setOrder(@Nullable Integer order) {
      this.order = order;
    }
    @Override
    public String getParentId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getOrder() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCreateArticle fromJson(Json json) {
    ImmutableCreateArticle.Builder builder = ImmutableCreateArticle.builder();
    if (json.parentId != null) {
      builder.parentId(json.parentId);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.order != null) {
      builder.order(json.order);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CreateBuilder.CreateArticle} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CreateArticle instance
   */
  public static ImmutableCreateArticle copyOf(CreateBuilder.CreateArticle instance) {
    if (instance instanceof ImmutableCreateArticle) {
      return (ImmutableCreateArticle) instance;
    }
    return ImmutableCreateArticle.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCreateArticle ImmutableCreateArticle}.
   * <pre>
   * ImmutableCreateArticle.builder()
   *    .parentId(String | null) // nullable {@link CreateBuilder.CreateArticle#getParentId() parentId}
   *    .name(String) // required {@link CreateBuilder.CreateArticle#getName() name}
   *    .order(Integer | null) // nullable {@link CreateBuilder.CreateArticle#getOrder() order}
   *    .build();
   * </pre>
   * @return A new ImmutableCreateArticle builder
   */
  public static ImmutableCreateArticle.Builder builder() {
    return new ImmutableCreateArticle.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCreateArticle ImmutableCreateArticle}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CreateBuilder.CreateArticle", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String parentId;
    private @Nullable String name;
    private @Nullable Integer order;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateArticle} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CreateBuilder.CreateArticle instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String parentIdValue = instance.getParentId();
      if (parentIdValue != null) {
        parentId(parentIdValue);
      }
      name(instance.getName());
      @Nullable Integer orderValue = instance.getOrder();
      if (orderValue != null) {
        order(orderValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuilder.CreateArticle#getParentId() parentId} attribute.
     * @param parentId The value for parentId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("parentId")
    public final Builder parentId(@Nullable String parentId) {
      this.parentId = parentId;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuilder.CreateArticle#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuilder.CreateArticle#getOrder() order} attribute.
     * @param order The value for order (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("order")
    public final Builder order(@Nullable Integer order) {
      this.order = order;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCreateArticle ImmutableCreateArticle}.
     * @return An immutable instance of CreateArticle
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCreateArticle build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCreateArticle(parentId, name, order);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build CreateArticle, some of required attributes are not set " + attributes;
    }
  }
}
