/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.spi.staticontent.visitors;

import io.thestencil.client.api.ImmutableLinkResource;
import io.thestencil.client.api.Markdowns;
import io.thestencil.client.spi.staticontent.visitors.MarkdownException;
import io.thestencil.client.spi.staticontent.visitors.SiteStateVisitor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class CSVLinksVisitor {
    private String file;

    public CSVLinksVisitor(String file) {
        this.file = file;
    }

    public List<Markdowns.LinkResource> visit(byte[] input) {
        InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(input), StandardCharsets.UTF_8);
        CSVParser parser = null;
        try {
            parser = new CSVParser((Reader)reader, CSVFormat.EXCEL.withHeader(new String[0]).withCommentMarker('/').withAllowMissingColumnNames(false).withIgnoreEmptyLines(true));
            List<Markdowns.LinkResource> list = this.visitParser(parser);
            return list;
        }
        catch (Exception e) {
            throw new MarkdownException("Failed to parse links file: '" + this.file + "', error: " + e.getMessage(), e);
        }
        finally {
            try {
                if (parser != null) {
                    parser.close();
                }
                ((Reader)reader).close();
            }
            catch (IOException e) {
                throw new MarkdownException("Failed to parse links file: '" + this.file + "', error: " + e.getMessage(), e);
            }
        }
    }

    private List<Markdowns.LinkResource> visitParser(CSVParser parser) {
        ArrayList<Markdowns.LinkResource> result = new ArrayList<Markdowns.LinkResource>();
        for (CSVRecord record : parser) {
            result.add(this.visitRecord(record));
        }
        return result;
    }

    private Markdowns.LinkResource visitRecord(CSVRecord record) {
        String path = record.get("path");
        String value = record.get("value");
        String type = this.visitType(record);
        return ImmutableLinkResource.builder().id(this.file + "_row_" + record.getRecordNumber()).locale(this.visitLocale(record)).desc(record.get("description")).path(path).value(value).type(type).workflow(SiteStateVisitor.LINK_TYPE_WORKFLOW.equals(type)).global(path == null || path.isBlank()).build();
    }

    private String visitType(CSVRecord record) {
        try {
            String type = record.get("type");
            return type;
        }
        catch (Exception e) {
            throw new MarkdownException("Failed to parse links file: '" + this.file + "',  row: '" + record.getRecordNumber() + "', column: 'type', error: " + e.getMessage(), e);
        }
    }

    private List<String> visitLocale(CSVRecord record) {
        String locale = record.get("locale");
        if (locale.isBlank()) {
            return Collections.emptyList();
        }
        return Arrays.asList(locale.split("\\/"));
    }
}

