/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.spi.staticontent.support;

import java.util.function.Supplier;

public class ParserAssert {
    public static void notEmpty(String object, Supplier<String> message) {
        if (object == null || object.isBlank()) {
            throw new StaticContentParserException(ParserAssert.getMessage(message));
        }
    }

    public static void isEmpty(String object, Supplier<String> message) {
        if (object == null || object.isBlank()) {
            return;
        }
        throw new StaticContentParserException(ParserAssert.getMessage(message));
    }

    public static void notNull(Object object, Supplier<String> message) {
        if (object == null) {
            throw new StaticContentParserException(ParserAssert.getMessage(message));
        }
    }

    public static void isTrue(boolean expression, Supplier<String> message) {
        if (!expression) {
            throw new StaticContentParserException(ParserAssert.getMessage(message));
        }
    }

    private static String getMessage(Supplier<String> supplier) {
        return supplier != null ? supplier.get() : null;
    }

    public static class StaticContentParserException
    extends RuntimeException {
        private static final long serialVersionUID = -16242216446897210L;

        public StaticContentParserException(String message, Throwable cause) {
            super(message, cause);
        }

        public StaticContentParserException(String message) {
            super(message);
        }

        public StaticContentParserException(Throwable cause) {
            super(cause);
        }
    }
}

