/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.spi.exceptions;

import io.resys.thena.docdb.api.actions.RepoActions;
import io.resys.thena.docdb.api.models.Message;

public class RepoException
extends RuntimeException {
    private static final long serialVersionUID = 7190168525508589141L;
    private final String entity;
    private final RepoActions.RepoResult commit;

    public RepoException(String entity, RepoActions.RepoResult commit) {
        super(RepoException.msg(entity, commit));
        this.entity = entity;
        this.commit = commit;
    }

    public String getEntity() {
        return this.entity;
    }

    public RepoActions.RepoResult getCommit() {
        return this.commit;
    }

    private static String msg(String entity, RepoActions.RepoResult commit) {
        StringBuilder messages = new StringBuilder();
        for (Message msg : commit.getMessages()) {
            messages.append(System.lineSeparator()).append("  - ").append(msg.getText());
        }
        return "Error in repository: " + entity + ", because of: " + messages;
    }
}

