/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.spi.builders;

import io.thestencil.client.api.ImmutableArticle;
import io.thestencil.client.api.ImmutableBatchCommand;
import io.thestencil.client.api.ImmutableEntity;
import io.thestencil.client.api.ImmutableLink;
import io.thestencil.client.api.ImmutableLocale;
import io.thestencil.client.api.ImmutableLocaleLabel;
import io.thestencil.client.api.ImmutablePage;
import io.thestencil.client.api.ImmutableWorkflow;
import io.thestencil.client.api.MigrationBuilder;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.api.StencilComposer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MigrationImportVisitorForStaticContent {
    private final StencilClient client;
    private final StencilComposer.SiteState current;
    private final ImmutableBatchCommand.Builder batch;
    private final Map<String, StencilClient.Entity<StencilClient.Article>> articlesByTopicName = new LinkedHashMap<String, StencilClient.Entity<StencilClient.Article>>();
    private final Map<String, StencilClient.Entity<StencilClient.Link>> links = new LinkedHashMap<String, StencilClient.Entity<StencilClient.Link>>();
    private final Map<String, StencilClient.Entity<StencilClient.Workflow>> workflows = new LinkedHashMap<String, StencilClient.Entity<StencilClient.Workflow>>();
    private final Map<String, StencilClient.Entity<StencilClient.Locale>> locales = new LinkedHashMap<String, StencilClient.Entity<StencilClient.Locale>>();
    private final Map<String, StencilClient.Entity<StencilClient.Page>> pages = new LinkedHashMap<String, StencilClient.Entity<StencilClient.Page>>();
    private final List<String> commitedIds = new ArrayList<String>();

    public MigrationImportVisitorForStaticContent(StencilComposer.SiteState current, StencilClient client) {
        this.batch = ImmutableBatchCommand.builder();
        this.current = current;
        this.client = client;
    }

    public ImmutableBatchCommand visit(MigrationBuilder.Sites sites) {
        this.visitCurrentStateStart(this.current);
        for (MigrationBuilder.LocalizedSite localizedSite : sites.getSites().values()) {
            StencilClient.Entity<StencilClient.Locale> locale = this.visitLocale(localizedSite);
            for (MigrationBuilder.Topic topic : localizedSite.getTopics().values()) {
                StencilClient.Entity<StencilClient.Article> article = this.visitArticle(locale, topic, localizedSite);
                MigrationBuilder.TopicBlob blob = localizedSite.getBlobs().get(topic.getBlob());
                if (blob != null) {
                    this.visitPage(article, locale, blob);
                }
                for (String topicLinkId : topic.getLinks()) {
                    MigrationBuilder.TopicLink topicLink = localizedSite.getLinks().get(topicLinkId);
                    if (topicLink.getType().equalsIgnoreCase("workflow") || topicLink.getType().equalsIgnoreCase("dialob")) {
                        this.visitWorkflow(topicLink, locale, article);
                        continue;
                    }
                    this.visitLink(topicLink, locale, article);
                }
            }
        }
        for (StencilClient.Entity entity : this.links.values()) {
            this.visitCommit(entity);
        }
        for (StencilClient.Entity entity : this.workflows.values()) {
            this.visitCommit(entity);
        }
        this.visitCurrentStateEnd(this.current);
        return this.batch.build();
    }

    private void visitCurrentStateStart(StencilComposer.SiteState current) {
        current.getLocales().values().stream().forEach(e -> this.locales.put(((StencilClient.Locale)e.getBody()).getValue(), (StencilClient.Entity<StencilClient.Locale>)e));
        current.getPages().values().stream().forEach(e -> {
            this.pages.put(this.pageId((StencilClient.Entity<StencilClient.Page>)e), (StencilClient.Entity<StencilClient.Page>)e);
            this.visitCommit((StencilClient.Entity<?>)e);
        });
        current.getArticles().values().stream().forEach(e -> {
            this.articlesByTopicName.put(((StencilClient.Article)e.getBody()).getName(), (StencilClient.Entity<StencilClient.Article>)e);
            this.visitCommit((StencilClient.Entity<?>)e);
        });
        current.getLinks().values().stream().forEach(e -> {
            String topicLinkId = this.topicLinkId((StencilClient.Entity<StencilClient.Link>)e);
            this.links.put(topicLinkId, (StencilClient.Entity<StencilClient.Link>)e);
        });
        current.getWorkflows().values().stream().forEach(e -> {
            String topicLinkId = this.workflowId((StencilClient.Entity<StencilClient.Workflow>)e);
            this.workflows.put(topicLinkId, (StencilClient.Entity<StencilClient.Workflow>)e);
        });
    }

    private void visitCurrentStateEnd(StencilComposer.SiteState current) {
        current.getLocales().values().stream().filter(e -> !this.commitedIds.contains(e.getId())).forEach(e -> this.batch.addToBeDeleted((StencilClient.Entity)e));
        current.getPages().values().stream().filter(e -> !this.commitedIds.contains(e.getId())).forEach(e -> this.batch.addToBeDeleted((StencilClient.Entity)e));
        current.getLinks().values().stream().filter(e -> !this.commitedIds.contains(e.getId())).forEach(e -> this.batch.addToBeDeleted((StencilClient.Entity)e));
        current.getArticles().values().stream().filter(e -> !this.commitedIds.contains(e.getId())).forEach(e -> this.batch.addToBeDeleted((StencilClient.Entity)e));
        current.getWorkflows().values().stream().filter(e -> !this.commitedIds.contains(e.getId())).forEach(e -> this.batch.addToBeDeleted((StencilClient.Entity)e));
    }

    private void visitCommit(StencilClient.Entity<?> entity) {
        if (this.commitedIds.contains(entity.getId())) {
            throw new IllegalArgumentException("id already in commit: " + entity.getId());
        }
        this.commitedIds.add(entity.getId());
        this.batch.addToBeCreated((StencilClient.Entity)entity);
    }

    private StencilClient.Entity<StencilClient.Workflow> visitWorkflow(MigrationBuilder.TopicLink topicLink, StencilClient.Entity<StencilClient.Locale> locale, StencilClient.Entity<StencilClient.Article> article) {
        String topicLinkId = this.workflowId(topicLink);
        ArrayList<String> articles = new ArrayList<String>();
        if (this.workflows.containsKey(topicLinkId)) {
            Optional<StencilClient.LocaleLabel> duplicate;
            StencilClient.Entity<StencilClient.Workflow> created = this.workflows.get(topicLinkId);
            articles.addAll(created.getBody().getArticles());
            if (!articles.contains(article.getId())) {
                articles.add(article.getId());
            }
            if ((duplicate = created.getBody().getLabels().stream().filter(label -> label.getLocale().equals(locale.getId())).findFirst()).isEmpty()) {
                ImmutableEntity<StencilClient.Workflow> next = ImmutableEntity.builder().from(created).body(ImmutableWorkflow.builder().from(created.getBody()).articles(articles).addLabels((StencilClient.LocaleLabel)ImmutableLocaleLabel.builder().labelValue(topicLink.getName()).locale(locale.getId()).build()).build()).build();
                this.workflows.put(topicLinkId, next);
                return next;
            }
            ImmutableEntity<StencilClient.Workflow> next = ImmutableEntity.builder().from(created).body(ImmutableWorkflow.builder().from(created.getBody()).articles(articles).build()).build();
            this.workflows.put(topicLinkId, next);
            return next;
        }
        String gid = this.gid(StencilClient.EntityType.WORKFLOW);
        articles.add(article.getId());
        ImmutableWorkflow workflow = ImmutableWorkflow.builder().value(topicLink.getValue()).addLabels((StencilClient.LocaleLabel)ImmutableLocaleLabel.builder().labelValue(topicLink.getName()).locale(locale.getId()).build()).articles(Boolean.TRUE.equals(topicLink.getGlobal()) ? Collections.emptyList() : articles).build();
        ImmutableEntity<StencilClient.Workflow> entity = ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.WORKFLOW).body(workflow).build();
        this.workflows.put(topicLinkId, entity);
        return entity;
    }

    private StencilClient.Entity<StencilClient.Link> visitLink(MigrationBuilder.TopicLink topicLink, StencilClient.Entity<StencilClient.Locale> locale, StencilClient.Entity<StencilClient.Article> article) {
        String topicLinkId = this.topicLinkId(topicLink);
        ArrayList<String> articles = new ArrayList<String>();
        if (this.links.containsKey(topicLinkId)) {
            Optional<StencilClient.LocaleLabel> duplicate;
            StencilClient.Entity<StencilClient.Link> created = this.links.get(topicLinkId);
            articles.addAll(created.getBody().getArticles());
            if (!articles.contains(article.getId())) {
                articles.add(article.getId());
            }
            if ((duplicate = created.getBody().getLabels().stream().filter(label -> label.getLocale().equals(locale.getId())).findFirst()).isEmpty()) {
                ImmutableEntity<StencilClient.Link> next = ImmutableEntity.builder().from(created).body(ImmutableLink.builder().from(created.getBody()).articles(articles).addLabels((StencilClient.LocaleLabel)ImmutableLocaleLabel.builder().labelValue(topicLink.getName()).locale(locale.getId()).build()).build()).build();
                this.links.put(topicLinkId, next);
                return next;
            }
            ImmutableEntity<StencilClient.Link> next = ImmutableEntity.builder().from(created).body(ImmutableLink.builder().from(created.getBody()).articles(articles).build()).build();
            this.links.put(topicLinkId, next);
            return next;
        }
        String gid = this.gid(StencilClient.EntityType.LINK);
        articles.add(article.getId());
        ImmutableLink link = ImmutableLink.builder().contentType(topicLink.getType()).value(topicLink.getValue()).addLabels((StencilClient.LocaleLabel)ImmutableLocaleLabel.builder().labelValue(topicLink.getName()).locale(locale.getId()).build()).articles(Boolean.TRUE.equals(topicLink.getGlobal()) ? Collections.emptyList() : articles).build();
        ImmutableEntity<StencilClient.Link> entity = ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.LINK).body(link).build();
        this.links.put(topicLinkId, entity);
        return entity;
    }

    private String topicLinkId(MigrationBuilder.TopicLink topicLink) {
        return topicLink.getType() + "::" + topicLink.getValue();
    }

    private String topicLinkId(StencilClient.Entity<StencilClient.Link> topicLink) {
        return topicLink.getBody().getContentType() + "::" + topicLink.getBody().getValue();
    }

    private String workflowId(MigrationBuilder.TopicLink topicLink) {
        return "workflow::" + topicLink.getValue();
    }

    private String workflowId(StencilClient.Entity<StencilClient.Workflow> topicLink) {
        return "workflow::" + topicLink.getBody().getValue();
    }

    private String pageId(StencilClient.Entity<StencilClient.Page> page) {
        return page.getBody().getArticle() + "::" + page.getBody().getLocale();
    }

    private StencilClient.Entity<StencilClient.Page> visitPage(StencilClient.Entity<StencilClient.Article> article, StencilClient.Entity<StencilClient.Locale> locale, MigrationBuilder.TopicBlob topic) {
        String gid = this.gid(StencilClient.EntityType.PAGE);
        ImmutablePage page = ImmutablePage.builder().article(article.getId()).locale(locale.getId()).content(Optional.ofNullable(topic.getValue()).orElse("")).build();
        ImmutableEntity<StencilClient.Page> entity = ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.PAGE).body(page).build();
        String pageId = this.pageId(entity);
        if (this.pages.containsKey(pageId)) {
            ImmutableEntity<StencilClient.Page> result = ImmutableEntity.builder().from(this.pages.get(pageId)).body(page).build();
            return result;
        }
        this.pages.put(pageId, entity);
        this.visitCommit(entity);
        return entity;
    }

    private StencilClient.Entity<StencilClient.Article> visitArticle(StencilClient.Entity<StencilClient.Locale> locale, MigrationBuilder.Topic topic, MigrationBuilder.LocalizedSite site) {
        String name = null;
        name = topic.getParent() != null && topic.getId().startsWith(topic.getParent()) ? topic.getId().substring(topic.getParent().length() + 1) : topic.getId();
        int order = 0;
        try {
            order = Integer.parseInt(name.substring(0, 3));
            name = name.substring(4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String parentId = topic.getParent() != null && topic.getId().startsWith(topic.getParent()) ? this.visitArticle(locale, site.getTopics().get(topic.getParent()), site).getId() : null;
        if (this.articlesByTopicName.containsKey(name)) {
            ImmutableArticle article = ImmutableArticle.builder().name(name).parentId(parentId).order(order).build();
            ImmutableEntity<StencilClient.Article> entity = ImmutableEntity.builder().from(this.articlesByTopicName.get(name)).body(article).build();
            return this.articlesByTopicName.put(article.getName(), entity);
        }
        String gid = this.gid(StencilClient.EntityType.ARTICLE);
        ImmutableArticle article = ImmutableArticle.builder().name(name).parentId(parentId).order(order).build();
        ImmutableEntity<StencilClient.Article> entity = ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.ARTICLE).body(article).build();
        this.articlesByTopicName.put(name, entity);
        this.visitCommit(entity);
        return entity;
    }

    private StencilClient.Entity<StencilClient.Locale> visitLocale(MigrationBuilder.LocalizedSite site) {
        if (this.locales.containsKey(site.getLocale())) {
            StencilClient.Entity<StencilClient.Locale> entity = this.locales.get(site.getLocale());
            this.visitCommit(entity);
            return entity;
        }
        String gid = this.gid(StencilClient.EntityType.LOCALE);
        ImmutableLocale locale = ImmutableLocale.builder().value(site.getLocale()).enabled(true).build();
        ImmutableEntity<StencilClient.Locale> entity = ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.LOCALE).body(locale).build();
        this.visitCommit(entity);
        return entity;
    }

    private String gid(StencilClient.EntityType type) {
        return this.client.getStore().gid(type);
    }
}

