/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.spi.builders;

import io.thestencil.client.api.ImmutableArticle;
import io.thestencil.client.api.ImmutableBatchCommand;
import io.thestencil.client.api.ImmutableEntity;
import io.thestencil.client.api.ImmutableLink;
import io.thestencil.client.api.ImmutableLocale;
import io.thestencil.client.api.ImmutableLocaleLabel;
import io.thestencil.client.api.ImmutablePage;
import io.thestencil.client.api.ImmutableWorkflow;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.api.StencilComposer;
import io.thestencil.client.api.StencilStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class MigrationImportVisitorForSiteState {
    private final ImmutableBatchCommand.Builder batch;
    private final StencilComposer.SiteState current;
    private final Map<String, StencilClient.Entity<StencilClient.Article>> articlesByTopicName = new LinkedHashMap<String, StencilClient.Entity<StencilClient.Article>>();
    private final Map<String, StencilClient.Entity<StencilClient.Link>> links = new LinkedHashMap<String, StencilClient.Entity<StencilClient.Link>>();
    private final Map<String, StencilClient.Entity<StencilClient.Workflow>> workflows = new LinkedHashMap<String, StencilClient.Entity<StencilClient.Workflow>>();
    private final Map<String, StencilClient.Entity<StencilClient.Locale>> locales = new LinkedHashMap<String, StencilClient.Entity<StencilClient.Locale>>();
    private final Map<String, StencilClient.Entity<StencilClient.Page>> pages = new LinkedHashMap<String, StencilClient.Entity<StencilClient.Page>>();
    private final Map<String, String> idMap = new HashMap<String, String>();
    private final List<String> commitedIds = new ArrayList<String>();

    public MigrationImportVisitorForSiteState(StencilComposer.SiteState current) {
        this.current = current;
        this.batch = ImmutableBatchCommand.builder();
    }

    public StencilStore.BatchCommand visit(StencilComposer.SiteState sites) {
        this.visitCurrentStateStart(this.current);
        sites.getLocales().forEach((id, locale) -> this.visitLocale((StencilClient.Entity<StencilClient.Locale>)locale));
        sites.getArticles().forEach((id, article) -> this.visitArticle((StencilClient.Entity<StencilClient.Article>)article));
        sites.getPages().forEach((id, page) -> this.visitPage((StencilClient.Entity<StencilClient.Page>)page));
        sites.getWorkflows().forEach((id, workflow) -> this.visitWorkflow((StencilClient.Entity<StencilClient.Workflow>)workflow));
        sites.getLinks().forEach((id, link) -> this.visitLink((StencilClient.Entity<StencilClient.Link>)link));
        this.visitCurrentStateEnd(this.current);
        return this.batch.build();
    }

    private void visitCurrentStateStart(StencilComposer.SiteState current) {
        current.getLocales().values().stream().forEach(e -> {
            this.locales.put(((StencilClient.Locale)e.getBody()).getValue(), (StencilClient.Entity<StencilClient.Locale>)e);
            this.visitCommit((StencilClient.Entity<?>)e);
        });
        current.getPages().values().stream().forEach(e -> {
            this.pages.put(this.pageId((StencilClient.Entity<StencilClient.Page>)e), (StencilClient.Entity<StencilClient.Page>)e);
            this.visitCommit((StencilClient.Entity<?>)e);
        });
        current.getArticles().values().stream().forEach(e -> {
            this.articlesByTopicName.put(((StencilClient.Article)e.getBody()).getName(), (StencilClient.Entity<StencilClient.Article>)e);
            this.visitCommit((StencilClient.Entity<?>)e);
        });
        current.getLinks().values().stream().forEach(e -> {
            String topicLinkId = this.topicLinkId((StencilClient.Entity<StencilClient.Link>)e);
            this.links.put(topicLinkId, (StencilClient.Entity<StencilClient.Link>)e);
            this.visitCommit((StencilClient.Entity<?>)e);
        });
        current.getWorkflows().values().stream().forEach(e -> {
            String topicLinkId = this.workflowId((StencilClient.Entity<StencilClient.Workflow>)e);
            this.workflows.put(topicLinkId, (StencilClient.Entity<StencilClient.Workflow>)e);
            this.visitCommit((StencilClient.Entity<?>)e);
        });
    }

    private void visitCurrentStateEnd(StencilComposer.SiteState current) {
        current.getLocales().values().stream().filter(e -> !this.commitedIds.contains(e.getId())).forEach(e -> this.batch.addToBeDeleted((StencilClient.Entity)e));
        current.getPages().values().stream().filter(e -> !this.commitedIds.contains(e.getId())).forEach(e -> this.batch.addToBeDeleted((StencilClient.Entity)e));
        current.getLinks().values().stream().filter(e -> !this.commitedIds.contains(e.getId())).forEach(e -> this.batch.addToBeDeleted((StencilClient.Entity)e));
        current.getArticles().values().stream().filter(e -> !this.commitedIds.contains(e.getId())).forEach(e -> this.batch.addToBeDeleted((StencilClient.Entity)e));
        current.getWorkflows().values().stream().filter(e -> !this.commitedIds.contains(e.getId())).forEach(e -> this.batch.addToBeDeleted((StencilClient.Entity)e));
    }

    private void visitCommit(StencilClient.Entity<?> entity) {
        if (this.commitedIds.contains(entity.getId())) {
            throw new IllegalArgumentException("id already in commit: " + entity.getId());
        }
        this.commitedIds.add(entity.getId());
        this.batch.addToBeCreated((StencilClient.Entity)entity);
    }

    private StencilClient.Entity<StencilClient.Workflow> visitWorkflow(StencilClient.Entity<StencilClient.Workflow> input) {
        String workflowId = this.workflowId(input);
        List<String> newArticles = input.getBody().getArticles().stream().map(e -> this.getSavedId((String)e)).collect(Collectors.toList());
        if (this.workflows.containsKey(workflowId)) {
            StencilClient.Entity<StencilClient.Workflow> created = this.workflows.get(workflowId);
            List<String> articles = this.merge((Collection<String>)created.getBody().getArticles(), (Collection<String>)newArticles);
            ImmutableEntity<StencilClient.Workflow> next = ImmutableEntity.builder().from(created).body(ImmutableWorkflow.builder().from(created.getBody()).articles(articles).addAllLabels(this.merge(created.getBody().getLabels(), input.getBody().getLabels())).build()).build();
            this.idMap.put(input.getId(), created.getId());
            this.workflows.put(workflowId, next);
            return next;
        }
        String gid = input.getId();
        ImmutableWorkflow workflow = ImmutableWorkflow.builder().value(input.getBody().getValue()).addAllLabels(input.getBody().getLabels().stream().map(label -> ImmutableLocaleLabel.builder().labelValue(label.getLabelValue()).locale(this.getSavedId(label.getLocale())).build()).collect(Collectors.toList())).articles(newArticles).build();
        ImmutableEntity<StencilClient.Workflow> entity = ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.WORKFLOW).body(workflow).build();
        this.workflows.put(workflowId, entity);
        this.visitCommit(entity);
        return entity;
    }

    private StencilClient.Entity<StencilClient.Link> visitLink(StencilClient.Entity<StencilClient.Link> input) {
        String topicLinkId = this.topicLinkId(input);
        List<String> newArticles = input.getBody().getArticles().stream().map(e -> this.getSavedId((String)e)).collect(Collectors.toList());
        if (this.links.containsKey(topicLinkId)) {
            StencilClient.Entity<StencilClient.Link> created = this.links.get(topicLinkId);
            List<String> articles = this.merge((Collection<String>)created.getBody().getArticles(), (Collection<String>)newArticles);
            ImmutableEntity<StencilClient.Link> next = ImmutableEntity.builder().from(created).body(ImmutableLink.builder().from(created.getBody()).articles(articles).addAllLabels(this.merge(created.getBody().getLabels(), input.getBody().getLabels())).build()).build();
            this.links.put(topicLinkId, next);
            return next;
        }
        String gid = input.getId();
        ImmutableLink link = ImmutableLink.builder().contentType(input.getBody().getContentType()).value(input.getBody().getValue()).addAllLabels(input.getBody().getLabels().stream().map(label -> ImmutableLocaleLabel.builder().labelValue(label.getLabelValue()).locale(this.getSavedId(label.getLocale())).build()).collect(Collectors.toList())).articles(newArticles).build();
        ImmutableEntity<StencilClient.Link> entity = ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.LINK).body(link).build();
        this.links.put(topicLinkId, entity);
        this.visitCommit(entity);
        return entity;
    }

    private String topicLinkId(StencilClient.Entity<StencilClient.Link> topicLink) {
        return topicLink.getBody().getContentType() + "::" + topicLink.getBody().getValue();
    }

    private String workflowId(StencilClient.Entity<StencilClient.Workflow> topicLink) {
        return "workflow::" + topicLink.getBody().getValue();
    }

    private String pageId(StencilClient.Entity<StencilClient.Page> page) {
        return page.getBody().getArticle() + "::" + page.getBody().getLocale();
    }

    private StencilClient.Entity<StencilClient.Page> visitPage(StencilClient.Entity<StencilClient.Page> input) {
        String gid = input.getId();
        ImmutablePage page = ImmutablePage.builder().article(this.getSavedId(input.getBody().getArticle())).locale(this.getSavedId(input.getBody().getLocale())).content(Optional.ofNullable(input.getBody().getContent()).orElse("")).build();
        ImmutableEntity<StencilClient.Page> entity = ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.PAGE).body(page).build();
        String pageId = this.pageId(entity);
        if (this.pages.containsKey(pageId)) {
            StencilClient.Entity<StencilClient.Page> old = this.pages.get(pageId);
            this.idMap.put(input.getId(), old.getId());
            ImmutableEntity<StencilClient.Page> result = ImmutableEntity.builder().from(old).body(page).build();
            return result;
        }
        this.pages.put(pageId, entity);
        this.visitCommit(entity);
        return entity;
    }

    private StencilClient.Entity<StencilClient.Article> visitArticle(StencilClient.Entity<StencilClient.Article> input) {
        String name = input.getBody().getName();
        String parentId = this.getSavedId(input.getBody().getParentId());
        Integer order = input.getBody().getOrder();
        String gid = input.getId();
        if (this.articlesByTopicName.containsKey(name)) {
            StencilClient.Entity<StencilClient.Article> old = this.articlesByTopicName.get(name);
            ImmutableArticle article = ImmutableArticle.builder().name(name).parentId(parentId).order(order).build();
            ImmutableEntity<StencilClient.Article> entity = ImmutableEntity.builder().from(old).body(article).build();
            this.idMap.put(gid, old.getId());
            return this.articlesByTopicName.put(article.getName(), entity);
        }
        ImmutableArticle article = ImmutableArticle.builder().name(name).parentId(parentId).order(order).build();
        ImmutableEntity<StencilClient.Article> entity = ImmutableEntity.builder().id(gid).type(StencilClient.EntityType.ARTICLE).body(article).build();
        this.articlesByTopicName.put(name, entity);
        this.visitCommit(entity);
        return entity;
    }

    private StencilClient.Entity<StencilClient.Locale> visitLocale(StencilClient.Entity<StencilClient.Locale> input) {
        if (this.locales.containsKey(input.getBody().getValue())) {
            StencilClient.Entity<StencilClient.Locale> old = this.locales.get(input.getBody().getValue());
            this.idMap.put(input.getId(), old.getId());
            return old;
        }
        ImmutableLocale locale = ImmutableLocale.builder().value(input.getBody().getValue()).enabled(true).build();
        ImmutableEntity<StencilClient.Locale> entity = ImmutableEntity.builder().id(input.getId()).type(StencilClient.EntityType.LOCALE).body(locale).build();
        this.locales.put(input.getBody().getValue(), entity);
        this.visitCommit(entity);
        return entity;
    }

    private List<String> merge(Collection<String> input1, Collection<String> input2) {
        ArrayList<String> result = new ArrayList<String>();
        for (String val : input1) {
            if (result.contains(val)) continue;
            result.add(val);
        }
        for (String val : input2) {
            if (result.contains(val)) continue;
            result.add(val);
        }
        return result;
    }

    private Collection<StencilClient.LocaleLabel> merge(List<StencilClient.LocaleLabel> oldEntries, List<StencilClient.LocaleLabel> newEntries) {
        LinkedHashMap<String, StencilClient.LocaleLabel> labels = new LinkedHashMap<String, StencilClient.LocaleLabel>();
        for (StencilClient.LocaleLabel entry : oldEntries) {
            labels.put(entry.getLocale(), entry);
        }
        for (StencilClient.LocaleLabel entry : newEntries) {
            String id = this.getSavedId(entry.getLocale());
            labels.put(id, entry);
        }
        return labels.values();
    }

    private String getSavedId(String gid) {
        if (this.idMap.containsKey(gid)) {
            return this.idMap.get(gid);
        }
        return gid;
    }
}

