/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.spi.builders;

import io.smallrye.mutiny.Uni;
import io.thestencil.client.api.ImmutableArticle;
import io.thestencil.client.api.ImmutableBatchCommand;
import io.thestencil.client.api.ImmutableEntity;
import io.thestencil.client.api.ImmutableLink;
import io.thestencil.client.api.ImmutableWorkflow;
import io.thestencil.client.api.StencilClient;
import io.thestencil.client.api.StencilComposer;
import io.thestencil.client.spi.StencilAssert;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ArticleDeleteVisitor {
    private final StencilClient client;
    private final String articleId;

    public Uni<StencilClient.Entity<StencilClient.Article>> visit() {
        return this.client.getStore().query().head().onItem().transformToUni(state -> this.visitObjects((StencilComposer.SiteState)state));
    }

    private Uni<StencilClient.Entity<StencilClient.Article>> visitObjects(StencilComposer.SiteState state) {
        StencilClient.Entity<StencilClient.Article> start = this.visitArticleId(state, this.articleId);
        ImmutableBatchCommand.Builder updateCommand = ImmutableBatchCommand.builder();
        for (StencilClient.Entity<StencilClient.Page> entity : state.getPages().values()) {
            this.visitPage(entity).ifPresent(changeEntity -> updateCommand.addToBeDeleted((StencilClient.Entity)changeEntity));
        }
        for (StencilClient.Entity<StencilClient.EntityBody> entity : state.getWorkflows().values()) {
            this.visitWorkflow(entity).ifPresent(changeEntity -> updateCommand.addToBeSaved((StencilClient.Entity)changeEntity));
        }
        for (StencilClient.Entity<StencilClient.EntityBody> entity : state.getLinks().values()) {
            this.visitLink(entity).ifPresent(changeEntity -> updateCommand.addToBeSaved((StencilClient.Entity)changeEntity));
        }
        updateCommand.addToBeDeleted((StencilClient.Entity)start);
        ArrayList changedArticles = new ArrayList();
        for (StencilClient.Entity<StencilClient.Article> article : state.getArticles().values()) {
            if (article.getId().equals(this.articleId)) continue;
            this.visitArticle(article).ifPresent(changeEntity -> {
                changedArticles.add(changeEntity);
                updateCommand.addToBeSaved((StencilClient.Entity)changeEntity);
            });
        }
        return this.client.getStore().batch(updateCommand.build()).onItem().transform(updated -> start);
    }

    public Optional<StencilClient.Entity<StencilClient.Article>> visitArticle(StencilClient.Entity<StencilClient.Article> start) {
        if (start.getBody().getParentId() != null && start.getBody().getParentId().equals(this.articleId)) {
            return Optional.of(ImmutableEntity.builder().id(start.getId()).type(start.getType()).body(ImmutableArticle.builder().from(start.getBody()).parentId(null).build()).build());
        }
        return Optional.empty();
    }

    public Optional<StencilClient.Entity<?>> visitLink(StencilClient.Entity<StencilClient.Link> start) {
        List<String> newArticles = start.getBody().getArticles().stream().filter(a -> !a.equals(this.articleId)).collect(Collectors.toList());
        if (newArticles.size() == start.getBody().getArticles().size()) {
            return Optional.empty();
        }
        return Optional.of(ImmutableEntity.builder().id(start.getId()).type(start.getType()).body(ImmutableLink.builder().from(start.getBody()).articles(newArticles).build()).build());
    }

    public Optional<StencilClient.Entity<?>> visitPage(StencilClient.Entity<StencilClient.Page> page) {
        if (page.getBody().getArticle().equals(this.articleId)) {
            return Optional.of(page);
        }
        return Optional.empty();
    }

    public Optional<StencilClient.Entity<?>> visitWorkflow(StencilClient.Entity<StencilClient.Workflow> start) {
        List<String> newArticles = start.getBody().getArticles().stream().filter(a -> !a.equals(this.articleId)).collect(Collectors.toList());
        if (newArticles.size() == start.getBody().getArticles().size()) {
            return Optional.empty();
        }
        return Optional.of(ImmutableEntity.builder().id(start.getId()).type(start.getType()).body(ImmutableWorkflow.builder().from(start.getBody()).articles(newArticles).build()).build());
    }

    private StencilClient.Entity<StencilClient.Article> visitArticleId(StencilComposer.SiteState state, String articleId) {
        StencilClient.Entity<StencilClient.Article> article = state.getArticles().get(articleId);
        StencilAssert.isTrue(article != null, () -> "Can't find article with id: '" + articleId + "'");
        return article;
    }

    public ArticleDeleteVisitor(StencilClient client, String articleId) {
        this.client = client;
        this.articleId = articleId;
    }
}

