/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.client.api.StencilClient;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StencilClient.VersionInfo", generator="Immutables")
@Immutable
public final class ImmutableVersionInfo
implements StencilClient.VersionInfo {
    private final String version;
    private final String date;

    private ImmutableVersionInfo(String version, String date) {
        this.version = version;
        this.date = date;
    }

    @Override
    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="date")
    public String getDate() {
        return this.date;
    }

    public final ImmutableVersionInfo withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (this.version.equals(newValue)) {
            return this;
        }
        return new ImmutableVersionInfo(newValue, this.date);
    }

    public final ImmutableVersionInfo withDate(String value) {
        String newValue = Objects.requireNonNull(value, "date");
        if (this.date.equals(newValue)) {
            return this;
        }
        return new ImmutableVersionInfo(this.version, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableVersionInfo && this.equalTo((ImmutableVersionInfo)another);
    }

    private boolean equalTo(ImmutableVersionInfo another) {
        return this.version.equals(another.version) && this.date.equals(another.date);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.date.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"VersionInfo").omitNullValues().add("version", (Object)this.version).add("date", (Object)this.date).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableVersionInfo fromJson(Json json) {
        Builder builder = ImmutableVersionInfo.builder();
        if (json.version != null) {
            builder.version(json.version);
        }
        if (json.date != null) {
            builder.date(json.date);
        }
        return builder.build();
    }

    public static ImmutableVersionInfo copyOf(StencilClient.VersionInfo instance) {
        if (instance instanceof ImmutableVersionInfo) {
            return (ImmutableVersionInfo)instance;
        }
        return ImmutableVersionInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StencilClient.VersionInfo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VERSION = 1L;
        private static final long INIT_BIT_DATE = 2L;
        private long initBits = 3L;
        @Nullable
        private String version;
        @Nullable
        private String date;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StencilClient.VersionInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.version(instance.getVersion());
            this.date(instance.getDate());
            return this;
        }

        @JsonProperty(value="version")
        @CanIgnoreReturnValue
        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="date")
        @CanIgnoreReturnValue
        public final Builder date(String date) {
            this.date = Objects.requireNonNull(date, "date");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableVersionInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableVersionInfo(this.version, this.date);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("version");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("date");
            }
            return "Cannot build VersionInfo, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="StencilClient.VersionInfo", generator="Immutables")
    static final class Json
    implements StencilClient.VersionInfo {
        @Nullable
        String version;
        @Nullable
        String date;

        Json() {
        }

        @JsonProperty(value="version")
        public void setVersion(String version) {
            this.version = version;
        }

        @JsonProperty(value="date")
        public void setDate(String date) {
            this.date = date;
        }

        @Override
        public String getVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDate() {
            throw new UnsupportedOperationException();
        }
    }
}

