/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.client.api.Markdowns;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Markdowns.Markdown", generator="Immutables")
@Immutable
public final class ImmutableMarkdown
implements Markdowns.Markdown {
    private final String locale;
    private final String path;
    private final String value;
    private final ImmutableList<Markdowns.Heading> headings;
    private final ImmutableList<Markdowns.ImageTag> images;

    private ImmutableMarkdown(String locale, String path, String value, ImmutableList<Markdowns.Heading> headings, ImmutableList<Markdowns.ImageTag> images) {
        this.locale = locale;
        this.path = path;
        this.value = value;
        this.headings = headings;
        this.images = images;
    }

    @Override
    public String getLocale() {
        return this.locale;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public ImmutableList<Markdowns.Heading> getHeadings() {
        return this.headings;
    }

    public ImmutableList<Markdowns.ImageTag> getImages() {
        return this.images;
    }

    public final ImmutableMarkdown withLocale(String value) {
        String newValue = Objects.requireNonNull(value, "locale");
        if (this.locale.equals(newValue)) {
            return this;
        }
        return new ImmutableMarkdown(newValue, this.path, this.value, this.headings, this.images);
    }

    public final ImmutableMarkdown withPath(String value) {
        String newValue = Objects.requireNonNull(value, "path");
        if (this.path.equals(newValue)) {
            return this;
        }
        return new ImmutableMarkdown(this.locale, newValue, this.value, this.headings, this.images);
    }

    public final ImmutableMarkdown withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableMarkdown(this.locale, this.path, newValue, this.headings, this.images);
    }

    public final ImmutableMarkdown withHeadings(Markdowns.Heading ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableMarkdown(this.locale, this.path, this.value, (ImmutableList<Markdowns.Heading>)newValue, this.images);
    }

    public final ImmutableMarkdown withHeadings(Iterable<? extends Markdowns.Heading> elements) {
        if (this.headings == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMarkdown(this.locale, this.path, this.value, (ImmutableList<Markdowns.Heading>)newValue, this.images);
    }

    public final ImmutableMarkdown withImages(Markdowns.ImageTag ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableMarkdown(this.locale, this.path, this.value, this.headings, (ImmutableList<Markdowns.ImageTag>)newValue);
    }

    public final ImmutableMarkdown withImages(Iterable<? extends Markdowns.ImageTag> elements) {
        if (this.images == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMarkdown(this.locale, this.path, this.value, this.headings, (ImmutableList<Markdowns.ImageTag>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMarkdown && this.equalTo((ImmutableMarkdown)another);
    }

    private boolean equalTo(ImmutableMarkdown another) {
        return this.locale.equals(another.locale) && this.path.equals(another.path) && this.value.equals(another.value) && this.headings.equals(another.headings) && this.images.equals(another.images);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.locale.hashCode();
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.headings.hashCode();
        h += (h << 5) + this.images.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Markdown").omitNullValues().add("locale", (Object)this.locale).add("path", (Object)this.path).add("value", (Object)this.value).add("headings", this.headings).add("images", this.images).toString();
    }

    public static ImmutableMarkdown copyOf(Markdowns.Markdown instance) {
        if (instance instanceof ImmutableMarkdown) {
            return (ImmutableMarkdown)instance;
        }
        return ImmutableMarkdown.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Markdowns.Markdown", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LOCALE = 1L;
        private static final long INIT_BIT_PATH = 2L;
        private static final long INIT_BIT_VALUE = 4L;
        private long initBits = 7L;
        @Nullable
        private String locale;
        @Nullable
        private String path;
        @Nullable
        private String value;
        private ImmutableList.Builder<Markdowns.Heading> headings = ImmutableList.builder();
        private ImmutableList.Builder<Markdowns.ImageTag> images = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Markdowns.Markdown instance) {
            Objects.requireNonNull(instance, "instance");
            this.locale(instance.getLocale());
            this.path(instance.getPath());
            this.value(instance.getValue());
            this.addAllHeadings(instance.getHeadings());
            this.addAllImages(instance.getImages());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder locale(String locale) {
            this.locale = Objects.requireNonNull(locale, "locale");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder path(String path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addHeadings(Markdowns.Heading element) {
            this.headings.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addHeadings(Markdowns.Heading ... elements) {
            this.headings.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder headings(Iterable<? extends Markdowns.Heading> elements) {
            this.headings = ImmutableList.builder();
            return this.addAllHeadings(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllHeadings(Iterable<? extends Markdowns.Heading> elements) {
            this.headings.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addImages(Markdowns.ImageTag element) {
            this.images.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addImages(Markdowns.ImageTag ... elements) {
            this.images.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder images(Iterable<? extends Markdowns.ImageTag> elements) {
            this.images = ImmutableList.builder();
            return this.addAllImages(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllImages(Iterable<? extends Markdowns.ImageTag> elements) {
            this.images.addAll(elements);
            return this;
        }

        public ImmutableMarkdown build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMarkdown(this.locale, this.path, this.value, (ImmutableList<Markdowns.Heading>)this.headings.build(), (ImmutableList<Markdowns.ImageTag>)this.images.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("locale");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("path");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build Markdown, some of required attributes are not set " + attributes;
        }
    }
}

